/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import com.facebook.presto.hive.;
import java.util.Properties;
import org.apache.logging.log4j.Level;

public class CommonCliOptions {
    protected final .Options OPTIONS = new .Options();
    protected .CommandLine commandLine;
    protected final String cliname;
    private boolean verbose = false;

    public CommonCliOptions(String cliname, boolean includeHiveConf) {
        this.cliname = cliname;
        this.OPTIONS.addOption(new .Option("v", "verbose", false, "Verbose mode"));
        this.OPTIONS.addOption(new .Option("h", "help", false, "Print help information"));
        if (includeHiveConf) {
            .OptionBuilder.withValueSeparator();
            .OptionBuilder.hasArgs((int)2);
            .OptionBuilder.withArgName((String)"property=value");
            .OptionBuilder.withLongOpt((String)"hiveconf");
            .OptionBuilder.withDescription((String)"Use value for given property");
            this.OPTIONS.addOption(.OptionBuilder.create());
        }
    }

    public Properties addHiveconfToSystemProperties() {
        Properties confProps = this.commandLine.getOptionProperties("hiveconf");
        for (String propKey : confProps.stringPropertyNames()) {
            if (this.verbose) {
                System.err.println("hiveconf: " + propKey + "=" + confProps.getProperty(propKey));
            }
            if (propKey.equalsIgnoreCase("hive.root.logger")) {
                CommonCliOptions.splitAndSetLogger(propKey, confProps);
                continue;
            }
            System.setProperty(propKey, confProps.getProperty(propKey));
        }
        return confProps;
    }

    public static void splitAndSetLogger(String propKey, Properties confProps) {
        String propVal = confProps.getProperty(propKey);
        if (propVal.contains(",")) {
            String[] tokens;
            for (String token : tokens = propVal.split(",")) {
                if (Level.getLevel((String)token) == null) {
                    System.setProperty("hive.root.logger", token);
                    continue;
                }
                System.setProperty("hive.log.level", token);
            }
        } else {
            System.setProperty(propKey, confProps.getProperty(propKey));
        }
    }

    public void printUsage() {
        new .HelpFormatter().printHelp(this.cliname, this.OPTIONS);
    }

    public void parse(String[] args) {
        try {
            this.commandLine = new .GnuParser().parse(this.OPTIONS, args);
            if (this.commandLine.hasOption('h')) {
                this.printUsage();
                System.exit(1);
            }
            if (this.commandLine.hasOption('v')) {
                this.verbose = true;
            }
        }
        catch (.ParseException e) {
            System.err.println(e.getMessage());
            this.printUsage();
            System.exit(1);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }
}

