/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.lang.reflect.Method;

public class TezJobExecHelper {
    private static final Logger LOG = LoggerFactory.getLogger(TezJobExecHelper.class.getName());
    private static final Method KILL_RUNNING_TEZ_JOBS;

    public static void killRunningJobs() {
        try {
            if (KILL_RUNNING_TEZ_JOBS != null) {
                KILL_RUNNING_TEZ_JOBS.invoke(null, null);
            } else {
                LOG.warn("Unable to find tez method for killing jobs");
            }
        }
        catch (Exception e) {
            LOG.error("Could not stop tez dags: ", e);
        }
    }

    static {
        Method method = null;
        try {
            Class.forName("org.apache.tez.dag.api.DAG");
            ClassLoader classLoader = TezJobExecHelper.class.getClassLoader();
            method = classLoader.loadClass("org.apache.hadoop.hive.ql.exec.tez.monitoring.TezJobMonitor").getDeclaredMethod("killRunningJobs", new Class[0]);
            method.setAccessible(true);
        }
        catch (Exception e) {
            LOG.error("Error getting tez method", e);
        }
        KILL_RUNNING_TEZ_JOBS = method;
    }
}

