/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import com.facebook.presto.hive.$internal.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorLimitDesc;

public class VectorLimitOperator
extends LimitOperator
implements VectorizationOperator {
    private static final long serialVersionUID = 1L;
    private VectorizationContext vContext;
    private VectorLimitDesc vectorDesc;

    @VisibleForTesting
    public VectorLimitOperator() {
    }

    public VectorLimitOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorLimitOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) {
        this(ctx);
        this.conf = (LimitDesc)conf;
        this.vContext = vContext;
        this.vectorDesc = (VectorLimitDesc)vectorDesc;
    }

    @Override
    public VectorizationContext getInputVectorizationContext() {
        return this.vContext;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        VectorizedRowBatch batch = (VectorizedRowBatch)row;
        if (this.currCount + batch.size < this.offset) {
            this.currCount += batch.size;
        } else if (this.currCount >= this.offset + this.limit) {
            this.setDone(true);
        } else {
            int skipSize = 0;
            if (this.currCount < this.offset) {
                skipSize = this.offset - this.currCount;
            }
            batch.size = Math.min(batch.size, this.offset + this.limit - this.currCount);
            if (!batch.selectedInUse) {
                batch.selectedInUse = true;
                batch.selected = new int[batch.size];
                for (int i = 0; i < batch.size - skipSize; ++i) {
                    batch.selected[i] = skipSize + i;
                }
            } else {
                for (int i = 0; i < batch.size - skipSize; ++i) {
                    batch.selected[i] = batch.selected[skipSize + i];
                }
            }
            this.forward(row, this.inputObjInspectors[tag], true);
            this.currCount += batch.size;
        }
    }

    @Override
    public VectorDesc getVectorDesc() {
        return this.vectorDesc;
    }
}

