/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen;

import com.facebook.presto.hive.$internal.com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationDesc;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.util.JavaDataModel;

@Description(name="avg", value="_FUNC_(expr) - Returns the average value of expr (vectorized, type: timestamp)")
public class VectorUDAFAvgTimestamp
extends VectorAggregateExpression {
    private static final long serialVersionUID = 1L;

    public VectorUDAFAvgTimestamp() {
    }

    public VectorUDAFAvgTimestamp(VectorAggregationDesc vecAggrDesc) {
        super(vecAggrDesc);
        Preconditions.checkState(this.mode == GenericUDAFEvaluator.Mode.PARTIAL1);
        this.init();
    }

    private void init() {
    }

    private Aggregation getCurrentAggregationBuffer(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, int row) {
        VectorAggregationBufferRow mySet = aggregationBufferSets[row];
        Aggregation myagg = (Aggregation)mySet.getAggregationBuffer(bufferIndex);
        return myagg;
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, VectorizedRowBatch batch) throws HiveException {
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        this.inputExpression.evaluate(batch);
        TimestampColumnVector inputColVector = (TimestampColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                this.iterateNoNullsRepeatingWithAggregationSelection(aggregationBufferSets, bufferIndex, inputColVector.getDouble(0), batchSize);
            } else if (batch.selectedInUse) {
                this.iterateNoNullsSelectionWithAggregationSelection(aggregationBufferSets, bufferIndex, inputColVector, batch.selected, batchSize);
            } else {
                this.iterateNoNullsWithAggregationSelection(aggregationBufferSets, bufferIndex, inputColVector, batchSize);
            }
        } else if (inputColVector.isRepeating) {
            if (batch.selectedInUse) {
                this.iterateHasNullsRepeatingSelectionWithAggregationSelection(aggregationBufferSets, bufferIndex, inputColVector.getDouble(0), batchSize, batch.selected, inputColVector.isNull);
            } else {
                this.iterateHasNullsRepeatingWithAggregationSelection(aggregationBufferSets, bufferIndex, inputColVector.getDouble(0), batchSize, inputColVector.isNull);
            }
        } else if (batch.selectedInUse) {
            this.iterateHasNullsSelectionWithAggregationSelection(aggregationBufferSets, bufferIndex, inputColVector, batchSize, batch.selected, inputColVector.isNull);
        } else {
            this.iterateHasNullsWithAggregationSelection(aggregationBufferSets, bufferIndex, inputColVector, batchSize, inputColVector.isNull);
        }
    }

    private void iterateNoNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, double value, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.sumValue(value);
        }
    }

    private void iterateNoNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, TimestampColumnVector inputColVector, int[] selection, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.sumValue(inputColVector.getDouble(selection[i]));
        }
    }

    private void iterateNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, TimestampColumnVector inputColVector, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.sumValue(inputColVector.getDouble(i));
        }
    }

    private void iterateHasNullsRepeatingSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, double value, int batchSize, int[] selection, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[selection[i]]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.sumValue(value);
        }
    }

    private void iterateHasNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, double value, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.sumValue(value);
        }
    }

    private void iterateHasNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, TimestampColumnVector inputColVector, int batchSize, int[] selection, boolean[] isNull) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selection[j];
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, j);
            myagg.sumValue(inputColVector.getDouble(i));
        }
    }

    private void iterateHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, TimestampColumnVector inputColVector, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.sumValue(inputColVector.getDouble(i));
        }
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        TimestampColumnVector inputColVector = (TimestampColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        Aggregation myagg = (Aggregation)agg;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputColVector.isNull[0]) {
                if (myagg.isNull) {
                    myagg.isNull = false;
                    myagg.sum = 0.0;
                    myagg.count = 0L;
                }
                Aggregation aggregation = myagg;
                aggregation.sum = aggregation.sum + inputColVector.getDouble(0) * (double)batchSize;
                aggregation = myagg;
                aggregation.count = aggregation.count + (long)batchSize;
            }
            return;
        }
        if (!batch.selectedInUse && inputColVector.noNulls) {
            this.iterateNoSelectionNoNulls(myagg, inputColVector, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNulls(myagg, inputColVector, batchSize, inputColVector.isNull);
        } else if (inputColVector.noNulls) {
            this.iterateSelectionNoNulls(myagg, inputColVector, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNulls(myagg, inputColVector, batchSize, inputColVector.isNull, batch.selected);
        }
    }

    private void iterateSelectionHasNulls(Aggregation myagg, TimestampColumnVector inputColVector, int batchSize, boolean[] isNull, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selected[j];
            if (isNull[i]) continue;
            double value = inputColVector.getDouble(i);
            if (myagg.isNull) {
                myagg.isNull = false;
                myagg.sum = 0.0;
                myagg.count = 0L;
            }
            Aggregation aggregation = myagg;
            aggregation.sum = aggregation.sum + value;
            aggregation = myagg;
            aggregation.count = aggregation.count + 1L;
        }
    }

    private void iterateSelectionNoNulls(Aggregation myagg, TimestampColumnVector inputColVector, int batchSize, int[] selected) {
        if (myagg.isNull) {
            myagg.isNull = false;
            myagg.sum = 0.0;
            myagg.count = 0L;
        }
        for (int i = 0; i < batchSize; ++i) {
            double value = inputColVector.getDouble(selected[i]);
            Aggregation aggregation = myagg;
            aggregation.sum = aggregation.sum + value;
            aggregation = myagg;
            aggregation.count = aggregation.count + 1L;
        }
    }

    private void iterateNoSelectionHasNulls(Aggregation myagg, TimestampColumnVector inputColVector, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            double value = inputColVector.getDouble(i);
            if (myagg.isNull) {
                myagg.isNull = false;
                myagg.sum = 0.0;
                myagg.count = 0L;
            }
            Aggregation aggregation = myagg;
            aggregation.sum = aggregation.sum + value;
            aggregation = myagg;
            aggregation.count = aggregation.count + 1L;
        }
    }

    private void iterateNoSelectionNoNulls(Aggregation myagg, TimestampColumnVector inputColVector, int batchSize) {
        if (myagg.isNull) {
            myagg.isNull = false;
            myagg.sum = 0.0;
            myagg.count = 0L;
        }
        for (int i = 0; i < batchSize; ++i) {
            double value = inputColVector.getDouble(i);
            Aggregation aggregation = myagg;
            aggregation.sum = aggregation.sum + value;
            aggregation = myagg;
            aggregation.count = aggregation.count + 1L;
        }
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new Aggregation();
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myAgg = (Aggregation)agg;
        myAgg.reset();
    }

    @Override
    public long getAggregationBufferFixedSize() {
        JavaDataModel model = JavaDataModel.get();
        return JavaDataModel.alignUp(model.object() + model.primitive2() * 2, model.memoryAlign());
    }

    @Override
    public boolean matches(String name, ColumnVector.Type inputColVectorType, ColumnVector.Type outputColVectorType, GenericUDAFEvaluator.Mode mode) {
        return name.equals("avg") && inputColVectorType == ColumnVector.Type.TIMESTAMP && outputColVectorType == ColumnVector.Type.STRUCT && mode == GenericUDAFEvaluator.Mode.PARTIAL1;
    }

    @Override
    public void assignRowColumn(VectorizedRowBatch batch, int batchIndex, int columnNum, VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        StructColumnVector outputColVector = (StructColumnVector)batch.cols[columnNum];
        Aggregation myagg = (Aggregation)agg;
        if (myagg.isNull) {
            outputColVector.noNulls = false;
            outputColVector.isNull[batchIndex] = true;
            return;
        }
        Preconditions.checkState(myagg.count > 0L);
        outputColVector.isNull[batchIndex] = false;
        ColumnVector[] fields = outputColVector.fields;
        fields[0].isNull[batchIndex] = false;
        ((LongColumnVector)fields[0]).vector[batchIndex] = myagg.count;
        fields[1].isNull[batchIndex] = false;
        ((DoubleColumnVector)fields[1]).vector[batchIndex] = myagg.sum;
        ColumnVector sourceColVector = fields[2];
        sourceColVector.isRepeating = true;
        sourceColVector.noNulls = false;
        sourceColVector.isNull[0] = true;
    }

    static class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long serialVersionUID = 1L;
        private transient double sum;
        private transient long count;
        private transient boolean isNull = true;

        Aggregation() {
        }

        public void sumValue(double value) {
            if (this.isNull) {
                this.sum = value;
                this.count = 1L;
                this.isNull = false;
            } else {
                this.sum += value;
                ++this.count;
            }
        }

        @Override
        public int getVariableSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.isNull = true;
            this.sum = 0.0;
            this.count = 0L;
        }
    }
}

