/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.facebook.presto.hive.$internal.com.google.common.base.Preconditions;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class VectorPTFEvaluatorDecimalAvg
extends VectorPTFEvaluatorBase {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorPTFEvaluatorDecimalAvg.class.getName();
    private static final Log LOG = LogFactory.getLog(CLASS_NAME);
    protected boolean isGroupResultNull;
    protected HiveDecimalWritable sum = new HiveDecimalWritable();
    private int nonNullGroupCount;
    private HiveDecimalWritable temp = new HiveDecimalWritable();
    private HiveDecimalWritable avg = new HiveDecimalWritable();

    public VectorPTFEvaluatorDecimalAvg(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch, boolean isLastGroupBatch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState(!batch.selectedInUse);
        int size = batch.size;
        if (size == 0) {
            return;
        }
        DecimalColumnVector decimalColVector = (DecimalColumnVector)batch.cols[this.inputColumnNum];
        if (decimalColVector.isRepeating) {
            if (decimalColVector.noNulls || !decimalColVector.isNull[0]) {
                this.temp.setFromLong(batch.size);
                if (this.isGroupResultNull) {
                    this.sum.set(decimalColVector.vector[0]);
                    this.sum.mutateMultiply(this.temp);
                    this.isGroupResultNull = false;
                } else {
                    this.temp.mutateMultiply(decimalColVector.vector[0]);
                    this.sum.mutateAdd(this.temp);
                }
                this.nonNullGroupCount += size;
            }
        } else if (decimalColVector.noNulls) {
            HiveDecimalWritable[] vector = decimalColVector.vector;
            if (this.isGroupResultNull) {
                this.sum.set(vector[0]);
                this.isGroupResultNull = false;
            } else {
                this.sum.mutateAdd(vector[0]);
            }
            for (int i = 1; i < size; ++i) {
                this.sum.mutateAdd(vector[i]);
            }
            this.nonNullGroupCount += size;
        } else {
            boolean[] batchIsNull = decimalColVector.isNull;
            int i = 0;
            while (batchIsNull[i]) {
                if (++i < size) continue;
                return;
            }
            HiveDecimalWritable[] vector = decimalColVector.vector;
            if (this.isGroupResultNull) {
                this.sum.set(vector[i++]);
                this.isGroupResultNull = false;
            } else {
                this.sum.mutateAdd(vector[i++]);
            }
            ++this.nonNullGroupCount;
            while (i < size) {
                if (!batchIsNull[i]) {
                    this.sum.mutateAdd(vector[i]);
                    ++this.nonNullGroupCount;
                }
                ++i;
            }
        }
        if (isLastGroupBatch && !this.isGroupResultNull) {
            this.avg.set(this.sum);
            this.temp.setFromLong(this.nonNullGroupCount);
            this.avg.mutateDivide(this.temp);
        }
    }

    @Override
    public boolean isGroupResultNull() {
        return this.isGroupResultNull;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DECIMAL;
    }

    @Override
    public HiveDecimalWritable getDecimalGroupResult() {
        return this.avg;
    }

    @Override
    public void resetEvaluator() {
        this.isGroupResultNull = true;
        this.sum.set(HiveDecimal.ZERO);
        this.nonNullGroupCount = 0;
        this.avg.set(HiveDecimal.ZERO);
    }
}

