/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Describe Table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class DescTableDesc
extends DDLDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    String tableName;
    Map<String, String> partSpec;
    String resFile;
    String colPath;
    boolean isExt;
    boolean isFormatted;
    private static final String table = "describe";
    private static final String schema = "col_name,data_type,comment#string:string:string";
    private static final String colStatsSchema = "col_name,data_type,min,max,num_nulls,distinct_count,avg_col_len,max_col_len,num_trues,num_falses,bitVector,comment#string:string:string:string:string:string:string:string:string:string:string:string";

    public void setPartSpec(Map<String, String> partSpec) {
        this.partSpec = partSpec;
    }

    public DescTableDesc() {
    }

    public DescTableDesc(Path resFile, String tableName, Map<String, String> partSpec, String colPath) {
        this.isExt = false;
        this.isFormatted = false;
        this.partSpec = partSpec;
        this.resFile = resFile.toString();
        this.tableName = tableName;
        this.colPath = colPath;
    }

    public String getTable() {
        return table;
    }

    public static String getSchema(boolean colStats) {
        if (colStats) {
            return colStatsSchema;
        }
        return schema;
    }

    public boolean isExt() {
        return this.isExt;
    }

    public void setExt(boolean isExt) {
        this.isExt = isExt;
    }

    public boolean isFormatted() {
        return this.isFormatted;
    }

    public void setFormatted(boolean isFormat) {
        this.isFormatted = isFormat;
    }

    @Explain(displayName="table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setColPath(String colPath) {
        this.colPath = colPath;
    }

    public String getColumnPath() {
        return this.colPath;
    }

    @Explain(displayName="partition", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Map<String, String> getPartSpec() {
        return this.partSpec;
    }

    public void setPartSpecs(Map<String, String> partSpec) {
        this.partSpec = partSpec;
    }

    @Explain(displayName="result file", explainLevels={Explain.Level.EXTENDED})
    public String getResFile() {
        return this.resFile;
    }

    public void setResFile(String resFile) {
        this.resFile = resFile;
    }
}

