/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.sql.Date;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyDateObjectInspector;
import org.apache.hadoop.io.Text;

public class LazyDate
extends LazyPrimitive<LazyDateObjectInspector, DateWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(LazyDate.class);

    public LazyDate(LazyDateObjectInspector oi) {
        super(oi);
        this.data = new DateWritable();
    }

    public LazyDate(LazyDate copy) {
        super(copy);
        this.data = new DateWritable((DateWritable)copy.data);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        String s = null;
        if (!LazyUtils.isDateMaybe(bytes.getData(), start, length)) {
            this.isNull = true;
            return;
        }
        try {
            s = Text.decode((byte[])bytes.getData(), (int)start, (int)length);
            ((DateWritable)this.data).set(Date.valueOf(s));
            this.isNull = false;
        }
        catch (Exception e) {
            this.isNull = true;
            this.logExceptionMessage(bytes, start, length, "DATE");
        }
    }

    public static void writeUTF8(OutputStream out, DateWritable d) throws IOException {
        ByteBuffer b = Text.encode((String)d.toString());
        out.write(b.array(), 0, b.limit());
    }
}

