/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.internal.builtin;

import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.internal.ProtocolReader;
import com.facebook.drift.codec.internal.ProtocolWriter;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class IntArrayThriftCodec
implements ThriftCodec<int[]> {
    @Override
    public ThriftType getType() {
        return ThriftType.array(ThriftType.I32);
    }

    @Override
    public int[] read(TProtocolReader protocol) throws Exception {
        Objects.requireNonNull(protocol, "protocol is null");
        return new ProtocolReader(protocol).readI32Array();
    }

    @Override
    public void write(int[] value, TProtocolWriter protocol) throws Exception {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(protocol, "protocol is null");
        new ProtocolWriter(protocol).writeI32Array(value);
    }
}

