/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.metadata;

import com.facebook.drift.annotations.ThriftMethod;
import com.facebook.drift.annotations.ThriftService;
import com.facebook.drift.codec.metadata.ReflectionHelper;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.codec.metadata.ThriftMethodMetadata;
import com.google.common.base.Preconditions;
import com.google.common.collect.Comparators;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ThriftServiceMetadata {
    private final String name;
    private final String idlName;
    private final List<ThriftMethodMetadata> methods;
    private final List<String> documentation;

    public ThriftServiceMetadata(Class<?> serviceClass, ThriftCatalog catalog) {
        Objects.requireNonNull(serviceClass, "serviceClass is null");
        ThriftService thriftService = ThriftServiceMetadata.getThriftServiceAnnotation(serviceClass);
        this.name = thriftService.value().isEmpty() ? serviceClass.getSimpleName() : thriftService.value();
        this.idlName = thriftService.idlName().isEmpty() ? this.name : thriftService.idlName();
        ArrayList<OrderedThriftMethodMetadata> methods = new ArrayList<OrderedThriftMethodMetadata>();
        for (Method method : ReflectionHelper.findAnnotatedMethods(serviceClass, ThriftMethod.class)) {
            if (!method.isAnnotationPresent(ThriftMethod.class)) continue;
            methods.add(new OrderedThriftMethodMetadata(new ThriftMethodMetadata(method, catalog), ThriftCatalog.getMethodOrder(method)));
        }
        methods.sort(null);
        this.methods = (List)methods.stream().map(OrderedThriftMethodMetadata::getThriftMethodMetadata).collect(ImmutableList.toImmutableList());
        this.documentation = ThriftCatalog.getThriftDocumentation(serviceClass);
    }

    public String getName() {
        return this.name;
    }

    public String getIdlName() {
        return this.idlName;
    }

    public List<ThriftMethodMetadata> getMethods() {
        return this.methods;
    }

    public List<String> getDocumentation() {
        return this.documentation;
    }

    public static ThriftService getThriftServiceAnnotation(Class<?> serviceClass) {
        Set<ThriftService> serviceAnnotations = ReflectionHelper.getEffectiveClassAnnotations(serviceClass, ThriftService.class);
        Preconditions.checkArgument((!serviceAnnotations.isEmpty() ? 1 : 0) != 0, (String)"Service class %s is not annotated with @ThriftService", (Object)serviceClass.getName());
        Preconditions.checkArgument((serviceAnnotations.size() == 1 ? 1 : 0) != 0, (String)"Service class %s has multiple conflicting @ThriftService annotations: %s", (Object)serviceClass.getName(), serviceAnnotations);
        return (ThriftService)Iterables.getOnlyElement(serviceAnnotations);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThriftServiceMetadata that = (ThriftServiceMetadata)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.methods, that.methods);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.methods);
    }

    private static class OrderedThriftMethodMetadata
    implements Comparable<OrderedThriftMethodMetadata> {
        private final ThriftMethodMetadata thriftMethodMetadata;
        private final Optional<Integer> order;

        private OrderedThriftMethodMetadata(ThriftMethodMetadata thriftMethodMetadata, Optional<Integer> order) {
            this.thriftMethodMetadata = Objects.requireNonNull(thriftMethodMetadata, "thriftMethodMetadata is null");
            this.order = Objects.requireNonNull(order, "order is null");
        }

        public ThriftMethodMetadata getThriftMethodMetadata() {
            return this.thriftMethodMetadata;
        }

        public Optional<Integer> getOrder() {
            return this.order;
        }

        @Override
        public int compareTo(OrderedThriftMethodMetadata that) {
            return ComparisonChain.start().compare(this.order, that.order, Comparators.emptiesLast(Integer::compareTo)).compare((Comparable)((Object)this.thriftMethodMetadata.getName()), (Comparable)((Object)that.thriftMethodMetadata.getName())).compare((Comparable)((Object)this.thriftMethodMetadata.getMethod().getName()), (Comparable)((Object)that.thriftMethodMetadata.getMethod().getName())).compare(this.thriftMethodMetadata.getMethod().getParameterTypes(), that.thriftMethodMetadata.getMethod().getParameterTypes(), (left, right) -> {
                String leftParameterClassNames = Arrays.stream(left).map(Class::getName).collect(Collectors.joining(","));
                String rightParameterClassNames = Arrays.stream(right).map(Class::getName).collect(Collectors.joining(","));
                return leftParameterClassNames.compareTo(rightParameterClassNames);
            }).result();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OrderedThriftMethodMetadata that = (OrderedThriftMethodMetadata)o;
            return Objects.equals(this.thriftMethodMetadata, that.thriftMethodMetadata) && Objects.equals(this.order, that.order);
        }

        public int hashCode() {
            return Objects.hash(this.thriftMethodMetadata, this.order);
        }
    }
}

