/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;

public abstract class EnumColumnMapper<E extends Enum<E>>
implements ResultColumnMapper<E> {
    EnumColumnMapper() {
    }

    public static <E extends Enum<E>> ResultColumnMapper<E> byName(Class<E> type) {
        return new ByName(type);
    }

    public static <E extends Enum<E>> ResultColumnMapper<E> byOrdinal(Class<E> type) {
        return new ByOrdinal(type);
    }

    private static class ByOrdinal<E extends Enum<E>>
    extends EnumColumnMapper<E> {
        private final E[] constants;

        private ByOrdinal(Class<E> type) {
            this.constants = (Enum[])type.getEnumConstants();
        }

        @Override
        public E mapColumn(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
            int ordinal = r.getInt(columnNumber);
            return r.wasNull() ? null : (E)this.constants[ordinal];
        }

        @Override
        public E mapColumn(ResultSet r, String columnLabel, StatementContext ctx) throws SQLException {
            int ordinal = r.getInt(columnLabel);
            return r.wasNull() ? null : (E)this.constants[ordinal];
        }
    }

    private static class ByName<E extends Enum<E>>
    extends EnumColumnMapper<E> {
        private final Class<E> type;

        private ByName(Class<E> type) {
            this.type = type;
        }

        @Override
        public E mapColumn(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
            String name = r.getString(columnNumber);
            return name == null ? null : (E)Enum.valueOf(this.type, name);
        }

        @Override
        public E mapColumn(ResultSet r, String columnLabel, StatementContext ctx) throws SQLException {
            String name = r.getString(columnLabel);
            return name == null ? null : (E)Enum.valueOf(this.type, name);
        }
    }
}

