/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile.binary;

import com.facebook.presto.rcfile.ColumnData;
import com.facebook.presto.rcfile.EncodeOutput;
import com.facebook.presto.rcfile.RcFileDecoderUtils;
import com.facebook.presto.rcfile.binary.BinaryColumnEncoding;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.math.BigInteger;

public class DecimalEncoding
implements BinaryColumnEncoding {
    private static final int BITS_IN_BYTE = 8;
    private static final int BYTES_IN_LONG_DECIMAL = 16;
    private final DecimalType type;
    private final byte[] resultBytes = new byte[16];
    private final Slice resultSlice = Slices.wrappedBuffer((byte[])this.resultBytes);

    public DecimalEncoding(Type type) {
        this.type = (DecimalType)type;
    }

    @Override
    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (!block.isNull(position)) {
                this.encodeValueInto(block, position, output);
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public void encodeValueInto(Block block, int position, SliceOutput output) {
        if (Decimals.isShortDecimal((Type)this.type)) {
            this.writeLong(output, this.type.getLong(block, position));
        } else {
            this.writeSlice(output, block, position);
        }
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int offset = columnData.getOffset(i);
            int length = columnData.getLength(i);
            if (length == 0) {
                builder.appendNull();
                continue;
            }
            if (Decimals.isShortDecimal((Type)this.type)) {
                this.type.writeLong(builder, this.parseLong(slice, offset));
                continue;
            }
            this.type.writeSlice(builder, this.parseSlice(slice, offset));
        }
        return builder.build();
    }

    @Override
    public int getValueOffset(Slice slice, int offset) {
        return 0;
    }

    @Override
    public int getValueLength(Slice slice, int offset) {
        int scaleLength = RcFileDecoderUtils.decodeVIntSize(slice, offset);
        int dataLengthLength = RcFileDecoderUtils.decodeVIntSize(slice, offset + scaleLength);
        int dataLength = Math.toIntExact(RcFileDecoderUtils.readVInt(slice, offset + scaleLength));
        return scaleLength + dataLengthLength + dataLength;
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        if (Decimals.isShortDecimal((Type)this.type)) {
            this.type.writeLong(builder, this.parseLong(slice, offset));
        } else {
            this.type.writeSlice(builder, this.parseSlice(slice, offset));
        }
    }

    private long parseLong(Slice slice, int offset) {
        int scale = Math.toIntExact(RcFileDecoderUtils.readVInt(slice, offset));
        offset += RcFileDecoderUtils.decodeVIntSize(slice, offset);
        int length = Math.toIntExact(RcFileDecoderUtils.readVInt(slice, offset));
        offset += RcFileDecoderUtils.decodeVIntSize(slice, offset);
        Preconditions.checkState((length <= 8 ? 1 : 0) != 0);
        if (slice.getByte(offset) >= 0) {
            this.resultSlice.setLong(0, 0L);
        } else {
            this.resultSlice.setLong(0, -1L);
        }
        this.resultSlice.setBytes(8 - length, slice, offset, length);
        long value = Long.reverseBytes(this.resultSlice.getLong(0));
        if (scale != this.type.getScale()) {
            return Decimals.rescale((long)value, (int)scale, (int)this.type.getScale());
        }
        return value;
    }

    private Slice parseSlice(Slice slice, int offset) {
        int scale = Math.toIntExact(RcFileDecoderUtils.readVInt(slice, offset));
        offset += RcFileDecoderUtils.decodeVIntSize(slice, offset);
        int length = Math.toIntExact(RcFileDecoderUtils.readVInt(slice, offset));
        offset += RcFileDecoderUtils.decodeVIntSize(slice, offset);
        Preconditions.checkState((length <= 16 ? 1 : 0) != 0);
        if (slice.getByte(offset) >= 0) {
            this.resultSlice.setLong(0, 0L);
            this.resultSlice.setLong(8, 0L);
        } else {
            this.resultSlice.setLong(0, -1L);
            this.resultSlice.setLong(8, -1L);
        }
        this.resultSlice.setBytes(16 - length, slice, offset, length);
        BigInteger decimal = new BigInteger(this.resultBytes);
        if (scale != this.type.getScale()) {
            decimal = Decimals.rescale((BigInteger)decimal, (int)scale, (int)this.type.getScale());
        }
        return Decimals.encodeUnscaledValue((BigInteger)decimal);
    }

    private void writeLong(SliceOutput output, long value) {
        RcFileDecoderUtils.writeVInt(output, this.type.getScale());
        int length = DecimalEncoding.getWriteByteCount(value);
        RcFileDecoderUtils.writeVInt(output, length);
        for (int i = length - 1; i >= 0; --i) {
            output.writeByte((int)(value >> i * 8));
        }
    }

    private static int getWriteByteCount(long value) {
        if (value < 0L) {
            value ^= 0xFFFFFFFFFFFFFFFFL;
        }
        return (64 - Long.numberOfLeadingZeros(value)) / 8 + 1;
    }

    private void writeSlice(SliceOutput output, Block block, int position) {
        RcFileDecoderUtils.writeVInt(output, this.type.getScale());
        BigInteger decimal = Decimals.decodeUnscaledValue((Slice)block.getSlice(position, 0, 16));
        byte[] decimalBytes = decimal.toByteArray();
        RcFileDecoderUtils.writeVInt(output, decimalBytes.length);
        for (byte decimalByte : decimalBytes) {
            output.write((int)decimalByte);
        }
    }
}

