/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.rcfile.ColumnEncoding;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import java.util.List;
import java.util.stream.Collectors;

public interface RcFileEncoding {
    public ColumnEncoding booleanEncoding(Type var1);

    public ColumnEncoding byteEncoding(Type var1);

    public ColumnEncoding shortEncoding(Type var1);

    public ColumnEncoding intEncoding(Type var1);

    public ColumnEncoding longEncoding(Type var1);

    public ColumnEncoding decimalEncoding(Type var1);

    public ColumnEncoding floatEncoding(Type var1);

    public ColumnEncoding doubleEncoding(Type var1);

    public ColumnEncoding stringEncoding(Type var1);

    public ColumnEncoding binaryEncoding(Type var1);

    public ColumnEncoding dateEncoding(Type var1);

    public ColumnEncoding timestampEncoding(Type var1);

    public ColumnEncoding listEncoding(Type var1, ColumnEncoding var2);

    public ColumnEncoding mapEncoding(Type var1, ColumnEncoding var2, ColumnEncoding var3);

    public ColumnEncoding structEncoding(Type var1, List<ColumnEncoding> var2);

    default public ColumnEncoding getEncoding(Type type) {
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return this.booleanEncoding(type);
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return this.byteEncoding(type);
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return this.shortEncoding(type);
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return this.intEncoding(type);
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return this.longEncoding(type);
        }
        if (type instanceof DecimalType) {
            return this.decimalEncoding(type);
        }
        if (RealType.REAL.equals((Object)type)) {
            return this.floatEncoding(type);
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return this.doubleEncoding(type);
        }
        if (type instanceof VarcharType || type instanceof CharType) {
            return this.stringEncoding(type);
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return this.binaryEncoding(type);
        }
        if (DateType.DATE.equals((Object)type)) {
            return this.dateEncoding(type);
        }
        if (TimestampType.TIMESTAMP.equals((Object)type)) {
            return this.timestampEncoding(type);
        }
        String baseType = type.getTypeSignature().getBase();
        if ("array".equals(baseType)) {
            ColumnEncoding elementType = this.getEncoding((Type)type.getTypeParameters().get(0));
            return this.listEncoding(type, elementType);
        }
        if ("map".equals(baseType)) {
            ColumnEncoding keyType = this.getEncoding((Type)type.getTypeParameters().get(0));
            ColumnEncoding valueType = this.getEncoding((Type)type.getTypeParameters().get(1));
            return this.mapEncoding(type, keyType, valueType);
        }
        if ("row".equals(baseType)) {
            return this.structEncoding(type, type.getTypeParameters().stream().map(this::getEncoding).collect(Collectors.toList()));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "unsupported type: " + type);
    }
}

