/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.SqlDate;
import com.facebook.presto.common.type.SqlDecimal;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.rcfile.RcFileTester;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.testing.DateTimeTestingUtils;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class AbstractTestRcFileReader {
    private static final DecimalType DECIMAL_TYPE_PRECISION_2 = DecimalType.createDecimalType((int)2, (int)1);
    private static final DecimalType DECIMAL_TYPE_PRECISION_4 = DecimalType.createDecimalType((int)4, (int)2);
    private static final DecimalType DECIMAL_TYPE_PRECISION_8 = DecimalType.createDecimalType((int)8, (int)4);
    private static final DecimalType DECIMAL_TYPE_PRECISION_17 = DecimalType.createDecimalType((int)17, (int)8);
    private static final DecimalType DECIMAL_TYPE_PRECISION_18 = DecimalType.createDecimalType((int)18, (int)8);
    private static final DecimalType DECIMAL_TYPE_PRECISION_38 = DecimalType.createDecimalType((int)38, (int)16);
    private final RcFileTester tester;

    public AbstractTestRcFileReader(RcFileTester tester) {
        this.tester = tester;
    }

    @BeforeClass
    public void setUp() {
        Assert.assertEquals((Object)DateTimeZone.getDefault(), (Object)RcFileTester.HIVE_STORAGE_TIME_ZONE);
    }

    @Test
    public void testNoData() throws Exception {
        this.tester.testRoundTrip((Type)VarcharType.VARCHAR, (Iterable<?>)ImmutableList.of(), new RcFileTester.Format[0]);
    }

    @Test
    public void testBooleanSequence() throws Exception {
        this.tester.testRoundTrip((Type)BooleanType.BOOLEAN, Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)true, (Object)false, (Object)false)), (int)3000), new RcFileTester.Format[0]);
    }

    @Test
    public void testByteSequence() throws Exception {
        this.tester.testRoundTrip((Type)TinyintType.TINYINT, AbstractTestRcFileReader.intsBetween(-31234, 31234).stream().filter(i -> i % 11 == 0).map(Integer::byteValue).collect(Collectors.toList()), new RcFileTester.Format[0]);
    }

    @Test
    public void testShortSequence() throws Exception {
        this.tester.testRoundTrip((Type)SmallintType.SMALLINT, AbstractTestRcFileReader.intsBetween(-31234, 31234).stream().filter(i -> i % 11 == 0).map(Integer::shortValue).collect(Collectors.toList()), new RcFileTester.Format[0]);
        this.tester.testRoundTrip((Type)SmallintType.SMALLINT, AbstractTestRcFileReader.intsBetween(Short.MIN_VALUE, -31768).stream().map(Integer::shortValue).collect(Collectors.toList()), new RcFileTester.Format[0]);
        this.tester.testRoundTrip((Type)SmallintType.SMALLINT, AbstractTestRcFileReader.intsBetween(31767, Short.MAX_VALUE).stream().map(Integer::shortValue).collect(Collectors.toList()), new RcFileTester.Format[0]);
    }

    @Test
    public void testIntSequence() throws Exception {
        this.tester.testRoundTrip((Type)IntegerType.INTEGER, AbstractTestRcFileReader.intsBetween(-31234, 31234).stream().filter(i -> i % 11 == 0).collect(Collectors.toList()), new RcFileTester.Format[0]);
        this.tester.testRoundTrip((Type)IntegerType.INTEGER, (Iterable<?>)AbstractTestRcFileReader.intsBetween(Integer.MIN_VALUE, -2147482648), new RcFileTester.Format[0]);
        this.tester.testRoundTrip((Type)IntegerType.INTEGER, (Iterable<?>)AbstractTestRcFileReader.intsBetween(2147482647, Integer.MAX_VALUE), new RcFileTester.Format[0]);
    }

    @Test
    public void testLongSequence() throws Exception {
        this.tester.testRoundTrip((Type)BigintType.BIGINT, AbstractTestRcFileReader.longsBetween(-31234L, 31234L).stream().filter(i -> i % 11L == 0L).collect(Collectors.toList()), new RcFileTester.Format[0]);
        this.tester.testRoundTrip((Type)BigintType.BIGINT, (Iterable<?>)AbstractTestRcFileReader.longsBetween(Long.MIN_VALUE, -9223372036854774808L), new RcFileTester.Format[0]);
        this.tester.testRoundTrip((Type)BigintType.BIGINT, (Iterable<?>)AbstractTestRcFileReader.longsBetween(9223372036854774807L, Long.MAX_VALUE), new RcFileTester.Format[0]);
    }

    @Test
    public void testDateSequence() throws Exception {
        this.tester.testRoundTrip((Type)DateType.DATE, AbstractTestRcFileReader.intsBetween(-31234, 31234).stream().filter(i -> i % 11 == 0).map(SqlDate::new).collect(Collectors.toList()), new RcFileTester.Format[0]);
    }

    @Test
    public void testTimestampSequence() throws Exception {
        this.tester.testRoundTrip((Type)TimestampType.TIMESTAMP, AbstractTestRcFileReader.intsBetween(-31234, 31234).stream().filter(i -> i % 19 == 0).map(timestamp -> DateTimeTestingUtils.sqlTimestampOf((long)timestamp.intValue(), (ConnectorSession)TestingConnectorSession.SESSION)).collect(Collectors.toList()), new RcFileTester.Format[0]);
    }

    @Test
    public void testFloatSequence() throws Exception {
        this.tester.testRoundTrip((Type)RealType.REAL, AbstractTestRcFileReader.doubleSequence(-500.12f, 1.0, 3000).stream().map(Double::floatValue).collect(Collectors.toList()), new RcFileTester.Format[0]);
    }

    @Test
    public void testDoubleSequence() throws Exception {
        this.tester.testRoundTrip((Type)DoubleType.DOUBLE, AbstractTestRcFileReader.doubleSequence(-500.12, 1.0, 3000), new RcFileTester.Format[0]);
    }

    @Test
    public void testDecimalSequence() throws Exception {
        this.tester.testRoundTrip((Type)DECIMAL_TYPE_PRECISION_2, AbstractTestRcFileReader.decimalSequence("-30", "1", 60, 2, 1), new RcFileTester.Format[0]);
        this.tester.testRoundTrip((Type)DECIMAL_TYPE_PRECISION_4, AbstractTestRcFileReader.decimalSequence("-3000", "6", 1000, 4, 2), new RcFileTester.Format[0]);
        this.tester.testRoundTrip((Type)DECIMAL_TYPE_PRECISION_8, AbstractTestRcFileReader.decimalSequence("-3000000", "6000", 1000, 8, 4), new RcFileTester.Format[0]);
        this.tester.testRoundTrip((Type)DECIMAL_TYPE_PRECISION_17, AbstractTestRcFileReader.decimalSequence("-30000000000", "60000000", 1000, 17, 8), new RcFileTester.Format[0]);
        this.tester.testRoundTrip((Type)DECIMAL_TYPE_PRECISION_18, AbstractTestRcFileReader.decimalSequence("-30000000000", "60000000", 1000, 18, 8), new RcFileTester.Format[0]);
        this.tester.testRoundTrip((Type)DECIMAL_TYPE_PRECISION_38, AbstractTestRcFileReader.decimalSequence("-3000000000000000000", "6000000000000000", 1000, 38, 16), new RcFileTester.Format[0]);
    }

    @Test
    public void testStringSequence() throws Exception {
        this.tester.testRoundTrip((Type)VarcharType.VARCHAR, AbstractTestRcFileReader.intsBetween(0, 31234).stream().filter(i -> i % 19 == 0).map(Object::toString).collect(Collectors.toList()), new RcFileTester.Format[0]);
    }

    @Test
    public void testEmptyStringSequence() throws Exception {
        this.tester.testRoundTrip((Type)VarcharType.VARCHAR, Collections.nCopies(3000, ""), new RcFileTester.Format[0]);
    }

    @Test
    public void testBinarySequence() throws Exception {
        this.tester.testRoundTrip((Type)VarbinaryType.VARBINARY, AbstractTestRcFileReader.intsBetween(0, 30000).stream().filter(i -> i % 19 == 0).map(Object::toString).map(string -> string.getBytes(StandardCharsets.UTF_8)).map(SqlVarbinary::new).collect(Collectors.toList()), new RcFileTester.Format[0]);
    }

    @Test
    public void testEmptyBinarySequence() throws Exception {
        this.tester.testRoundTrip((Type)VarbinaryType.VARBINARY, Collections.nCopies(3000, new SqlVarbinary(new byte[0])), RcFileTester.Format.BINARY);
    }

    private static List<Double> doubleSequence(double start, double step, int items) {
        ArrayList<Double> values = new ArrayList<Double>();
        double nextValue = start;
        for (int i = 0; i < items; ++i) {
            values.add(nextValue);
            nextValue += step;
        }
        return values;
    }

    private static ContiguousSet<Long> longsBetween(long lowerInclusive, long upperExclusive) {
        return ContiguousSet.create((Range)Range.openClosed((Comparable)Long.valueOf(lowerInclusive), (Comparable)Long.valueOf(upperExclusive)), (DiscreteDomain)DiscreteDomain.longs());
    }

    private static ContiguousSet<Integer> intsBetween(int lowerInclusive, int upperExclusive) {
        return ContiguousSet.create((Range)Range.openClosed((Comparable)Integer.valueOf(lowerInclusive), (Comparable)Integer.valueOf(upperExclusive)), (DiscreteDomain)DiscreteDomain.integers());
    }

    private static List<SqlDecimal> decimalSequence(String start, String step, int items, int precision, int scale) {
        BigInteger decimalStep = new BigInteger(step);
        ArrayList<SqlDecimal> values = new ArrayList<SqlDecimal>();
        BigInteger nextValue = new BigInteger(start);
        for (int i = 0; i < items; ++i) {
            values.add(new SqlDecimal(nextValue, precision, scale));
            nextValue = nextValue.add(decimalStep);
        }
        return values;
    }
}

