/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.SqlDate;
import com.facebook.presto.common.type.SqlDecimal;
import com.facebook.presto.common.type.SqlTimestamp;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hadoop.HadoopNative;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.rcfile.AircompressorCodecFactory;
import com.facebook.presto.rcfile.FileRcFileDataSource;
import com.facebook.presto.rcfile.HadoopCodecFactory;
import com.facebook.presto.rcfile.RcFileCodecFactory;
import com.facebook.presto.rcfile.RcFileDataSource;
import com.facebook.presto.rcfile.RcFileDecoderUtils;
import com.facebook.presto.rcfile.RcFileEncoding;
import com.facebook.presto.rcfile.RcFileReader;
import com.facebook.presto.rcfile.RcFileWriter;
import com.facebook.presto.rcfile.binary.BinaryRcFileEncoding;
import com.facebook.presto.rcfile.text.TextRcFileEncoding;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.hadoop.compression.lzo.LzoCodec;
import io.airlift.slice.OutputStreamSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.StructObject;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyArray;
import org.apache.hadoop.hive.serde2.lazy.LazyMap;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryArray;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryMap;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.Lz4Codec;
import org.apache.hadoop.io.compress.SnappyCodec;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.joda.time.DateTimeZone;
import org.testng.Assert;

public class RcFileTester {
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = FunctionAndTypeManager.createTestFunctionAndTypeManager();
    public static final DateTimeZone HIVE_STORAGE_TIME_ZONE;
    private boolean structTestsEnabled;
    private boolean mapTestsEnabled;
    private boolean listTestsEnabled;
    private boolean complexStructuralTestsEnabled;
    private boolean readLastBatchOnlyEnabled;
    private Set<Format> formats = ImmutableSet.of();
    private Set<Compression> compressions = ImmutableSet.of();

    public static RcFileTester quickTestRcFileReader() {
        RcFileTester rcFileTester = new RcFileTester();
        rcFileTester.structTestsEnabled = true;
        rcFileTester.mapTestsEnabled = true;
        rcFileTester.listTestsEnabled = true;
        rcFileTester.complexStructuralTestsEnabled = false;
        rcFileTester.readLastBatchOnlyEnabled = false;
        rcFileTester.formats = ImmutableSet.copyOf((Object[])Format.values());
        rcFileTester.compressions = ImmutableSet.of((Object)((Object)Compression.SNAPPY));
        return rcFileTester;
    }

    public static RcFileTester fullTestRcFileReader() {
        RcFileTester rcFileTester = new RcFileTester();
        rcFileTester.structTestsEnabled = true;
        rcFileTester.mapTestsEnabled = true;
        rcFileTester.listTestsEnabled = true;
        rcFileTester.complexStructuralTestsEnabled = true;
        rcFileTester.readLastBatchOnlyEnabled = true;
        rcFileTester.formats = ImmutableSet.copyOf((Object[])Format.values());
        rcFileTester.compressions = ImmutableSet.of((Object)((Object)Compression.NONE), (Object)((Object)Compression.LZ4), (Object)((Object)Compression.ZLIB), (Object)((Object)Compression.BZIP2));
        return rcFileTester;
    }

    public void testRoundTrip(Type type, Iterable<?> writeValues, Format ... skipFormats) throws Exception {
        ImmutableSet skipFormatsSet = ImmutableSet.copyOf((Object[])skipFormats);
        this.testRoundTripType(type, writeValues, (Set<Format>)skipFormatsSet);
        this.assertRoundTrip(type, Iterables.transform(writeValues, (Function)Functions.constant(null)), (Set<Format>)skipFormatsSet);
        if (this.structTestsEnabled) {
            this.testStructRoundTrip(type, writeValues, (Set<Format>)skipFormatsSet);
        }
        if (this.complexStructuralTestsEnabled) {
            Iterable simpleStructs = Iterables.transform(RcFileTester.insertNullEvery(5, writeValues), RcFileTester::toHiveStruct);
            this.testRoundTripType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"field", (Type)RcFileTester.createRowType(type)))), Iterables.transform((Iterable)simpleStructs, Collections::singletonList), (Set<Format>)skipFormatsSet);
        }
        if (this.mapTestsEnabled) {
            this.testMapRoundTrip(type, writeValues, (Set<Format>)skipFormatsSet);
        }
        if (this.listTestsEnabled) {
            this.testListRoundTrip(type, writeValues, (Set<Format>)skipFormatsSet);
        }
        if (this.complexStructuralTestsEnabled) {
            this.testListRoundTrip((Type)RcFileTester.createListType(type), Iterables.transform(writeValues, RcFileTester::toHiveList), (Set<Format>)skipFormatsSet);
        }
    }

    private void testStructRoundTrip(Type type, Iterable<?> writeValues, Set<Format> skipFormats) throws Exception {
        this.testRoundTripType((Type)RcFileTester.createRowType(type), Iterables.transform(RcFileTester.insertNullEvery(5, writeValues), RcFileTester::toHiveStruct), skipFormats);
    }

    private void testMapRoundTrip(Type type, Iterable<?> writeValues, Set<Format> skipFormats) throws Exception {
        Object nullKeyWrite = Iterables.getFirst(writeValues, null);
        this.testRoundTripType((Type)RcFileTester.createMapType(type), Iterables.transform(RcFileTester.insertNullEvery(5, writeValues), value -> RcFileTester.toHiveMap(nullKeyWrite, value)), skipFormats);
    }

    private void testListRoundTrip(Type type, Iterable<?> writeValues, Set<Format> skipFormats) throws Exception {
        this.testRoundTripType((Type)RcFileTester.createListType(type), Iterables.transform(RcFileTester.insertNullEvery(5, writeValues), RcFileTester::toHiveList), skipFormats);
    }

    private void testRoundTripType(Type type, Iterable<?> writeValues, Set<Format> skipFormats) throws Exception {
        this.assertRoundTrip(type, RcFileTester.insertNullEvery(5, writeValues), skipFormats);
    }

    private void assertRoundTrip(Type type, Iterable<?> writeValues, Set<Format> skipFormats) throws Exception {
        ArrayList finalValues = Lists.newArrayList(writeValues);
        LinkedHashSet<Format> formats = new LinkedHashSet<Format>(this.formats);
        formats.removeAll(skipFormats);
        for (Format format : formats) {
            for (Compression compression : this.compressions) {
                try (TempFile tempFile = new TempFile();){
                    RcFileTester.writeRcFileColumnOld(tempFile.getFile(), format, compression, type, finalValues.iterator());
                    RcFileTester.assertFileContentsNew(type, tempFile, format, finalValues, false, (Map<String, String>)ImmutableMap.of());
                }
                tempFile = new TempFile();
                var11_11 = null;
                try {
                    ImmutableMap metadata = ImmutableMap.of((Object)String.valueOf(ThreadLocalRandom.current().nextLong()), (Object)String.valueOf(ThreadLocalRandom.current().nextLong()));
                    RcFileTester.writeRcFileColumnNew(tempFile.getFile(), format, compression, type, finalValues.iterator(), (Map<String, String>)metadata);
                    RcFileTester.assertFileContentsOld(type, tempFile, format, finalValues);
                    ImmutableMap expectedMetadata = ImmutableMap.builder().putAll((Map)metadata).put((Object)"presto.writer.version", (Object)RcFileWriter.PRESTO_RCFILE_WRITER_VERSION).build();
                    RcFileTester.assertFileContentsNew(type, tempFile, format, finalValues, false, (Map<String, String>)expectedMetadata);
                    if (!this.readLastBatchOnlyEnabled) continue;
                    RcFileTester.assertFileContentsNew(type, tempFile, format, finalValues, true, (Map<String, String>)expectedMetadata);
                }
                catch (Throwable throwable) {
                    var11_11 = throwable;
                    throw throwable;
                }
                finally {
                    if (tempFile == null) continue;
                    if (var11_11 != null) {
                        try {
                            tempFile.close();
                        }
                        catch (Throwable throwable) {
                            var11_11.addSuppressed(throwable);
                        }
                        continue;
                    }
                    tempFile.close();
                }
            }
        }
    }

    private static void assertFileContentsNew(Type type, TempFile tempFile, Format format, List<?> expectedValues, boolean readLastBatchOnly, Map<String, String> metadata) throws IOException {
        try (RcFileReader recordReader = RcFileTester.createRcFileReader(tempFile, type, format.getVectorEncoding());){
            RcFileTester.assertIndexOf(recordReader, tempFile.getFile());
            Assert.assertEquals((Map)recordReader.getMetadata(), (Map)ImmutableMap.builder().putAll(metadata).put((Object)"hive.io.rcfile.column.number", (Object)"1").build());
            Iterator<?> iterator = expectedValues.iterator();
            int totalCount = 0;
            int batchSize = recordReader.advance();
            while (batchSize >= 0) {
                if (readLastBatchOnly && (totalCount += batchSize) == expectedValues.size()) {
                    Assert.assertEquals((int)Iterators.advance(iterator, (int)batchSize), (int)batchSize);
                } else {
                    Block block = recordReader.readBlock(0);
                    ArrayList<Object> data = new ArrayList<Object>(block.getPositionCount());
                    for (int position = 0; position < block.getPositionCount(); ++position) {
                        data.add(type.getObjectValue(TestingConnectorSession.SESSION.getSqlFunctionProperties(), block, position));
                    }
                    for (int i = 0; i < batchSize; ++i) {
                        Assert.assertTrue((boolean)iterator.hasNext());
                        Object expected = iterator.next();
                        Object actual = data.get(i);
                        RcFileTester.assertColumnValueEquals(type, actual, expected);
                    }
                }
                batchSize = Math.toIntExact(recordReader.advance());
            }
            Assert.assertFalse((boolean)iterator.hasNext());
            Assert.assertEquals((long)recordReader.getRowsRead(), (long)totalCount);
        }
    }

    private static void assertColumnValueEquals(Type type, Object actual, Object expected) {
        if (actual == null) {
            Assert.assertNull((Object)expected);
            return;
        }
        String baseType = type.getTypeSignature().getBase();
        if ("array".equals(baseType)) {
            List actualArray = (List)actual;
            List expectedArray = (List)expected;
            Assert.assertEquals((int)actualArray.size(), (int)expectedArray.size());
            Type elementType = (Type)type.getTypeParameters().get(0);
            for (int i = 0; i < actualArray.size(); ++i) {
                Object actualElement = actualArray.get(i);
                Object expectedElement = expectedArray.get(i);
                RcFileTester.assertColumnValueEquals(elementType, actualElement, expectedElement);
            }
        } else if ("map".equals(baseType)) {
            Map actualMap = (Map)actual;
            Map expectedMap = (Map)expected;
            Assert.assertEquals((int)actualMap.size(), (int)expectedMap.size());
            Type keyType = (Type)type.getTypeParameters().get(0);
            Type valueType = (Type)type.getTypeParameters().get(1);
            ArrayList expectedEntries = new ArrayList(expectedMap.entrySet());
            for (Map.Entry actualEntry : actualMap.entrySet()) {
                Iterator iterator = expectedEntries.iterator();
                while (iterator.hasNext()) {
                    Map.Entry expectedEntry = (Map.Entry)iterator.next();
                    try {
                        RcFileTester.assertColumnValueEquals(keyType, actualEntry.getKey(), expectedEntry.getKey());
                        RcFileTester.assertColumnValueEquals(valueType, actualEntry.getValue(), expectedEntry.getValue());
                        iterator.remove();
                    }
                    catch (AssertionError assertionError) {}
                }
            }
            Assert.assertTrue((boolean)expectedEntries.isEmpty(), (String)("Unmatched entries " + expectedEntries));
        } else if ("row".equals(baseType)) {
            List fieldTypes = type.getTypeParameters();
            List actualRow = (List)actual;
            List expectedRow = (List)expected;
            Assert.assertEquals((int)actualRow.size(), (int)fieldTypes.size());
            Assert.assertEquals((int)actualRow.size(), (int)expectedRow.size());
            for (int fieldId = 0; fieldId < actualRow.size(); ++fieldId) {
                Type fieldType = (Type)fieldTypes.get(fieldId);
                Object actualElement = actualRow.get(fieldId);
                Object expectedElement = expectedRow.get(fieldId);
                RcFileTester.assertColumnValueEquals(fieldType, actualElement, expectedElement);
            }
        } else if (type.equals(DoubleType.DOUBLE)) {
            Double actualDouble = (Double)actual;
            Double expectedDouble = (Double)expected;
            if (actualDouble.isNaN()) {
                Assert.assertTrue((boolean)expectedDouble.isNaN(), (String)"expected double to be NaN");
            } else {
                Assert.assertEquals((double)actualDouble, (double)expectedDouble, (double)0.001);
            }
        } else if (!Objects.equals(actual, expected)) {
            Assert.assertEquals((Object)actual, (Object)expected);
        }
    }

    private static void assertIndexOf(RcFileReader recordReader, File file) throws IOException {
        List<Long> syncPositionsBruteForce = RcFileTester.getSyncPositionsBruteForce(recordReader, file);
        List<Long> syncPositionsSimple = RcFileTester.getSyncPositionsSimple(recordReader, file);
        Assert.assertEquals(syncPositionsBruteForce, syncPositionsSimple);
    }

    private static List<Long> getSyncPositionsBruteForce(RcFileReader recordReader, File file) {
        Slice slice = Slices.allocate((int)((int)file.length()));
        try (FileInputStream in = new FileInputStream(file);){
            slice.setBytes(0, (InputStream)in, slice.length());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        ArrayList<Long> syncPositionsBruteForce = new ArrayList<Long>();
        Slice sync = Slices.allocate((int)20);
        sync.setInt(0, -1);
        sync.setBytes(4, recordReader.getSync());
        long syncPosition = 0L;
        while (syncPosition >= 0L) {
            if ((syncPosition = (long)slice.indexOf(sync, (int)syncPosition)) <= 0L) continue;
            syncPositionsBruteForce.add(syncPosition);
            ++syncPosition;
        }
        return syncPositionsBruteForce;
    }

    private static List<Long> getSyncPositionsSimple(RcFileReader recordReader, File file) throws IOException {
        ArrayList<Long> syncPositions = new ArrayList<Long>();
        Slice sync = recordReader.getSync();
        long syncFirst = sync.getLong(0);
        long syncSecond = sync.getLong(8);
        long syncPosition = 0L;
        try (FileRcFileDataSource dataSource = new FileRcFileDataSource(file);){
            while (syncPosition >= 0L) {
                if ((syncPosition = RcFileDecoderUtils.findFirstSyncPosition((RcFileDataSource)dataSource, (long)syncPosition, (long)(file.length() - syncPosition), (long)syncFirst, (long)syncSecond)) <= 0L) continue;
                Assert.assertEquals((long)RcFileDecoderUtils.findFirstSyncPosition((RcFileDataSource)dataSource, (long)syncPosition, (long)1L, (long)syncFirst, (long)syncSecond), (long)syncPosition);
                Assert.assertEquals((long)RcFileDecoderUtils.findFirstSyncPosition((RcFileDataSource)dataSource, (long)syncPosition, (long)2L, (long)syncFirst, (long)syncSecond), (long)syncPosition);
                Assert.assertEquals((long)RcFileDecoderUtils.findFirstSyncPosition((RcFileDataSource)dataSource, (long)syncPosition, (long)10L, (long)syncFirst, (long)syncSecond), (long)syncPosition);
                Assert.assertEquals((long)RcFileDecoderUtils.findFirstSyncPosition((RcFileDataSource)dataSource, (long)(syncPosition - 1L), (long)1L, (long)syncFirst, (long)syncSecond), (long)-1L);
                Assert.assertEquals((long)RcFileDecoderUtils.findFirstSyncPosition((RcFileDataSource)dataSource, (long)(syncPosition - 2L), (long)2L, (long)syncFirst, (long)syncSecond), (long)-1L);
                Assert.assertEquals((long)RcFileDecoderUtils.findFirstSyncPosition((RcFileDataSource)dataSource, (long)(syncPosition + 1L), (long)1L, (long)syncFirst, (long)syncSecond), (long)-1L);
                syncPositions.add(syncPosition);
                ++syncPosition;
            }
        }
        return syncPositions;
    }

    private static RcFileReader createRcFileReader(TempFile tempFile, Type type, RcFileEncoding encoding) throws IOException {
        FileRcFileDataSource rcFileDataSource = new FileRcFileDataSource(tempFile.getFile());
        RcFileReader rcFileReader = new RcFileReader((RcFileDataSource)rcFileDataSource, encoding, (Map)ImmutableMap.of((Object)0, (Object)type), (RcFileCodecFactory)new AircompressorCodecFactory((RcFileCodecFactory)new HadoopCodecFactory(RcFileTester.class.getClassLoader())), 0L, tempFile.getFile().length(), new DataSize(8.0, DataSize.Unit.MEGABYTE));
        Assert.assertEquals((int)rcFileReader.getColumnCount(), (int)1);
        return rcFileReader;
    }

    private static DataSize writeRcFileColumnNew(File outputFile, Format format, Compression compression, Type type, Iterator<?> values, Map<String, String> metadata) throws Exception {
        OutputStreamSliceOutput output = new OutputStreamSliceOutput((OutputStream)new FileOutputStream(outputFile));
        AircompressorCodecFactory codecFactory = new AircompressorCodecFactory((RcFileCodecFactory)new HadoopCodecFactory(RcFileTester.class.getClassLoader()));
        RcFileWriter writer = new RcFileWriter((SliceOutput)output, (List)ImmutableList.of((Object)type), format.getVectorEncoding(), compression.getCodecName(), (RcFileCodecFactory)codecFactory, metadata, new DataSize(100.0, DataSize.Unit.KILOBYTE), new DataSize(200.0, DataSize.Unit.KILOBYTE), true);
        BlockBuilder blockBuilder = type.createBlockBuilder(null, 1024);
        while (values.hasNext()) {
            Object value = values.next();
            RcFileTester.writeValue(type, blockBuilder, value);
        }
        writer.write(new Page(new Block[]{blockBuilder.build()}));
        writer.close();
        writer.validate((RcFileDataSource)new FileRcFileDataSource(outputFile));
        return new DataSize((double)output.size(), DataSize.Unit.BYTE);
    }

    private static void writeValue(Type type, BlockBuilder blockBuilder, Object value) {
        if (value == null) {
            blockBuilder.appendNull();
        } else if (BooleanType.BOOLEAN.equals((Object)type)) {
            type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
        } else if (TinyintType.TINYINT.equals((Object)type)) {
            type.writeLong(blockBuilder, ((Number)value).longValue());
        } else if (SmallintType.SMALLINT.equals((Object)type)) {
            type.writeLong(blockBuilder, ((Number)value).longValue());
        } else if (IntegerType.INTEGER.equals((Object)type)) {
            type.writeLong(blockBuilder, ((Number)value).longValue());
        } else if (BigintType.BIGINT.equals((Object)type)) {
            type.writeLong(blockBuilder, ((Number)value).longValue());
        } else if (Decimals.isShortDecimal((Type)type)) {
            type.writeLong(blockBuilder, ((SqlDecimal)value).toBigDecimal().unscaledValue().longValue());
        } else if (Decimals.isLongDecimal((Type)type)) {
            type.writeSlice(blockBuilder, Decimals.encodeUnscaledValue((BigInteger)((SqlDecimal)value).toBigDecimal().unscaledValue()));
        } else if (RealType.REAL.equals((Object)type)) {
            type.writeLong(blockBuilder, (long)Float.floatToIntBits(((Float)value).floatValue()));
        } else if (DoubleType.DOUBLE.equals((Object)type)) {
            type.writeDouble(blockBuilder, ((Number)value).doubleValue());
        } else if (VarcharType.VARCHAR.equals((Object)type)) {
            type.writeSlice(blockBuilder, Slices.utf8Slice((String)((String)value)));
        } else if (VarbinaryType.VARBINARY.equals((Object)type)) {
            type.writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])((SqlVarbinary)value).getBytes()));
        } else if (DateType.DATE.equals((Object)type)) {
            long days = ((SqlDate)value).getDays();
            type.writeLong(blockBuilder, days);
        } else if (TimestampType.TIMESTAMP.equals((Object)type)) {
            long millis = ((SqlTimestamp)value).getMillisUtc();
            type.writeLong(blockBuilder, millis);
        } else {
            String baseType = type.getTypeSignature().getBase();
            if ("array".equals(baseType)) {
                List array = (List)value;
                Type elementType = (Type)type.getTypeParameters().get(0);
                BlockBuilder arrayBlockBuilder = blockBuilder.beginBlockEntry();
                for (Object elementValue : array) {
                    RcFileTester.writeValue(elementType, arrayBlockBuilder, elementValue);
                }
                blockBuilder.closeEntry();
            } else if ("map".equals(baseType)) {
                Map map = (Map)value;
                Type keyType = (Type)type.getTypeParameters().get(0);
                Type valueType = (Type)type.getTypeParameters().get(1);
                BlockBuilder mapBlockBuilder = blockBuilder.beginBlockEntry();
                for (Map.Entry entry : map.entrySet()) {
                    RcFileTester.writeValue(keyType, mapBlockBuilder, entry.getKey());
                    RcFileTester.writeValue(valueType, mapBlockBuilder, entry.getValue());
                }
                blockBuilder.closeEntry();
            } else if ("row".equals(baseType)) {
                List array = (List)value;
                List fieldTypes = type.getTypeParameters();
                BlockBuilder rowBlockBuilder = blockBuilder.beginBlockEntry();
                for (int fieldId = 0; fieldId < fieldTypes.size(); ++fieldId) {
                    Type fieldType = (Type)fieldTypes.get(fieldId);
                    RcFileTester.writeValue(fieldType, rowBlockBuilder, array.get(fieldId));
                }
                blockBuilder.closeEntry();
            } else {
                throw new IllegalArgumentException("Unsupported type " + type);
            }
        }
    }

    private static <K extends LongWritable, V extends BytesRefArrayWritable> void assertFileContentsOld(Type type, TempFile tempFile, Format format, Iterable<?> expectedValues) throws Exception {
        JobConf configuration = new JobConf(new Configuration(false));
        configuration.set("hive.io.file.readcolumn.ids", "0");
        configuration.setBoolean("hive.io.file.read.all.columns", false);
        Properties schema = new Properties();
        schema.setProperty("columns", "test");
        schema.setProperty("columns.types", RcFileTester.getJavaObjectInspector(type).getTypeName());
        Object deserializer = format == Format.BINARY ? new LazyBinaryColumnarSerDe() : new ColumnarSerDe();
        deserializer.initialize((Configuration)configuration, schema);
        configuration.set("serialization.lib", deserializer.getClass().getName());
        RCFileInputFormat inputFormat = new RCFileInputFormat();
        RecordReader recordReader = inputFormat.getRecordReader((InputSplit)new FileSplit(new org.apache.hadoop.fs.Path(tempFile.getFile().getAbsolutePath()), 0L, tempFile.getFile().length(), (String[])null), configuration, Reporter.NULL);
        LongWritable key = (LongWritable)recordReader.createKey();
        BytesRefArrayWritable value = (BytesRefArrayWritable)recordReader.createValue();
        StructObjectInspector rowInspector = (StructObjectInspector)deserializer.getObjectInspector();
        StructField field = rowInspector.getStructFieldRef("test");
        Iterator<?> iterator = expectedValues.iterator();
        while (recordReader.next((Object)key, (Object)value)) {
            Object expectedValue = iterator.next();
            Object rowData = deserializer.deserialize((Writable)value);
            Object actualValue = rowInspector.getStructFieldData(rowData, field);
            actualValue = RcFileTester.decodeRecordReaderValue(type, actualValue);
            RcFileTester.assertColumnValueEquals(type, actualValue, expectedValue);
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private static Object decodeRecordReaderValue(Type type, Object actualValue) {
        if (actualValue instanceof LazyPrimitive) {
            actualValue = ((LazyPrimitive)actualValue).getWritableObject();
        }
        if (actualValue instanceof BooleanWritable) {
            actualValue = Boolean.valueOf(((BooleanWritable)actualValue).get());
        } else if (actualValue instanceof ByteWritable) {
            actualValue = Byte.valueOf(((ByteWritable)actualValue).get());
        } else if (actualValue instanceof BytesWritable) {
            actualValue = new SqlVarbinary(((BytesWritable)actualValue).copyBytes());
        } else if (actualValue instanceof DateWritable) {
            actualValue = new SqlDate(((DateWritable)actualValue).getDays());
        } else if (actualValue instanceof DoubleWritable) {
            actualValue = Double.valueOf(((DoubleWritable)actualValue).get());
        } else if (actualValue instanceof FloatWritable) {
            actualValue = Float.valueOf(((FloatWritable)actualValue).get());
        } else if (actualValue instanceof IntWritable) {
            actualValue = Integer.valueOf(((IntWritable)actualValue).get());
        } else if (actualValue instanceof LongWritable) {
            actualValue = Long.valueOf(((LongWritable)actualValue).get());
        } else if (actualValue instanceof ShortWritable) {
            actualValue = Short.valueOf(((ShortWritable)actualValue).get());
        } else if (actualValue instanceof HiveDecimalWritable) {
            DecimalType decimalType = (DecimalType)type;
            HiveDecimalWritable writable = (HiveDecimalWritable)actualValue;
            BigInteger rescaledValue = Decimals.rescale((BigInteger)writable.getHiveDecimal().unscaledValue(), (int)writable.getScale(), (int)decimalType.getScale());
            actualValue = new SqlDecimal(rescaledValue, decimalType.getPrecision(), decimalType.getScale());
        } else if (actualValue instanceof Text) {
            actualValue = actualValue.toString();
        } else if (actualValue instanceof TimestampWritable) {
            TimestampWritable timestamp = (TimestampWritable)actualValue;
            actualValue = TestingConnectorSession.SESSION.getSqlFunctionProperties().isLegacyTimestamp() ? new SqlTimestamp(timestamp.getSeconds() * 1000L + (long)timestamp.getNanos() / 1000000L, TimeZoneKey.UTC_KEY, TimeUnit.MILLISECONDS) : new SqlTimestamp(timestamp.getSeconds() * 1000L + (long)timestamp.getNanos() / 1000000L, TimeUnit.MILLISECONDS);
        } else if (actualValue instanceof StructObject) {
            StructObject structObject = (StructObject)actualValue;
            actualValue = RcFileTester.decodeRecordReaderStruct(type, structObject.getFieldsAsList());
        } else if (actualValue instanceof LazyBinaryArray) {
            actualValue = RcFileTester.decodeRecordReaderList(type, ((LazyBinaryArray)actualValue).getList());
        } else if (actualValue instanceof LazyBinaryMap) {
            actualValue = RcFileTester.decodeRecordReaderMap(type, ((LazyBinaryMap)actualValue).getMap());
        } else if (actualValue instanceof LazyArray) {
            actualValue = RcFileTester.decodeRecordReaderList(type, ((LazyArray)actualValue).getList());
        } else if (actualValue instanceof LazyMap) {
            actualValue = RcFileTester.decodeRecordReaderMap(type, ((LazyMap)actualValue).getMap());
        } else if (actualValue instanceof List) {
            actualValue = RcFileTester.decodeRecordReaderList(type, actualValue);
        }
        return actualValue;
    }

    private static List<Object> decodeRecordReaderList(Type type, List<?> list) {
        Type elementType = (Type)type.getTypeParameters().get(0);
        return list.stream().map(element -> RcFileTester.decodeRecordReaderValue(elementType, element)).collect(Collectors.toList());
    }

    private static Object decodeRecordReaderMap(Type type, Map<?, ?> map) {
        Type keyType = (Type)type.getTypeParameters().get(0);
        Type valueType = (Type)type.getTypeParameters().get(1);
        HashMap<Object, Object> newMap = new HashMap<Object, Object>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            newMap.put(RcFileTester.decodeRecordReaderValue(keyType, entry.getKey()), RcFileTester.decodeRecordReaderValue(valueType, entry.getValue()));
        }
        return newMap;
    }

    private static List<Object> decodeRecordReaderStruct(Type type, List<?> fields) {
        List fieldTypes = type.getTypeParameters();
        ArrayList<Object> newFields = new ArrayList<Object>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            Type fieldType = (Type)fieldTypes.get(i);
            Object field = fields.get(i);
            newFields.add(RcFileTester.decodeRecordReaderValue(fieldType, field));
        }
        return newFields;
    }

    private static DataSize writeRcFileColumnOld(File outputFile, Format format, Compression compression, Type type, Iterator<?> values) throws Exception {
        ObjectInspector columnObjectInspector = RcFileTester.getJavaObjectInspector(type);
        FileSinkOperator.RecordWriter recordWriter = RcFileTester.createRcFileWriterOld(outputFile, compression, columnObjectInspector);
        SettableStructObjectInspector objectInspector = RcFileTester.createSettableStructObjectInspector("test", columnObjectInspector);
        Object row = objectInspector.create();
        ImmutableList fields = ImmutableList.copyOf((Collection)objectInspector.getAllStructFieldRefs());
        Serializer serializer = format.createSerializer();
        Properties tableProperties = new Properties();
        tableProperties.setProperty("columns", "test");
        tableProperties.setProperty("columns.types", objectInspector.getTypeName());
        serializer.initialize((Configuration)new JobConf(false), tableProperties);
        while (values.hasNext()) {
            Object value = values.next();
            value = RcFileTester.preprocessWriteValueOld(type, value);
            objectInspector.setStructFieldData(row, (StructField)fields.get(0), value);
            Writable record = serializer.serialize(row, (ObjectInspector)objectInspector);
            recordWriter.write(record);
        }
        recordWriter.close(false);
        return new DataSize((double)outputFile.length(), DataSize.Unit.BYTE).convertToMostSuccinctDataSize();
    }

    private static ObjectInspector getJavaObjectInspector(Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return PrimitiveObjectInspectorFactory.javaBooleanObjectInspector;
        }
        if (type.equals(BigintType.BIGINT)) {
            return PrimitiveObjectInspectorFactory.javaLongObjectInspector;
        }
        if (type.equals(IntegerType.INTEGER)) {
            return PrimitiveObjectInspectorFactory.javaIntObjectInspector;
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return PrimitiveObjectInspectorFactory.javaShortObjectInspector;
        }
        if (type.equals(TinyintType.TINYINT)) {
            return PrimitiveObjectInspectorFactory.javaByteObjectInspector;
        }
        if (type.equals(RealType.REAL)) {
            return PrimitiveObjectInspectorFactory.javaFloatObjectInspector;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return PrimitiveObjectInspectorFactory.javaDoubleObjectInspector;
        }
        if (type instanceof VarcharType) {
            return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector;
        }
        if (type.equals(DateType.DATE)) {
            return PrimitiveObjectInspectorFactory.javaDateObjectInspector;
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return PrimitiveObjectInspectorFactory.javaTimestampObjectInspector;
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new DecimalTypeInfo(decimalType.getPrecision(), decimalType.getScale()));
        }
        if (type.getTypeSignature().getBase().equals("array")) {
            return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)RcFileTester.getJavaObjectInspector((Type)type.getTypeParameters().get(0)));
        }
        if (type.getTypeSignature().getBase().equals("map")) {
            ObjectInspector keyObjectInspector = RcFileTester.getJavaObjectInspector((Type)type.getTypeParameters().get(0));
            ObjectInspector valueObjectInspector = RcFileTester.getJavaObjectInspector((Type)type.getTypeParameters().get(1));
            return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)keyObjectInspector, (ObjectInspector)valueObjectInspector);
        }
        if (type.getTypeSignature().getBase().equals("row")) {
            return ObjectInspectorFactory.getStandardStructObjectInspector(type.getTypeSignature().getParameters().stream().map(parameter -> (String)parameter.getNamedTypeSignature().getName().get()).collect(Collectors.toList()), type.getTypeParameters().stream().map(RcFileTester::getJavaObjectInspector).collect(Collectors.toList()));
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    private static Object preprocessWriteValueOld(Type type, Object value) {
        if (value == null) {
            return null;
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return value;
        }
        if (type.equals(TinyintType.TINYINT)) {
            return ((Number)value).byteValue();
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return ((Number)value).shortValue();
        }
        if (type.equals(IntegerType.INTEGER)) {
            return ((Number)value).intValue();
        }
        if (type.equals(BigintType.BIGINT)) {
            return ((Number)value).longValue();
        }
        if (type.equals(RealType.REAL)) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return ((Number)value).doubleValue();
        }
        if (type instanceof VarcharType) {
            return value;
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return ((SqlVarbinary)value).getBytes();
        }
        if (type.equals(DateType.DATE)) {
            int days = ((SqlDate)value).getDays();
            LocalDate localDate = LocalDate.ofEpochDay(days);
            ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
            long millis = zonedDateTime.toEpochSecond() * 1000L;
            Date date = new Date(0L);
            date.setTime(millis);
            return date;
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            long millisUtc = (int)((SqlTimestamp)value).getMillisUtc();
            return new Timestamp(millisUtc);
        }
        if (type instanceof DecimalType) {
            return HiveDecimal.create((BigDecimal)((SqlDecimal)value).toBigDecimal());
        }
        if (type.getTypeSignature().getBase().equals("array")) {
            Type elementType = (Type)type.getTypeParameters().get(0);
            return ((List)value).stream().map(element -> RcFileTester.preprocessWriteValueOld(elementType, element)).collect(Collectors.toList());
        }
        if (type.getTypeSignature().getBase().equals("map")) {
            Type keyType = (Type)type.getTypeParameters().get(0);
            Type valueType = (Type)type.getTypeParameters().get(1);
            HashMap<Object, Object> newMap = new HashMap<Object, Object>();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                newMap.put(RcFileTester.preprocessWriteValueOld(keyType, entry.getKey()), RcFileTester.preprocessWriteValueOld(valueType, entry.getValue()));
            }
            return newMap;
        }
        if (type.getTypeSignature().getBase().equals("row")) {
            List fieldValues = (List)value;
            List fieldTypes = type.getTypeParameters();
            ArrayList<Object> newStruct = new ArrayList<Object>();
            for (int fieldId = 0; fieldId < fieldValues.size(); ++fieldId) {
                newStruct.add(RcFileTester.preprocessWriteValueOld((Type)fieldTypes.get(fieldId), fieldValues.get(fieldId)));
            }
            return newStruct;
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    private static FileSinkOperator.RecordWriter createRcFileWriterOld(File outputFile, Compression compression, ObjectInspector columnObjectInspector) throws IOException {
        JobConf jobConf = new JobConf(false);
        Optional<String> codecName = compression.getCodecName();
        codecName.ifPresent(s -> jobConf.set("mapreduce.output.fileoutputformat.compress.codec", s));
        return new RCFileOutputFormat().getHiveRecordWriter(jobConf, new org.apache.hadoop.fs.Path(outputFile.toURI()), Text.class, codecName.isPresent(), RcFileTester.createTableProperties("test", columnObjectInspector.getTypeName()), () -> {});
    }

    private static SettableStructObjectInspector createSettableStructObjectInspector(String name, ObjectInspector objectInspector) {
        return ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)name), (List)ImmutableList.of((Object)objectInspector));
    }

    private static Properties createTableProperties(String name, String type) {
        Properties orderTableProperties = new Properties();
        orderTableProperties.setProperty("columns", name);
        orderTableProperties.setProperty("columns.types", type);
        orderTableProperties.setProperty("file.inputformat", RCFileInputFormat.class.getName());
        return orderTableProperties;
    }

    private static <T> Iterable<T> insertNullEvery(final int n, final Iterable<T> iterable) {
        return () -> new AbstractIterator<T>(){
            private int position;
            private final Iterator delegate;
            {
                this.delegate = iterable.iterator();
            }

            protected T computeNext() {
                ++this.position;
                if (this.position > n) {
                    this.position = 0;
                    return null;
                }
                if (!this.delegate.hasNext()) {
                    return this.endOfData();
                }
                return this.delegate.next();
            }
        };
    }

    private static RowType createRowType(Type type) {
        return RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)type), (Object)RowType.field((String)"b", (Type)type), (Object)RowType.field((String)"c", (Type)type)));
    }

    private static Object toHiveStruct(Object input) {
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(input);
        data.add(input);
        data.add(input);
        return data;
    }

    private static MapType createMapType(Type type) {
        return (MapType)FUNCTION_AND_TYPE_MANAGER.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)type.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)type.getTypeSignature())));
    }

    private static Object toHiveMap(Object nullKeyValue, Object input) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (input == null) {
            map.put(nullKeyValue, null);
        } else {
            map.put(input, input);
        }
        return map;
    }

    private static ArrayType createListType(Type type) {
        return new ArrayType(type);
    }

    private static Object toHiveList(Object input) {
        ArrayList<Object> list = new ArrayList<Object>(4);
        for (int i = 0; i < 4; ++i) {
            list.add(input);
        }
        return list;
    }

    static {
        HadoopNative.requireHadoopNative();
        HIVE_STORAGE_TIME_ZONE = DateTimeZone.forID((String)"America/Bahia_Banderas");
    }

    private static class TempFile
    implements Closeable {
        private final File tempDir = Files.createTempDir();
        private final File file;

        private TempFile() {
            this.tempDir.mkdirs();
            this.file = new File(this.tempDir, "data.rcfile");
        }

        public File getFile() {
            return this.file;
        }

        @Override
        public void close() throws IOException {
            MoreFiles.deleteRecursively((Path)this.tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
    }

    public static enum Compression {
        BZIP2{

            @Override
            Optional<String> getCodecName() {
                return Optional.of(BZip2Codec.class.getName());
            }
        }
        ,
        ZLIB{

            @Override
            Optional<String> getCodecName() {
                return Optional.of(GzipCodec.class.getName());
            }
        }
        ,
        SNAPPY{

            @Override
            Optional<String> getCodecName() {
                return Optional.of(SnappyCodec.class.getName());
            }
        }
        ,
        LZO{

            @Override
            Optional<String> getCodecName() {
                return Optional.of(LzoCodec.class.getName());
            }
        }
        ,
        LZ4{

            @Override
            Optional<String> getCodecName() {
                return Optional.of(Lz4Codec.class.getName());
            }
        }
        ,
        NONE{

            @Override
            Optional<String> getCodecName() {
                return Optional.empty();
            }
        };


        abstract Optional<String> getCodecName();
    }

    public static enum Format {
        BINARY{

            @Override
            public Serializer createSerializer() {
                return new LazyBinaryColumnarSerDe();
            }

            @Override
            public RcFileEncoding getVectorEncoding() {
                return new BinaryRcFileEncoding();
            }
        }
        ,
        TEXT{

            @Override
            public Serializer createSerializer() {
                try {
                    ColumnarSerDe columnarSerDe = new ColumnarSerDe();
                    Properties tableProperties = new Properties();
                    tableProperties.setProperty("columns", "test");
                    tableProperties.setProperty("columns.types", "string");
                    columnarSerDe.initialize((Configuration)new JobConf(false), tableProperties);
                    return columnarSerDe;
                }
                catch (SerDeException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public RcFileEncoding getVectorEncoding() {
                return new TextRcFileEncoding(HIVE_STORAGE_TIME_ZONE);
            }
        };


        public abstract Serializer createSerializer();

        public abstract RcFileEncoding getVectorEncoding();
    }
}

