/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile;

import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.rcfile.BufferedOutputStreamSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBufferedOutputStreamSliceOutput {
    @Test
    public void testWriteBytes() throws Exception {
        int length = 65536;
        byte[] inputArray = new byte[length];
        for (int i = 0; i < length; ++i) {
            inputArray[i] = (byte)(i % 128);
        }
        int[] offsets = new int[]{0, 100, 545, 1024, 2049, 2050, 2051, 2151, 10480, 20042, 20100, 40001, 65536};
        MockOutputStream byteOutputStream = new MockOutputStream(length);
        BufferedOutputStreamSliceOutput output = new BufferedOutputStreamSliceOutput((OutputStream)byteOutputStream);
        for (int i = 0; i < offsets.length - 1; ++i) {
            output.writeBytes(inputArray, offsets[i], offsets[i + 1] - offsets[i]);
        }
        output.flush();
        Assert.assertEquals((byte[])byteOutputStream.toByteArray(), (byte[])inputArray);
        byteOutputStream.close();
        byteOutputStream = new MockOutputStream(length);
        Slice inputSlice = Slices.wrappedBuffer((byte[])inputArray);
        output = new BufferedOutputStreamSliceOutput((OutputStream)byteOutputStream);
        for (int i = 0; i < offsets.length - 1; ++i) {
            output.writeBytes(inputSlice, offsets[i], offsets[i + 1] - offsets[i]);
        }
        output.flush();
        Assert.assertEquals((byte[])byteOutputStream.toByteArray(), (byte[])inputArray);
        byteOutputStream.close();
    }

    private class MockOutputStream
    extends ByteArrayOutputStream {
        public MockOutputStream(int length) {
            super(length);
        }

        @Override
        public void write(byte[] source, int sourceIndex, int length) {
            Assertions.assertLessThanOrEqual((Comparable)Integer.valueOf(length), (Comparable)Integer.valueOf(4096));
            super.write(source, sourceIndex, length);
        }
    }
}

