/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile;

import com.facebook.presto.rcfile.RcFileDecoderUtils;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRcFileDecoderUtils {
    @Test
    public void testVInt() throws Exception {
        Slice slice = Slices.allocate((int)100);
        SliceOutput output = slice.getOutput();
        TestRcFileDecoderUtils.assertVIntRoundTrip(output, 0L);
        TestRcFileDecoderUtils.assertVIntRoundTrip(output, 1L);
        TestRcFileDecoderUtils.assertVIntRoundTrip(output, -1L);
        TestRcFileDecoderUtils.assertVIntRoundTrip(output, Integer.MAX_VALUE);
        TestRcFileDecoderUtils.assertVIntRoundTrip(output, 0x80000000L);
        TestRcFileDecoderUtils.assertVIntRoundTrip(output, 0x7FFFFFFEL);
        TestRcFileDecoderUtils.assertVIntRoundTrip(output, Integer.MIN_VALUE);
        TestRcFileDecoderUtils.assertVIntRoundTrip(output, -2147483647L);
        TestRcFileDecoderUtils.assertVIntRoundTrip(output, -2147483649L);
        TestRcFileDecoderUtils.assertVIntRoundTrip(output, Long.MAX_VALUE);
        TestRcFileDecoderUtils.assertVIntRoundTrip(output, 0x7FFFFFFFFFFFFFFEL);
        TestRcFileDecoderUtils.assertVIntRoundTrip(output, -9223372036854775807L);
        for (int value = -100000; value < 100000; ++value) {
            TestRcFileDecoderUtils.assertVIntRoundTrip(output, value);
        }
    }

    private static void assertVIntRoundTrip(SliceOutput output, long value) throws IOException {
        Slice oldBytes = TestRcFileDecoderUtils.writeVintOld(output, value);
        long readValueOld = WritableUtils.readVLong((DataInput)oldBytes.getInput());
        Assert.assertEquals((long)readValueOld, (long)value);
        long readValueNew = RcFileDecoderUtils.readVInt((Slice)oldBytes, (int)0);
        Assert.assertEquals((long)readValueNew, (long)value);
        long readValueNewStream = RcFileDecoderUtils.readVInt((SliceInput)oldBytes.getInput());
        Assert.assertEquals((long)readValueNewStream, (long)value);
    }

    private static Slice writeVintOld(SliceOutput output, long value) throws IOException {
        output.reset();
        WritableUtils.writeVLong((DataOutput)output, (long)value);
        Slice vLongOld = Slices.copyOf((Slice)output.slice());
        output.reset();
        RcFileDecoderUtils.writeVLong((SliceOutput)output, (long)value);
        Slice vLongNew = Slices.copyOf((Slice)output.slice());
        Assert.assertEquals((Object)vLongNew, (Object)vLongOld);
        if (value == (long)((int)value)) {
            output.reset();
            WritableUtils.writeVInt((DataOutput)output, (int)((int)value));
            Slice vIntOld = Slices.copyOf((Slice)output.slice());
            Assert.assertEquals((Object)vIntOld, (Object)vLongOld);
            output.reset();
            RcFileDecoderUtils.writeVInt((SliceOutput)output, (int)((int)value));
            Slice vIntNew = Slices.copyOf((Slice)output.slice());
            Assert.assertEquals((Object)vIntNew, (Object)vLongOld);
        }
        return vLongOld;
    }
}

