/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.rcfile.RcFileCodecFactory;
import com.facebook.presto.rcfile.RcFileCompressor;
import com.facebook.presto.rcfile.RcFileDataSource;
import com.facebook.presto.rcfile.RcFileDataSourceId;
import com.facebook.presto.rcfile.RcFileDecompressor;
import com.facebook.presto.rcfile.RcFileEncoding;
import com.facebook.presto.rcfile.RcFileReader;
import com.facebook.presto.rcfile.binary.BinaryRcFileEncoding;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRcFileReaderManual {
    private static final Slice COLUMN_COUNT_METADATA_KEY = Slices.utf8Slice((String)"hive.io.rcfile.column.number");
    private static final Slice RCFILE_MAGIC = Slices.utf8Slice((String)"RCF");
    private static final int CURRENT_VERSION = 1;
    private static final long syncFirst = 1311768467284833366L;
    private static final long syncSecond = 8687463697196027922L;

    @Test
    public void testNoStartSync() throws Exception {
        DynamicSliceOutput output = new DynamicSliceOutput(10240);
        ImmutableList segments = ImmutableList.of((Object)TestRcFileReaderManual.writeSegment((SliceOutput)output, (List<List<Integer>>)ImmutableList.of((Object)ImmutableList.of((Object)0, (Object)2, (Object)3, (Object)4), (Object)ImmutableList.of((Object)10, (Object)12, (Object)13))), (Object)TestRcFileReaderManual.writeSegment((SliceOutput)output, (List<List<Integer>>)ImmutableList.of((Object)ImmutableList.of((Object)20, (Object)22), (Object)ImmutableList.of((Object)30, (Object)33), (Object)ImmutableList.of((Object)40, (Object)44))), (Object)TestRcFileReaderManual.writeSegment((SliceOutput)output, (List<List<Integer>>)ImmutableList.of((Object)ImmutableList.of((Object)100, (Object)101, (Object)102))));
        TestRcFileReaderManual.assertFileSegments(output.slice(), (List<Segment>)segments);
    }

    @Test
    public void testStartSync() throws Exception {
        DynamicSliceOutput output = new DynamicSliceOutput(10240);
        ImmutableList segments = ImmutableList.of((Object)TestRcFileReaderManual.writeSegment((SliceOutput)output, (List<List<Integer>>)ImmutableList.of()), (Object)TestRcFileReaderManual.writeSegment((SliceOutput)output, (List<List<Integer>>)ImmutableList.of((Object)ImmutableList.of((Object)0, (Object)2, (Object)3, (Object)4), (Object)ImmutableList.of((Object)10, (Object)12, (Object)13))), (Object)TestRcFileReaderManual.writeSegment((SliceOutput)output, (List<List<Integer>>)ImmutableList.of((Object)ImmutableList.of((Object)20, (Object)22), (Object)ImmutableList.of((Object)30, (Object)33), (Object)ImmutableList.of((Object)40, (Object)44))), (Object)TestRcFileReaderManual.writeSegment((SliceOutput)output, (List<List<Integer>>)ImmutableList.of((Object)ImmutableList.of((Object)100, (Object)101, (Object)102))));
        TestRcFileReaderManual.assertFileSegments(output.slice(), (List<Segment>)segments);
    }

    private static void assertFileSegments(Slice file, List<Segment> segments) throws IOException {
        List allValues = segments.stream().map(Segment::getValues).flatMap(Collection::stream).collect(Collectors.toList());
        Assert.assertEquals(allValues, TestRcFileReaderManual.readValues(file, 0, file.length()));
        for (Segment segment : segments) {
            Assert.assertEquals(segment.getValues(), TestRcFileReaderManual.readValues(file, segment.getOffset(), segment.getLength()));
            Assert.assertEquals(segment.getValues(), TestRcFileReaderManual.readValues(file, segment.getOffset(), 1));
            Assert.assertEquals(segment.getValues(), TestRcFileReaderManual.readValues(file, segment.getOffset() - 1, 2));
            Assert.assertEquals((Collection)ImmutableList.of(), TestRcFileReaderManual.readValues(file, segment.getOffset() + 1, 1));
            Assert.assertEquals((Collection)ImmutableList.of(), TestRcFileReaderManual.readValues(file, segment.getOffset() + 1, segment.getLength() - 1));
            for (int rowGroupOffset : segment.getRowGroupSegmentOffsets()) {
                Assert.assertEquals(segment.getValues(), TestRcFileReaderManual.readValues(file, segment.getOffset(), rowGroupOffset));
                Assert.assertEquals(segment.getValues(), TestRcFileReaderManual.readValues(file, segment.getOffset(), rowGroupOffset - 1));
                Assert.assertEquals(segment.getValues(), TestRcFileReaderManual.readValues(file, segment.getOffset(), rowGroupOffset + 1));
                Assert.assertEquals((Collection)ImmutableList.of(), TestRcFileReaderManual.readValues(file, segment.getOffset() + rowGroupOffset, segment.getLength() - rowGroupOffset));
            }
        }
        for (int startSegmentIndex = 0; startSegmentIndex < segments.size(); ++startSegmentIndex) {
            Segment startSegment = segments.get(startSegmentIndex);
            for (int endSegmentIndex = startSegmentIndex; endSegmentIndex < segments.size(); ++endSegmentIndex) {
                Segment endSegment = segments.get(endSegmentIndex);
                List segmentsValues = segments.subList(startSegmentIndex, endSegmentIndex + 1).stream().map(Segment::getValues).flatMap(Collection::stream).collect(Collectors.toList());
                Assert.assertEquals(segmentsValues, TestRcFileReaderManual.readValues(file, startSegment.getOffset(), endSegment.getOffset() + endSegment.getLength() - startSegment.getOffset()));
                Assert.assertEquals(segmentsValues, TestRcFileReaderManual.readValues(file, startSegment.getOffset(), endSegment.getOffset() + 1 - startSegment.getOffset()));
                Assert.assertEquals(segmentsValues, TestRcFileReaderManual.readValues(file, startSegment.getOffset() - 1, endSegment.getOffset() + 1 + endSegment.getLength() - startSegment.getOffset()));
                Assert.assertEquals(segmentsValues, TestRcFileReaderManual.readValues(file, startSegment.getOffset() - 1, endSegment.getOffset() + 1 + 1 - startSegment.getOffset()));
            }
        }
    }

    private static Segment writeSegment(SliceOutput output, List<List<Integer>> rowGroups) {
        int offset = output.size();
        if (offset == 0) {
            TestRcFileReaderManual.writeFileHeader(output);
        } else {
            TestRcFileReaderManual.writeSync(output);
        }
        ImmutableList.Builder rowGroupOffsets = ImmutableList.builder();
        for (List<Integer> rowGroup : rowGroups) {
            rowGroupOffsets.add((Object)(output.size() - offset));
            TestRcFileReaderManual.writeRowGroup(output, rowGroup);
        }
        int length = output.size() - offset;
        return new Segment(rowGroups.stream().flatMap(Collection::stream).collect(Collectors.toList()), offset, length, (List<Integer>)rowGroupOffsets.build());
    }

    private static void writeFileHeader(SliceOutput output) {
        output.writeBytes(RCFILE_MAGIC);
        output.writeByte(1);
        output.writeBoolean(false);
        output.writeInt(Integer.reverseBytes(1));
        output.writeByte(COLUMN_COUNT_METADATA_KEY.length());
        output.writeBytes(COLUMN_COUNT_METADATA_KEY);
        output.writeByte(1);
        output.writeByte(49);
        output.writeLong(1311768467284833366L);
        output.writeLong(8687463697196027922L);
    }

    private static void writeSync(SliceOutput output) {
        output.writeInt(-1);
        output.writeLong(1311768467284833366L);
        output.writeLong(8687463697196027922L);
    }

    private static void writeRowGroup(SliceOutput output, List<Integer> shortValues) {
        Preconditions.checkArgument((shortValues.size() < 32 ? 1 : 0) != 0);
        int columnLengthsLength = shortValues.size();
        int keySectionLength = 4 + columnLengthsLength;
        int columnDataLength = shortValues.size() * 2;
        output.writeInt(Integer.reverseBytes(keySectionLength + columnDataLength));
        output.writeInt(Integer.reverseBytes(keySectionLength));
        output.writeInt(Integer.reverseBytes(keySectionLength));
        output.writeByte(shortValues.size());
        output.writeByte(columnDataLength);
        output.writeByte(columnDataLength);
        output.writeByte(columnLengthsLength);
        for (int ignored : shortValues) {
            output.write(2);
        }
        for (int value : shortValues) {
            output.writeShort((int)Short.reverseBytes((short)value));
        }
    }

    private static List<Integer> readValues(Slice data, int offset, int length) throws IOException {
        if (offset < 0) {
            length += offset;
            offset = 0;
        }
        if (offset + length > data.length()) {
            length = data.length() - offset;
        }
        RcFileReader reader = new RcFileReader((RcFileDataSource)new SliceRcFileDataSource(data), (RcFileEncoding)new BinaryRcFileEncoding(), (Map)ImmutableMap.of((Object)0, (Object)SmallintType.SMALLINT), (RcFileCodecFactory)new BogusRcFileCodecFactory(), (long)offset, (long)length, new DataSize(8.0, DataSize.Unit.MEGABYTE));
        ImmutableList.Builder values = ImmutableList.builder();
        while (reader.advance() >= 0) {
            Block block = reader.readBlock(0);
            for (int position = 0; position < block.getPositionCount(); ++position) {
                values.add((Object)((int)SmallintType.SMALLINT.getLong(block, position)));
            }
        }
        return values.build();
    }

    private static class BogusRcFileCodecFactory
    implements RcFileCodecFactory {
        private BogusRcFileCodecFactory() {
        }

        public RcFileCompressor createCompressor(String codecName) {
            throw new UnsupportedOperationException();
        }

        public RcFileDecompressor createDecompressor(String codecName) {
            throw new UnsupportedOperationException();
        }
    }

    private static class SliceRcFileDataSource
    implements RcFileDataSource {
        private static final RcFileDataSourceId DATA_SOURCE_ID = new RcFileDataSourceId("test");
        private final Slice data;

        public SliceRcFileDataSource(Slice data) {
            this.data = data;
        }

        public long getReadBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public long getSize() {
            return this.data.length();
        }

        public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) {
            this.data.getBytes(Math.toIntExact(position), buffer, bufferOffset, bufferLength);
        }

        public void close() {
        }

        public RcFileDataSourceId getId() {
            return DATA_SOURCE_ID;
        }
    }

    private static class Segment {
        private final List<Integer> values;
        private final int offset;
        private final int length;
        private final List<Integer> rowGroupSegmentOffsets;

        public Segment(List<Integer> values, int offset, int length, List<Integer> rowGroupSegmentOffsets) {
            this.values = ImmutableList.copyOf(values);
            this.offset = offset;
            this.length = length;
            this.rowGroupSegmentOffsets = ImmutableList.copyOf(rowGroupSegmentOffsets);
        }

        public List<Integer> getValues() {
            return this.values;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public List<Integer> getRowGroupSegmentOffsets() {
            return this.rowGroupSegmentOffsets;
        }
    }
}

