/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile;

import com.facebook.presto.rcfile.ChunkedSliceOutput;
import com.facebook.presto.rcfile.RcFileCompressor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;

public class AircompressorCompressor
implements RcFileCompressor {
    private final CompressionCodec codec;

    public AircompressorCompressor(CompressionCodec codec) {
        this.codec = Objects.requireNonNull(codec, "codec is null");
    }

    @Override
    public RcFileCompressor.CompressedSliceOutput createCompressedSliceOutput(int minChunkSize, int maxChunkSize) {
        return new AircompressorCompressedSliceOutputSupplier(this.codec, minChunkSize, maxChunkSize).get();
    }

    private static class AircompressorCompressedSliceOutputSupplier
    implements Supplier<RcFileCompressor.CompressedSliceOutput> {
        private final CompressionCodec codec;
        private final Compressor compressor;
        private final ChunkedSliceOutput compressedOutput;

        public AircompressorCompressedSliceOutputSupplier(CompressionCodec codec, int minChunkSize, int maxChunkSize) {
            this.codec = Objects.requireNonNull(codec, "codec is null");
            this.compressor = codec.createCompressor();
            this.compressedOutput = new ChunkedSliceOutput(minChunkSize, maxChunkSize);
        }

        @Override
        public RcFileCompressor.CompressedSliceOutput get() {
            try {
                this.compressor.reset();
                this.compressedOutput.reset();
                CompressionOutputStream compressionStream = this.codec.createOutputStream((OutputStream)((Object)this.compressedOutput), this.compressor);
                return new RcFileCompressor.CompressedSliceOutput((OutputStream)compressionStream, this.compressedOutput, this, () -> {});
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

