/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile.text;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.rcfile.RcFileCorruptionException;
import com.facebook.presto.rcfile.text.BlockEncoding;
import com.facebook.presto.rcfile.text.TextColumnEncoding;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;

public class ListEncoding
extends BlockEncoding {
    private final TextColumnEncoding elementEncoding;

    public ListEncoding(Type type, Slice nullSequence, byte[] separators, Byte escapeByte, TextColumnEncoding elementEncoding) {
        super(type, nullSequence, separators, escapeByte);
        this.elementEncoding = elementEncoding;
    }

    @Override
    public void encodeValueInto(int depth, Block block, int position, SliceOutput output) throws RcFileCorruptionException {
        byte separator = this.getSeparator(depth);
        Block list = block.getBlock(position);
        for (int elementIndex = 0; elementIndex < list.getPositionCount(); ++elementIndex) {
            if (elementIndex > 0) {
                output.writeByte((int)separator);
            }
            if (list.isNull(elementIndex)) {
                output.writeBytes(this.nullSequence);
                continue;
            }
            this.elementEncoding.encodeValueInto(depth + 1, list, elementIndex, output);
        }
    }

    @Override
    public void decodeValueInto(int depth, BlockBuilder builder, Slice slice, int offset, int length) throws RcFileCorruptionException {
        byte separator = this.getSeparator(depth);
        int end = offset + length;
        BlockBuilder arrayBlockBuilder = builder.beginBlockEntry();
        if (length > 0) {
            int elementOffset = offset;
            while (offset < end) {
                byte currentByte = slice.getByte(offset);
                if (currentByte == separator) {
                    this.decodeElementValueInto(depth, arrayBlockBuilder, slice, elementOffset, offset - elementOffset);
                    elementOffset = offset + 1;
                } else if (this.isEscapeByte(currentByte) && offset + 1 < length) {
                    ++offset;
                }
                ++offset;
            }
            this.decodeElementValueInto(depth, arrayBlockBuilder, slice, elementOffset, offset - elementOffset);
        }
        builder.closeEntry();
    }

    private void decodeElementValueInto(int depth, BlockBuilder blockBuilder, Slice slice, int offset, int length) throws RcFileCorruptionException {
        if (this.nullSequence.equals(0, this.nullSequence.length(), slice, offset, length)) {
            blockBuilder.appendNull();
        } else {
            this.elementEncoding.decodeValueInto(depth + 1, blockBuilder, slice, offset, length);
        }
    }
}

