/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigSecuritySensitive;
import com.facebook.presto.spi.HostAddress;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.io.File;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class RedisConnectorConfig {
    private static final int REDIS_DEFAULT_PORT = 6379;
    private Set<HostAddress> nodes = ImmutableSet.of();
    private int redisScanCount = 100;
    private int redisDataBaseIndex;
    private char redisKeyDelimiter = (char)58;
    private String redisPassword;
    private Duration redisConnectTimeout = Duration.valueOf((String)"2000ms");
    private String defaultSchema = "default";
    private Set<String> tableNames = ImmutableSet.of();
    private File tableDescriptionDir = new File("etc/redis/");
    private boolean hideInternalColumns = true;
    private boolean keyPrefixSchemaTable;

    @NotNull
    public File getTableDescriptionDir() {
        return this.tableDescriptionDir;
    }

    @Config(value="redis.table-description-dir")
    public RedisConnectorConfig setTableDescriptionDir(File tableDescriptionDir) {
        this.tableDescriptionDir = tableDescriptionDir;
        return this;
    }

    @NotNull
    public Set<String> getTableNames() {
        return this.tableNames;
    }

    @Config(value="redis.table-names")
    public RedisConnectorConfig setTableNames(String tableNames) {
        this.tableNames = ImmutableSet.copyOf((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)tableNames));
        return this;
    }

    @NotNull
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    @Config(value="redis.default-schema")
    public RedisConnectorConfig setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
        return this;
    }

    @Size(min=1)
    public @Size(min=1) Set<HostAddress> getNodes() {
        return this.nodes;
    }

    @Config(value="redis.nodes")
    public RedisConnectorConfig setNodes(String nodes) {
        this.nodes = nodes == null ? null : RedisConnectorConfig.parseNodes(nodes);
        return this;
    }

    public int getRedisScanCount() {
        return this.redisScanCount;
    }

    @Config(value="redis.scan-count")
    public RedisConnectorConfig setRedisScanCount(int redisScanCount) {
        this.redisScanCount = redisScanCount;
        return this;
    }

    public int getRedisDataBaseIndex() {
        return this.redisDataBaseIndex;
    }

    @Config(value="redis.database-index")
    public RedisConnectorConfig setRedisDataBaseIndex(int redisDataBaseIndex) {
        this.redisDataBaseIndex = redisDataBaseIndex;
        return this;
    }

    @MinDuration(value="1s")
    public Duration getRedisConnectTimeout() {
        return this.redisConnectTimeout;
    }

    @Config(value="redis.connect-timeout")
    public RedisConnectorConfig setRedisConnectTimeout(String redisConnectTimeout) {
        this.redisConnectTimeout = Duration.valueOf((String)redisConnectTimeout);
        return this;
    }

    public char getRedisKeyDelimiter() {
        return this.redisKeyDelimiter;
    }

    @Config(value="redis.key-delimiter")
    public RedisConnectorConfig setRedisKeyDelimiter(String redisKeyDelimiter) {
        this.redisKeyDelimiter = redisKeyDelimiter.charAt(0);
        return this;
    }

    public String getRedisPassword() {
        return this.redisPassword;
    }

    @Config(value="redis.password")
    @ConfigSecuritySensitive
    public RedisConnectorConfig setRedisPassword(String redisPassword) {
        this.redisPassword = redisPassword;
        return this;
    }

    public boolean isHideInternalColumns() {
        return this.hideInternalColumns;
    }

    @Config(value="redis.hide-internal-columns")
    public RedisConnectorConfig setHideInternalColumns(boolean hideInternalColumns) {
        this.hideInternalColumns = hideInternalColumns;
        return this;
    }

    public boolean isKeyPrefixSchemaTable() {
        return this.keyPrefixSchemaTable;
    }

    @Config(value="redis.key-prefix-schema-table")
    public RedisConnectorConfig setKeyPrefixSchemaTable(boolean keyPrefixSchemaTable) {
        this.keyPrefixSchemaTable = keyPrefixSchemaTable;
        return this;
    }

    public static ImmutableSet<HostAddress> parseNodes(String nodes) {
        Splitter splitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)splitter.split((CharSequence)nodes), RedisConnectorConfig::toHostAddress));
    }

    private static HostAddress toHostAddress(String value) {
        return HostAddress.fromString((String)value).withDefaultPort(6379);
    }
}

