/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.RowDecoder;
import com.facebook.presto.redis.RedisColumnHandle;
import com.facebook.presto.redis.RedisJedisManager;
import com.facebook.presto.redis.RedisRecordCursor;
import com.facebook.presto.redis.RedisSplit;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class RedisRecordSet
implements RecordSet {
    private final RedisSplit split;
    private final RedisJedisManager jedisManager;
    private final RowDecoder keyDecoder;
    private final RowDecoder valueDecoder;
    private final List<RedisColumnHandle> columnHandles;
    private final List<Type> columnTypes;

    RedisRecordSet(RedisSplit split, RedisJedisManager jedisManager, List<RedisColumnHandle> columnHandles, RowDecoder keyDecoder, RowDecoder valueDecoder) {
        this.split = Objects.requireNonNull(split, "split is null");
        this.jedisManager = Objects.requireNonNull(jedisManager, "jedisManager is null");
        this.keyDecoder = Objects.requireNonNull(keyDecoder, "keyDecoder is null");
        this.valueDecoder = Objects.requireNonNull(valueDecoder, "valueDecoder is null");
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        ImmutableList.Builder typeBuilder = ImmutableList.builder();
        for (DecoderColumnHandle decoderColumnHandle : columnHandles) {
            typeBuilder.add((Object)decoderColumnHandle.getType());
        }
        this.columnTypes = typeBuilder.build();
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new RedisRecordCursor(this.keyDecoder, this.valueDecoder, this.split, this.columnHandles, this.jedisManager);
    }
}

