/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis.decoder.hash;

import com.facebook.presto.common.type.DateTimeEncoding;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimeWithTimeZoneType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.redis.decoder.hash.HashRedisFieldDecoder;
import com.facebook.presto.redis.decoder.hash.HashRedisValueProvider;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

class ISO8601HashRedisFieldDecoder
extends HashRedisFieldDecoder {
    private static final DateTimeFormatter FORMATTER = ISODateTimeFormat.dateTimeParser().withLocale(Locale.ENGLISH).withZoneUTC();

    ISO8601HashRedisFieldDecoder() {
    }

    @Override
    public FieldValueProvider decode(String value, DecoderColumnHandle columnHandle) {
        return new ISO8601HashRedisValueProvider(columnHandle, value);
    }

    private static class ISO8601HashRedisValueProvider
    extends HashRedisValueProvider {
        public ISO8601HashRedisValueProvider(DecoderColumnHandle columnHandle, String value) {
            super(columnHandle, value);
        }

        @Override
        public long getLong() {
            long millis = FORMATTER.parseMillis(this.getSlice().toStringAscii());
            Type type = this.columnHandle.getType();
            if (type.equals(DateType.DATE)) {
                return TimeUnit.MILLISECONDS.toDays(millis);
            }
            if (type.equals(TimestampType.TIMESTAMP) || type.equals(TimeType.TIME)) {
                return millis;
            }
            if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE) || type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE)) {
                return DateTimeEncoding.packDateTimeWithZone((long)millis, (int)0);
            }
            return millis;
        }
    }
}

