/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourceGroups.db;

import com.facebook.presto.resourceGroups.VariableMap;
import com.facebook.presto.resourceGroups.db.DbResourceGroupConfigurationManager;
import com.facebook.presto.resourceGroups.db.DbResourceGroupsModule;
import com.facebook.presto.resourceGroups.db.ForEnvironment;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.memory.ClusterMemoryPoolManager;
import com.facebook.presto.spi.resourceGroups.ResourceGroupConfigurationManager;
import com.facebook.presto.spi.resourceGroups.ResourceGroupConfigurationManagerContext;
import com.facebook.presto.spi.resourceGroups.ResourceGroupConfigurationManagerFactory;
import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import java.util.Map;
import java.util.Objects;

public class DbResourceGroupConfigurationManagerFactory
implements ResourceGroupConfigurationManagerFactory {
    private final ClassLoader classLoader;

    public DbResourceGroupConfigurationManagerFactory(ClassLoader classLoader) {
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public String getName() {
        return "db";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResourceGroupConfigurationManager<VariableMap> create(Map<String, String> config, ResourceGroupConfigurationManagerContext context) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new DbResourceGroupsModule(), binder -> binder.bind(String.class).annotatedWith(ForEnvironment.class).toInstance((Object)context.getEnvironment()), binder -> binder.bind(ClusterMemoryPoolManager.class).toInstance((Object)context.getMemoryPoolManager())});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            ResourceGroupConfigurationManager resourceGroupConfigurationManager = (ResourceGroupConfigurationManager)injector.getInstance(DbResourceGroupConfigurationManager.class);
            return resourceGroupConfigurationManager;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

