/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourceGroups.db;

import com.facebook.presto.resourceGroups.db.ResourceGroupGlobalProperties;
import com.facebook.presto.resourceGroups.db.ResourceGroupSpecBuilder;
import com.facebook.presto.resourceGroups.db.SelectorRecord;
import java.util.List;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;

public interface ResourceGroupsDao {
    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS resource_groups_global_properties (\n  name VARCHAR(128) NOT NULL PRIMARY KEY,\n  value VARCHAR(512) NULL,\n  CHECK (name in ('cpu_quota_period'))\n)")
    public void createResourceGroupsGlobalPropertiesTable();

    @SqlQuery(value="SELECT value FROM resource_groups_global_properties WHERE name = 'cpu_quota_period'")
    @UseRowMapper(value=ResourceGroupGlobalProperties.Mapper.class)
    public List<ResourceGroupGlobalProperties> getResourceGroupGlobalProperties();

    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS resource_groups (\n  resource_group_id BIGINT NOT NULL AUTO_INCREMENT,\n  name VARCHAR(250) NOT NULL,\n  soft_memory_limit VARCHAR(128) NOT NULL,\n  max_queued INT NOT NULL,\n  soft_concurrency_limit INT NULL,\n  hard_concurrency_limit INT NOT NULL,\n  scheduling_policy VARCHAR(128) NULL,\n  scheduling_weight INT NULL,\n  jmx_export BOOLEAN NULL,\n  soft_cpu_limit VARCHAR(128) NULL,\n  hard_cpu_limit VARCHAR(128) NULL,\n  queued_time_limit VARCHAR(128) NULL,\n  running_time_limit VARCHAR(128) NULL,\n  parent BIGINT NULL,\n  environment VARCHAR(128) NULL,\n  PRIMARY KEY (resource_group_id),\n  FOREIGN KEY (parent) REFERENCES resource_groups (resource_group_id)\n)")
    public void createResourceGroupsTable();

    @SqlQuery(value="SELECT resource_group_id, name, soft_memory_limit, max_queued, soft_concurrency_limit,   hard_concurrency_limit, scheduling_policy, scheduling_weight, jmx_export, soft_cpu_limit,   hard_cpu_limit, queued_time_limit, running_time_limit, parent\nFROM resource_groups\nWHERE environment = :environment\n")
    @UseRowMapper(value=ResourceGroupSpecBuilder.Mapper.class)
    public List<ResourceGroupSpecBuilder> getResourceGroups(@Bind(value="environment") String var1);

    @SqlQuery(value="SELECT S.resource_group_id, S.priority, S.user_regex, S.source_regex, S.query_type, S.client_tags, S.selector_resource_estimate\nFROM selectors S\nJOIN resource_groups R ON (S.resource_group_id = R.resource_group_id)\nWHERE R.environment = :environment\nORDER by priority DESC")
    @UseRowMapper(value=SelectorRecord.Mapper.class)
    public List<SelectorRecord> getSelectors(@Bind(value="environment") String var1);

    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS selectors (\n  resource_group_id BIGINT NOT NULL,\n  priority BIGINT NOT NULL,\n  user_regex VARCHAR(512),\n  source_regex VARCHAR(512),\n  query_type VARCHAR(512),\n  client_tags VARCHAR(512),\n  selector_resource_estimate VARCHAR(1024),\n  FOREIGN KEY (resource_group_id) REFERENCES resource_groups (resource_group_id)\n)")
    public void createSelectorsTable();

    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS exact_match_source_selectors(\n  environment VARCHAR(128),\n  source VARCHAR(512) NOT NULL,\n  query_type VARCHAR(512),\n  update_time DATETIME NOT NULL,\n  resource_group_id VARCHAR(256) NOT NULL,\n  PRIMARY KEY (environment, source, query_type),\n  UNIQUE (source, environment, query_type, resource_group_id)\n)")
    public void createExactMatchSelectorsTable();

    @SqlQuery(value="SELECT resource_group_id\nFROM exact_match_source_selectors\nWHERE source = :source\n  AND (environment = :environment OR environment IS NULL)\n  AND (query_type = :query_type OR query_type IS NULL)\nORDER BY environment IS NULL, query_type IS NULL\nLIMIT 1")
    public String getExactMatchResourceGroup(@Bind(value="environment") String var1, @Bind(value="source") String var2, @Bind(value="query_type") String var3);
}

