/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourceGroups;

import com.facebook.presto.resourceGroups.ResourceGroupNameTemplate;
import com.facebook.presto.resourceGroups.ResourceGroupSpec;
import com.facebook.presto.resourceGroups.SelectorSpec;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ManagerSpec {
    private final List<ResourceGroupSpec> rootGroups;
    private final List<SelectorSpec> selectors;
    private final Optional<Duration> cpuQuotaPeriod;

    @JsonCreator
    public ManagerSpec(@JsonProperty(value="rootGroups") List<ResourceGroupSpec> rootGroups, @JsonProperty(value="selectors") List<SelectorSpec> selectors, @JsonProperty(value="cpuQuotaPeriod") Optional<Duration> cpuQuotaPeriod) {
        this.rootGroups = ImmutableList.copyOf((Collection)Objects.requireNonNull(rootGroups, "rootGroups is null"));
        this.selectors = ImmutableList.copyOf((Collection)Objects.requireNonNull(selectors, "selectors is null"));
        this.cpuQuotaPeriod = Objects.requireNonNull(cpuQuotaPeriod, "cpuQuotaPeriod is null");
        HashSet<ResourceGroupNameTemplate> names = new HashSet<ResourceGroupNameTemplate>();
        for (ResourceGroupSpec group : rootGroups) {
            Preconditions.checkArgument((!names.contains(group.getName()) ? 1 : 0) != 0, (String)"Duplicated root group: %s", (Object)group.getName());
            names.add(group.getName());
        }
    }

    public List<ResourceGroupSpec> getRootGroups() {
        return this.rootGroups;
    }

    public List<SelectorSpec> getSelectors() {
        return this.selectors;
    }

    public Optional<Duration> getCpuQuotaPeriod() {
        return this.cpuQuotaPeriod;
    }
}

