/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourceGroups;

import com.facebook.presto.resourceGroups.ResourceGroupNameTemplate;
import com.facebook.presto.spi.resourceGroups.SchedulingPolicy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceGroupSpec {
    private static final Pattern PERCENT_PATTERN = Pattern.compile("(\\d{1,3}(:?\\.\\d+)?)%");
    private final ResourceGroupNameTemplate name;
    private final Optional<DataSize> softMemoryLimit;
    private final Optional<Double> softMemoryLimitFraction;
    private final int maxQueued;
    private final Optional<Integer> softConcurrencyLimit;
    private final int hardConcurrencyLimit;
    private final Optional<SchedulingPolicy> schedulingPolicy;
    private final Optional<Integer> schedulingWeight;
    private final List<ResourceGroupSpec> subGroups;
    private final Optional<Boolean> jmxExport;
    private final Optional<Duration> softCpuLimit;
    private final Optional<Duration> hardCpuLimit;
    private final Optional<Duration> queuedTimeLimit;
    private final Optional<Duration> runningTimeLimit;

    @JsonCreator
    public ResourceGroupSpec(@JsonProperty(value="name") ResourceGroupNameTemplate name, @JsonProperty(value="softMemoryLimit") String softMemoryLimit, @JsonProperty(value="maxQueued") int maxQueued, @JsonProperty(value="softConcurrencyLimit") Optional<Integer> softConcurrencyLimit, @JsonProperty(value="hardConcurrencyLimit") Optional<Integer> hardConcurrencyLimit, @JsonProperty(value="maxRunning") Optional<Integer> maxRunning, @JsonProperty(value="schedulingPolicy") Optional<String> schedulingPolicy, @JsonProperty(value="schedulingWeight") Optional<Integer> schedulingWeight, @JsonProperty(value="subGroups") Optional<List<ResourceGroupSpec>> subGroups, @JsonProperty(value="jmxExport") Optional<Boolean> jmxExport, @JsonProperty(value="softCpuLimit") Optional<Duration> softCpuLimit, @JsonProperty(value="hardCpuLimit") Optional<Duration> hardCpuLimit, @JsonProperty(value="queuedTimeLimit") Optional<Duration> queuedTimeLimit, @JsonProperty(value="runningTimeLimit") Optional<Duration> runningTimeLimit) {
        Optional<Object> fraction;
        Optional<Object> absoluteSize;
        this.softCpuLimit = Objects.requireNonNull(softCpuLimit, "softCpuLimit is null");
        this.hardCpuLimit = Objects.requireNonNull(hardCpuLimit, "hardCpuLimit is null");
        this.jmxExport = Objects.requireNonNull(jmxExport, "jmxExport is null");
        this.queuedTimeLimit = Objects.requireNonNull(queuedTimeLimit, "queuedTimeLimit is null");
        this.runningTimeLimit = Objects.requireNonNull(runningTimeLimit, "runningTimeLimit is null");
        this.name = Objects.requireNonNull(name, "name is null");
        Preconditions.checkArgument((maxQueued >= 0 ? 1 : 0) != 0, (Object)"maxQueued is negative");
        this.maxQueued = maxQueued;
        this.softConcurrencyLimit = softConcurrencyLimit;
        Preconditions.checkArgument((hardConcurrencyLimit.isPresent() || maxRunning.isPresent() ? 1 : 0) != 0, (Object)"Missing required property: hardConcurrencyLimit");
        this.hardConcurrencyLimit = hardConcurrencyLimit.orElseGet(maxRunning::get);
        Preconditions.checkArgument((this.hardConcurrencyLimit >= 0 ? 1 : 0) != 0, (Object)"hardConcurrencyLimit is negative");
        softConcurrencyLimit.ifPresent(soft -> Preconditions.checkArgument((soft >= 0 ? 1 : 0) != 0, (Object)"softConcurrencyLimit is negative"));
        softConcurrencyLimit.ifPresent(soft -> Preconditions.checkArgument((this.hardConcurrencyLimit >= soft ? 1 : 0) != 0, (Object)"hardConcurrencyLimit must be greater than or equal to softConcurrencyLimit"));
        this.schedulingPolicy = Objects.requireNonNull(schedulingPolicy, "schedulingPolicy is null").map(value -> SchedulingPolicy.valueOf((String)value.toUpperCase()));
        this.schedulingWeight = Objects.requireNonNull(schedulingWeight, "schedulingWeight is null");
        Objects.requireNonNull(softMemoryLimit, "softMemoryLimit is null");
        Matcher matcher = PERCENT_PATTERN.matcher(softMemoryLimit);
        if (matcher.matches()) {
            absoluteSize = Optional.empty();
            fraction = Optional.of(Double.parseDouble(matcher.group(1)) / 100.0);
        } else {
            absoluteSize = Optional.of(DataSize.valueOf((String)softMemoryLimit));
            fraction = Optional.empty();
        }
        this.softMemoryLimit = absoluteSize;
        this.softMemoryLimitFraction = fraction;
        this.subGroups = ImmutableList.copyOf((Collection)Objects.requireNonNull(subGroups, "subGroups is null").orElse((List<ResourceGroupSpec>)ImmutableList.of()));
        HashSet<ResourceGroupNameTemplate> names = new HashSet<ResourceGroupNameTemplate>();
        for (ResourceGroupSpec subGroup : this.subGroups) {
            Preconditions.checkArgument((!names.contains(subGroup.getName()) ? 1 : 0) != 0, (String)"Duplicated sub group: %s", (Object)subGroup.getName());
            names.add(subGroup.getName());
        }
    }

    public Optional<DataSize> getSoftMemoryLimit() {
        return this.softMemoryLimit;
    }

    public Optional<Double> getSoftMemoryLimitFraction() {
        return this.softMemoryLimitFraction;
    }

    public int getMaxQueued() {
        return this.maxQueued;
    }

    public Optional<Integer> getSoftConcurrencyLimit() {
        return this.softConcurrencyLimit;
    }

    public int getHardConcurrencyLimit() {
        return this.hardConcurrencyLimit;
    }

    public Optional<SchedulingPolicy> getSchedulingPolicy() {
        return this.schedulingPolicy;
    }

    public Optional<Integer> getSchedulingWeight() {
        return this.schedulingWeight;
    }

    public ResourceGroupNameTemplate getName() {
        return this.name;
    }

    public List<ResourceGroupSpec> getSubGroups() {
        return this.subGroups;
    }

    public Optional<Boolean> getJmxExport() {
        return this.jmxExport;
    }

    public Optional<Duration> getSoftCpuLimit() {
        return this.softCpuLimit;
    }

    public Optional<Duration> getHardCpuLimit() {
        return this.hardCpuLimit;
    }

    public Optional<Duration> getQueuedTimeLimit() {
        return this.queuedTimeLimit;
    }

    public Optional<Duration> getRunningTimeLimit() {
        return this.runningTimeLimit;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ResourceGroupSpec)) {
            return false;
        }
        ResourceGroupSpec that = (ResourceGroupSpec)other;
        return this.name.equals(that.name) && this.softMemoryLimit.equals(that.softMemoryLimit) && this.maxQueued == that.maxQueued && this.softConcurrencyLimit.equals(that.softConcurrencyLimit) && this.hardConcurrencyLimit == that.hardConcurrencyLimit && this.schedulingPolicy.equals(that.schedulingPolicy) && this.schedulingWeight.equals(that.schedulingWeight) && this.subGroups.equals(that.subGroups) && this.jmxExport.equals(that.jmxExport) && this.softCpuLimit.equals(that.softCpuLimit) && this.hardCpuLimit.equals(that.hardCpuLimit) && this.queuedTimeLimit.equals(that.queuedTimeLimit) && this.runningTimeLimit.equals(that.runningTimeLimit);
    }

    public boolean sameConfig(ResourceGroupSpec other) {
        if (other == null) {
            return false;
        }
        return this.name.equals(other.name) && this.softMemoryLimit.equals(other.softMemoryLimit) && this.maxQueued == other.maxQueued && this.softConcurrencyLimit.equals(other.softConcurrencyLimit) && this.hardConcurrencyLimit == other.hardConcurrencyLimit && this.schedulingPolicy.equals(other.schedulingPolicy) && this.schedulingWeight.equals(other.schedulingWeight) && this.jmxExport.equals(other.jmxExport) && this.softCpuLimit.equals(other.softCpuLimit) && this.hardCpuLimit.equals(other.hardCpuLimit) && this.queuedTimeLimit.equals(other.queuedTimeLimit) && this.runningTimeLimit.equals(other.runningTimeLimit);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.softMemoryLimit, this.maxQueued, this.softConcurrencyLimit, this.hardConcurrencyLimit, this.schedulingPolicy, this.schedulingWeight, this.subGroups, this.jmxExport, this.softCpuLimit, this.hardCpuLimit, this.queuedTimeLimit, this.runningTimeLimit);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("softMemoryLimit", this.softMemoryLimit).add("maxQueued", this.maxQueued).add("softConcurrencyLimit", this.softConcurrencyLimit).add("hardConcurrencyLimit", this.hardConcurrencyLimit).add("schedulingPolicy", this.schedulingPolicy).add("schedulingWeight", this.schedulingWeight).add("jmxExport", this.jmxExport).add("softCpuLimit", this.softCpuLimit).add("hardCpuLimit", this.hardCpuLimit).add("queuedTimeLimit", this.queuedTimeLimit).add("runningTimeLimit", this.runningTimeLimit).toString();
    }
}

