/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourceGroups.db;

import com.facebook.presto.resourceGroups.AbstractResourceConfigurationManager;
import com.facebook.presto.resourceGroups.ManagerSpec;
import com.facebook.presto.resourceGroups.ResourceGroupIdTemplate;
import com.facebook.presto.resourceGroups.ResourceGroupSelector;
import com.facebook.presto.resourceGroups.ResourceGroupSpec;
import com.facebook.presto.resourceGroups.SelectorSpec;
import com.facebook.presto.resourceGroups.VariableMap;
import com.facebook.presto.resourceGroups.db.DbResourceGroupConfig;
import com.facebook.presto.resourceGroups.db.DbSourceExactMatchSelector;
import com.facebook.presto.resourceGroups.db.ForEnvironment;
import com.facebook.presto.resourceGroups.db.ResourceGroupGlobalProperties;
import com.facebook.presto.resourceGroups.db.ResourceGroupSpecBuilder;
import com.facebook.presto.resourceGroups.db.ResourceGroupsDao;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.memory.ClusterMemoryPoolManager;
import com.facebook.presto.spi.resourceGroups.ResourceGroup;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.resourceGroups.SelectionContext;
import com.facebook.presto.spi.resourceGroups.SelectionCriteria;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.stats.CounterStat;
import io.airlift.units.Duration;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class DbResourceGroupConfigurationManager
extends AbstractResourceConfigurationManager {
    private static final Logger log = Logger.get(DbResourceGroupConfigurationManager.class);
    private final ResourceGroupsDao dao;
    private final ConcurrentMap<ResourceGroupId, ResourceGroup> groups = new ConcurrentHashMap<ResourceGroupId, ResourceGroup>();
    @GuardedBy(value="this")
    private Map<ResourceGroupIdTemplate, ResourceGroupSpec> resourceGroupSpecs = new HashMap<ResourceGroupIdTemplate, ResourceGroupSpec>();
    private final ConcurrentMap<ResourceGroupIdTemplate, List<ResourceGroupId>> configuredGroups = new ConcurrentHashMap<ResourceGroupIdTemplate, List<ResourceGroupId>>();
    private final AtomicReference<List<ResourceGroupSpec>> rootGroups = new AtomicReference<ImmutableList>(ImmutableList.of());
    private final AtomicReference<List<ResourceGroupSelector>> selectors = new AtomicReference();
    private final AtomicReference<Optional<Duration>> cpuQuotaPeriod = new AtomicReference(Optional.empty());
    private final ScheduledExecutorService configExecutor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"DbResourceGroupConfigurationManager"));
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicLong lastRefresh = new AtomicLong();
    private final String environment;
    private final Duration maxRefreshInterval;
    private final boolean exactMatchSelectorEnabled;
    private final CounterStat refreshFailures = new CounterStat();

    @Inject
    public DbResourceGroupConfigurationManager(ClusterMemoryPoolManager memoryPoolManager, DbResourceGroupConfig config, ResourceGroupsDao dao, @ForEnvironment String environment) {
        super(memoryPoolManager);
        Objects.requireNonNull(memoryPoolManager, "memoryPoolManager is null");
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(dao, "daoProvider is null");
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.maxRefreshInterval = config.getMaxRefreshInterval();
        this.exactMatchSelectorEnabled = config.getExactMatchSelectorEnabled();
        this.dao = dao;
        this.dao.createResourceGroupsGlobalPropertiesTable();
        this.dao.createResourceGroupsTable();
        this.dao.createSelectorsTable();
        if (this.exactMatchSelectorEnabled) {
            this.dao.createExactMatchSelectorsTable();
        }
        this.load();
    }

    @Override
    protected Optional<Duration> getCpuQuotaPeriod() {
        return this.cpuQuotaPeriod.get();
    }

    @Override
    protected List<ResourceGroupSpec> getRootGroups() {
        if (this.lastRefresh.get() == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_UNAVAILABLE, "Root groups cannot be fetched from database");
        }
        if (this.selectors.get().isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_INVALID, "No root groups are configured");
        }
        return this.rootGroups.get();
    }

    @PreDestroy
    public void destroy() {
        this.configExecutor.shutdownNow();
    }

    @PostConstruct
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.configExecutor.scheduleWithFixedDelay(this::load, 1L, 1L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(ResourceGroup group, SelectionContext<VariableMap> criteria) {
        Map.Entry<ResourceGroupIdTemplate, ResourceGroupSpec> entry = this.getMatchingSpec(group, criteria);
        if (this.groups.putIfAbsent(group.getId(), group) == null) {
            this.configuredGroups.computeIfAbsent(entry.getKey(), v -> new LinkedList()).add(group.getId());
        }
        ResourceGroup resourceGroup = this.getRootGroup(group.getId());
        synchronized (resourceGroup) {
            this.configureGroup(group, entry.getValue());
        }
    }

    public Optional<SelectionContext<VariableMap>> match(SelectionCriteria criteria) {
        if (this.lastRefresh.get() == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_UNAVAILABLE, "Selectors cannot be fetched from database");
        }
        if (this.selectors.get().isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_INVALID, "No selectors are configured");
        }
        return this.selectors.get().stream().map(s -> s.match(criteria)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @VisibleForTesting
    public List<ResourceGroupSelector> getSelectors() {
        if (this.lastRefresh.get() == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_UNAVAILABLE, "Selectors cannot be fetched from database");
        }
        if (this.selectors.get().isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_INVALID, "No selectors are configured");
        }
        return this.selectors.get();
    }

    private synchronized Optional<Duration> getCpuQuotaPeriodFromDb() {
        List<ResourceGroupGlobalProperties> globalProperties = this.dao.getResourceGroupGlobalProperties();
        Preconditions.checkState((globalProperties.size() <= 1 ? 1 : 0) != 0, (Object)"There is more than one cpu_quota_period");
        return !globalProperties.isEmpty() ? globalProperties.get(0).getCpuQuotaPeriod() : Optional.empty();
    }

    @VisibleForTesting
    public synchronized void load() {
        try {
            Map.Entry<ManagerSpec, Map<ResourceGroupIdTemplate, ResourceGroupSpec>> specsFromDb = this.buildSpecsFromDb();
            ManagerSpec managerSpec = specsFromDb.getKey();
            Map<ResourceGroupIdTemplate, ResourceGroupSpec> resourceGroupSpecs = specsFromDb.getValue();
            HashSet<ResourceGroupIdTemplate> changedSpecs = new HashSet<ResourceGroupIdTemplate>();
            Sets.SetView deletedSpecs = Sets.difference(this.resourceGroupSpecs.keySet(), resourceGroupSpecs.keySet());
            for (Map.Entry<ResourceGroupIdTemplate, ResourceGroupSpec> entry : resourceGroupSpecs.entrySet()) {
                if (entry.getValue().sameConfig(this.resourceGroupSpecs.get(entry.getKey()))) continue;
                changedSpecs.add(entry.getKey());
            }
            this.resourceGroupSpecs = resourceGroupSpecs;
            this.cpuQuotaPeriod.set(managerSpec.getCpuQuotaPeriod());
            this.rootGroups.set(managerSpec.getRootGroups());
            List<ResourceGroupSelector> selectors = this.buildSelectors(managerSpec);
            if (this.exactMatchSelectorEnabled) {
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)new DbSourceExactMatchSelector(this.environment, this.dao));
                builder.addAll(selectors);
                this.selectors.set((List<ResourceGroupSelector>)builder.build());
            } else {
                this.selectors.set(selectors);
            }
            this.configureChangedGroups(changedSpecs);
            this.disableDeletedGroups((Set<ResourceGroupIdTemplate>)deletedSpecs);
            if (this.lastRefresh.get() > 0L) {
                for (ResourceGroupIdTemplate deleted : deletedSpecs) {
                    log.info("Resource group spec deleted %s", new Object[]{deleted});
                }
                for (ResourceGroupIdTemplate changed : changedSpecs) {
                    log.info("Resource group spec %s changed to %s", new Object[]{changed, resourceGroupSpecs.get(changed)});
                }
            } else {
                log.info("Loaded %s selectors and %s resource groups from database", new Object[]{this.selectors.get().size(), this.resourceGroupSpecs.size()});
            }
            this.lastRefresh.set(System.nanoTime());
        }
        catch (Throwable e) {
            if (Duration.succinctNanos((long)(System.nanoTime() - this.lastRefresh.get())).compareTo(this.maxRefreshInterval) > 0) {
                this.lastRefresh.set(0L);
            }
            this.refreshFailures.update(1L);
            log.error(e, "Error loading configuration from db");
        }
    }

    private synchronized void populateFromDbHelper(Map<Long, ResourceGroupSpecBuilder> recordMap, Set<Long> rootGroupIds, Map<Long, ResourceGroupIdTemplate> resourceGroupIdTemplateMap, Map<Long, Set<Long>> subGroupIdsToBuild) {
        List<ResourceGroupSpecBuilder> records = this.dao.getResourceGroups(this.environment);
        for (ResourceGroupSpecBuilder record : records) {
            recordMap.put(record.getId(), record);
            if (!record.getParentId().isPresent()) {
                rootGroupIds.add(record.getId());
                resourceGroupIdTemplateMap.put(record.getId(), new ResourceGroupIdTemplate(record.getNameTemplate().toString()));
                continue;
            }
            subGroupIdsToBuild.computeIfAbsent(record.getParentId().get(), k -> new HashSet()).add(record.getId());
        }
    }

    private synchronized Map.Entry<ManagerSpec, Map<ResourceGroupIdTemplate, ResourceGroupSpec>> buildSpecsFromDb() {
        HashMap resourceGroupSpecs = new HashMap();
        HashSet<Long> rootGroupIds = new HashSet<Long>();
        HashMap<Long, ResourceGroupSpec> resourceGroupSpecMap = new HashMap<Long, ResourceGroupSpec>();
        HashMap<Long, ResourceGroupIdTemplate> resourceGroupIdTemplateMap = new HashMap<Long, ResourceGroupIdTemplate>();
        HashMap<Long, ResourceGroupSpecBuilder> recordMap = new HashMap<Long, ResourceGroupSpecBuilder>();
        HashMap<Long, Set<Long>> subGroupIdsToBuild = new HashMap<Long, Set<Long>>();
        this.populateFromDbHelper(recordMap, rootGroupIds, resourceGroupIdTemplateMap, subGroupIdsToBuild);
        LinkedList<Long> queue = new LinkedList<Long>(rootGroupIds);
        while (!queue.isEmpty()) {
            Long id = queue.pollFirst();
            resourceGroupIdTemplateMap.computeIfAbsent(id, k -> {
                ResourceGroupSpecBuilder builder = (ResourceGroupSpecBuilder)recordMap.get(id);
                return ResourceGroupIdTemplate.forSubGroupNamed((ResourceGroupIdTemplate)resourceGroupIdTemplateMap.get(builder.getParentId().get()), builder.getNameTemplate().toString());
            });
            Set<Long> childrenToBuild = subGroupIdsToBuild.getOrDefault(id, (Set<Long>)ImmutableSet.of());
            if (childrenToBuild.isEmpty()) {
                ResourceGroupSpecBuilder builder = (ResourceGroupSpecBuilder)recordMap.get(id);
                ResourceGroupSpec resourceGroupSpec = builder.build();
                resourceGroupSpecMap.put(id, resourceGroupSpec);
                resourceGroupSpecs.put(resourceGroupIdTemplateMap.get(id), resourceGroupSpec);
                builder.getParentId().ifPresent(parentId -> {
                    ((ResourceGroupSpecBuilder)recordMap.get(parentId)).addSubGroup(resourceGroupSpec);
                    ((Set)subGroupIdsToBuild.get(parentId)).remove(id);
                });
                continue;
            }
            queue.addFirst(id);
            queue.addAll(0, childrenToBuild);
        }
        List<ResourceGroupSpec> rootGroups = rootGroupIds.stream().map(resourceGroupSpecMap::get).collect(Collectors.toList());
        List<SelectorSpec> selectors = this.dao.getSelectors(this.environment).stream().map(selectorRecord -> new SelectorSpec(selectorRecord.getUserRegex(), selectorRecord.getSourceRegex(), selectorRecord.getQueryType(), selectorRecord.getClientTags(), selectorRecord.getSelectorResourceEstimate(), (ResourceGroupIdTemplate)resourceGroupIdTemplateMap.get(selectorRecord.getResourceGroupId()))).collect(Collectors.toList());
        ManagerSpec managerSpec = new ManagerSpec(rootGroups, selectors, this.getCpuQuotaPeriodFromDb());
        this.validateRootGroups(managerSpec);
        return new AbstractMap.SimpleImmutableEntry<ManagerSpec, Map<ResourceGroupIdTemplate, ResourceGroupSpec>>(managerSpec, resourceGroupSpecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void configureChangedGroups(Set<ResourceGroupIdTemplate> changedSpecs) {
        for (ResourceGroupIdTemplate resourceGroupIdTemplate : changedSpecs) {
            for (ResourceGroupId resourceGroupId : this.configuredGroups.getOrDefault(resourceGroupIdTemplate, (List<ResourceGroupId>)ImmutableList.of())) {
                ResourceGroup resourceGroup = this.getRootGroup(resourceGroupId);
                synchronized (resourceGroup) {
                    this.configureGroup((ResourceGroup)this.groups.get(resourceGroupId), this.resourceGroupSpecs.get(resourceGroupIdTemplate));
                }
            }
        }
    }

    private synchronized void disableDeletedGroups(Set<ResourceGroupIdTemplate> deletedSpecs) {
        for (ResourceGroupIdTemplate resourceGroupIdTemplate : deletedSpecs) {
            for (ResourceGroupId resourceGroupId : this.configuredGroups.getOrDefault(resourceGroupIdTemplate, (List<ResourceGroupId>)ImmutableList.of())) {
                this.disableGroup((ResourceGroup)this.groups.get(resourceGroupId));
            }
        }
    }

    private synchronized void disableGroup(ResourceGroup group) {
        group.setHardConcurrencyLimit(0);
        group.setMaxQueuedQueries(0);
    }

    private ResourceGroup getRootGroup(ResourceGroupId groupId) {
        Optional parent = groupId.getParent();
        while (parent.isPresent()) {
            groupId = (ResourceGroupId)parent.get();
            parent = groupId.getParent();
        }
        return (ResourceGroup)this.groups.get(groupId);
    }

    @Managed
    @Nested
    public CounterStat getRefreshFailures() {
        return this.refreshFailures;
    }
}

