/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Supplier;
import org.jdbi.v3.core.mapper.reflect.ColumnNameMatcher;
import org.jdbi.v3.core.mapper.reflect.ReflectionMappers;
import org.jdbi.v3.core.statement.StatementContext;

class ReflectionMapperUtil {
    ReflectionMapperUtil() {
    }

    static List<String> getColumnNames(ResultSet rs) throws SQLException {
        ResultSetMetaData metadata = rs.getMetaData();
        int count = metadata.getColumnCount();
        ArrayList<String> columnNames = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            columnNames.add(metadata.getColumnLabel(i + 1).toLowerCase());
        }
        return columnNames;
    }

    static List<ColumnNameMatcher> getColumnNameMatchers(StatementContext ctx) {
        return ctx.getConfig(ReflectionMappers.class).getColumnNameMatchers();
    }

    static OptionalInt findColumnIndex(String paramName, List<String> columnNames, List<ColumnNameMatcher> columnNameMatchers, Supplier<String> debugName) {
        OptionalInt result = OptionalInt.empty();
        block0: for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = columnNames.get(i);
            for (ColumnNameMatcher strategy : columnNameMatchers) {
                if (!strategy.columnNameMatches(columnName, paramName)) continue;
                if (result.isPresent()) {
                    throw new IllegalArgumentException(String.format("'%s' (%s) matches multiple columns: '%s' (%d) and '%s' (%d)", debugName.get(), paramName, columnNames.get(result.getAsInt()), result.getAsInt(), columnNames.get(i), i));
                }
                result = OptionalInt.of(i);
                continue block0;
            }
        }
        return result;
    }
}

