/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourceGroups;

import com.facebook.presto.common.resourceGroups.QueryType;
import com.facebook.presto.resourceGroups.ManagerSpec;
import com.facebook.presto.resourceGroups.ResourceGroupIdTemplate;
import com.facebook.presto.resourceGroups.ResourceGroupNameTemplate;
import com.facebook.presto.resourceGroups.ResourceGroupSelector;
import com.facebook.presto.resourceGroups.ResourceGroupSpec;
import com.facebook.presto.resourceGroups.SelectorSpec;
import com.facebook.presto.resourceGroups.StaticSelector;
import com.facebook.presto.resourceGroups.VariableMap;
import com.facebook.presto.spi.memory.ClusterMemoryPoolManager;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.resourceGroups.ResourceGroup;
import com.facebook.presto.spi.resourceGroups.ResourceGroupConfigurationManager;
import com.facebook.presto.spi.resourceGroups.SelectionContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.concurrent.GuardedBy;

public abstract class AbstractResourceConfigurationManager
implements ResourceGroupConfigurationManager<VariableMap> {
    @GuardedBy(value="generalPoolMemoryFraction")
    private final Map<ResourceGroup, Double> generalPoolMemoryFraction = new HashMap<ResourceGroup, Double>();
    @GuardedBy(value="generalPoolMemoryFraction")
    private long generalPoolBytes;

    protected abstract Optional<Duration> getCpuQuotaPeriod();

    protected abstract List<ResourceGroupSpec> getRootGroups();

    protected void validateRootGroups(ManagerSpec managerSpec) {
        LinkedList<ResourceGroupSpec> groups = new LinkedList<ResourceGroupSpec>(managerSpec.getRootGroups());
        block4: while (!groups.isEmpty()) {
            ResourceGroupSpec group = (ResourceGroupSpec)groups.poll();
            List<ResourceGroupSpec> subGroups = group.getSubGroups();
            groups.addAll(subGroups);
            if (group.getSoftCpuLimit().isPresent() || group.getHardCpuLimit().isPresent()) {
                Preconditions.checkArgument((boolean)managerSpec.getCpuQuotaPeriod().isPresent(), (String)"cpuQuotaPeriod must be specified to use cpu limits on group: %s", (Object)group.getName());
            }
            if (group.getSoftCpuLimit().isPresent()) {
                Preconditions.checkArgument((boolean)group.getHardCpuLimit().isPresent(), (Object)"Must specify hard CPU limit in addition to soft limit");
                Preconditions.checkArgument((group.getSoftCpuLimit().get().compareTo(group.getHardCpuLimit().get()) <= 0 ? 1 : 0) != 0, (Object)"Soft CPU limit cannot be greater than hard CPU limit");
            }
            if (!group.getSchedulingPolicy().isPresent()) continue;
            switch (group.getSchedulingPolicy().get()) {
                case WEIGHTED: 
                case WEIGHTED_FAIR: {
                    Preconditions.checkArgument((subGroups.stream().allMatch(t -> t.getSchedulingWeight().isPresent()) || subGroups.stream().noneMatch(t -> t.getSchedulingWeight().isPresent()) ? 1 : 0) != 0, (Object)String.format("Must specify scheduling weight for all sub-groups of '%s' or none of them", group.getName()));
                    break;
                }
                case QUERY_PRIORITY: 
                case FAIR: {
                    for (ResourceGroupSpec subGroup : subGroups) {
                        Preconditions.checkArgument((!subGroup.getSchedulingWeight().isPresent() ? 1 : 0) != 0, (Object)String.format("Must use 'weighted' or 'weighted_fair' scheduling policy if specifying scheduling weight for '%s'", group.getName()));
                    }
                    continue block4;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    protected List<ResourceGroupSelector> buildSelectors(ManagerSpec managerSpec) {
        ImmutableList.Builder selectors = ImmutableList.builder();
        for (SelectorSpec spec : managerSpec.getSelectors()) {
            this.validateSelectors(managerSpec.getRootGroups(), spec);
            selectors.add((Object)new StaticSelector(spec.getUserRegex(), spec.getSourceRegex(), spec.getClientTags(), spec.getResourceEstimate(), spec.getQueryType(), spec.getClientInfoRegex(), spec.getSchema(), spec.getGroup()));
        }
        return selectors.build();
    }

    private void validateSelectors(List<ResourceGroupSpec> groups, SelectorSpec spec) {
        spec.getQueryType().ifPresent(this::validateQueryType);
        List<ResourceGroupNameTemplate> selectorGroups = spec.getGroup().getSegments();
        StringBuilder fullyQualifiedGroupName = new StringBuilder();
        while (!selectorGroups.isEmpty()) {
            ResourceGroupNameTemplate groupName = selectorGroups.get(0);
            fullyQualifiedGroupName.append(groupName);
            Optional<ResourceGroupSpec> match = groups.stream().filter(groupSpec -> groupSpec.getName().equals(groupName)).findFirst();
            if (!match.isPresent()) {
                throw new IllegalArgumentException(String.format("Selector refers to nonexistent group: %s", fullyQualifiedGroupName.toString()));
            }
            fullyQualifiedGroupName.append(".");
            groups = match.get().getSubGroups();
            selectorGroups = selectorGroups.subList(1, selectorGroups.size());
        }
    }

    private void validateQueryType(String queryType) {
        try {
            QueryType.valueOf((String)queryType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Selector specifies an invalid query type: %s", queryType));
        }
    }

    protected AbstractResourceConfigurationManager(ClusterMemoryPoolManager memoryPoolManager) {
        memoryPoolManager.addChangeListener(new MemoryPoolId("general"), poolInfo -> {
            HashMap<ResourceGroup, DataSize> memoryLimits = new HashMap<ResourceGroup, DataSize>();
            Map<ResourceGroup, Double> map = this.generalPoolMemoryFraction;
            synchronized (map) {
                for (Map.Entry<ResourceGroup, Double> entry : this.generalPoolMemoryFraction.entrySet()) {
                    double bytes = (double)poolInfo.getMaxBytes() * entry.getValue();
                    memoryLimits.put(entry.getKey(), new DataSize(bytes, DataSize.Unit.BYTE));
                }
                this.generalPoolBytes = poolInfo.getMaxBytes();
            }
            for (Map.Entry entry : memoryLimits.entrySet()) {
                ((ResourceGroup)entry.getKey()).setSoftMemoryLimit((DataSize)entry.getValue());
            }
        });
    }

    protected Map.Entry<ResourceGroupIdTemplate, ResourceGroupSpec> getMatchingSpec(ResourceGroup group, SelectionContext<VariableMap> context) {
        List<ResourceGroupSpec> candidates = this.getRootGroups();
        List segments = group.getId().getSegments();
        ResourceGroupSpec match = null;
        ArrayList<ResourceGroupNameTemplate> templateId = new ArrayList<ResourceGroupNameTemplate>();
        for (int i = 0; i < segments.size(); ++i) {
            List<ResourceGroupSpec> nextCandidates = null;
            ResourceGroupSpec nextCandidatesParent = null;
            for (ResourceGroupSpec candidate : candidates) {
                if (!candidate.getName().expandTemplate((VariableMap)context.getContext()).equals(segments.get(i))) continue;
                templateId.add(candidate.getName());
                if (i == segments.size() - 1) {
                    if (match != null) {
                        throw new IllegalStateException(String.format("Ambiguous configuration for %s. Matches %s and %s", group.getId(), match.getName(), candidate.getName()));
                    }
                    match = candidate;
                    continue;
                }
                if (nextCandidatesParent != null) {
                    throw new IllegalStateException(String.format("Ambiguous configuration for %s. Matches %s and %s", group.getId(), nextCandidatesParent.getName(), candidate.getName()));
                }
                nextCandidates = candidate.getSubGroups();
                nextCandidatesParent = candidate;
            }
            if (nextCandidates == null) break;
            candidates = nextCandidates;
        }
        Preconditions.checkState((match != null ? 1 : 0) != 0, (String)"No matching configuration found for: %s", (Object)group.getId());
        return new AbstractMap.SimpleImmutableEntry<ResourceGroupIdTemplate, Object>(ResourceGroupIdTemplate.fromSegments(templateId), match);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureGroup(ResourceGroup group, ResourceGroupSpec match) {
        if (match.getSoftMemoryLimit().isPresent()) {
            group.setSoftMemoryLimit(match.getSoftMemoryLimit().get());
        } else {
            Map<ResourceGroup, Double> map = this.generalPoolMemoryFraction;
            synchronized (map) {
                double fraction = match.getSoftMemoryLimitFraction().get();
                this.generalPoolMemoryFraction.put(group, fraction);
                group.setSoftMemoryLimit(new DataSize((double)this.generalPoolBytes * fraction, DataSize.Unit.BYTE));
            }
        }
        group.setMaxQueuedQueries(match.getMaxQueued());
        group.setSoftConcurrencyLimit(match.getSoftConcurrencyLimit().orElse(match.getHardConcurrencyLimit()).intValue());
        group.setHardConcurrencyLimit(match.getHardConcurrencyLimit());
        group.setPerQueryLimits(match.getPerQueryLimits());
        match.getSchedulingPolicy().ifPresent(arg_0 -> ((ResourceGroup)group).setSchedulingPolicy(arg_0));
        match.getSchedulingWeight().ifPresent(arg_0 -> ((ResourceGroup)group).setSchedulingWeight(arg_0));
        match.getJmxExport().filter(Predicate.isEqual(group.getJmxExport()).negate()).ifPresent(arg_0 -> ((ResourceGroup)group).setJmxExport(arg_0));
        match.getSoftCpuLimit().ifPresent(arg_0 -> ((ResourceGroup)group).setSoftCpuLimit(arg_0));
        match.getHardCpuLimit().ifPresent(arg_0 -> ((ResourceGroup)group).setHardCpuLimit(arg_0));
        match.getWorkersPerQueryLimit().ifPresent(arg_0 -> ((ResourceGroup)group).setWorkersPerQueryLimit(arg_0));
        if (match.getSoftCpuLimit().isPresent() || match.getHardCpuLimit().isPresent()) {
            Preconditions.checkState((boolean)this.getCpuQuotaPeriod().isPresent(), (Object)"Must specify hard CPU limit in addition to soft limit");
            Duration limit = match.getHardCpuLimit().isPresent() ? match.getHardCpuLimit().get() : match.getSoftCpuLimit().get();
            long rate = (long)Math.min(1000.0 * (double)limit.toMillis() / (double)this.getCpuQuotaPeriod().get().toMillis(), 9.223372036854776E18);
            rate = Math.max(1L, rate);
            group.setCpuQuotaGenerationMillisPerSecond(rate);
        }
    }
}

