/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourceGroups;

import com.facebook.presto.resourceGroups.VariableMap;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceGroupNameTemplate {
    public static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{([a-zA-Z][a-zA-Z0-9]*)\\}");
    private final List<NameFragment> fragments;

    @JsonCreator
    public ResourceGroupNameTemplate(String name) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Resource group name is empty");
        Preconditions.checkArgument((name.indexOf(46) < 0 ? 1 : 0) != 0, (String)"Invalid resource group name. '%s' contains a '.'", (Object)name);
        String nameNoVariables = VARIABLE_PATTERN.matcher(name).replaceAll("");
        Preconditions.checkArgument((!nameNoVariables.contains("{") && !nameNoVariables.contains("}") && !nameNoVariables.contains("$") ? 1 : 0) != 0, (String)"Invalid resource group name. '%s' contains extraneous '$', '{', or '}", (Object)name);
        ImmutableList.Builder builder = ImmutableList.builder();
        Matcher matcher = VARIABLE_PATTERN.matcher(name);
        int lastMatchEnd = 0;
        while (matcher.find()) {
            int matchBegin = matcher.start();
            int matchEnd = matcher.end();
            if (matchBegin > lastMatchEnd) {
                builder.add((Object)NameFragment.literal(name.substring(lastMatchEnd, matchBegin)));
            }
            builder.add((Object)NameFragment.variable(name.substring(matchBegin + 2, matchEnd - 1)));
            lastMatchEnd = matchEnd;
        }
        if (lastMatchEnd != name.length()) {
            builder.add((Object)NameFragment.literal(name.substring(lastMatchEnd, name.length())));
        }
        this.fragments = builder.build();
    }

    public Set<String> getVariableNames() {
        return (Set)this.fragments.stream().filter(NameFragment::isVariable).map(NameFragment::getVariable).collect(ImmutableSet.toImmutableSet());
    }

    public boolean hasVariables() {
        return this.fragments.stream().anyMatch(NameFragment::isVariable);
    }

    public String expandTemplate(VariableMap variables) {
        StringBuilder builder = new StringBuilder();
        for (NameFragment fragment : this.fragments) {
            if (fragment.isVariable()) {
                String value = variables.getValue(fragment.getVariable());
                Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"unresolved variable '%s' in resource group '%s', available: %s", (Object)fragment.getVariable(), (Object)this, (Object)variables);
                builder.append(value);
                continue;
            }
            builder.append(fragment.getLiteral());
        }
        return builder.toString();
    }

    public String toString() {
        return Joiner.on((String)"").join(this.fragments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceGroupNameTemplate that = (ResourceGroupNameTemplate)o;
        return Objects.equals(this.fragments, that.fragments);
    }

    public int hashCode() {
        return Objects.hash(this.fragments);
    }

    private static final class NameFragment {
        private final String variable;
        private final String literal;

        private NameFragment(String variable, String literal) {
            Preconditions.checkArgument((boolean)(variable == null ^ literal == null), (Object)"only one of variable or literal can be defined");
            this.variable = variable;
            this.literal = literal;
        }

        public static NameFragment variable(String variable) {
            return new NameFragment(variable, null);
        }

        public static NameFragment literal(String literal) {
            return new NameFragment(null, literal);
        }

        public boolean isVariable() {
            return this.variable != null;
        }

        public String getVariable() {
            return this.variable;
        }

        public String getLiteral() {
            return this.literal;
        }

        public String toString() {
            if (this.variable != null) {
                return "${" + this.variable + "}";
            }
            return this.literal;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NameFragment that = (NameFragment)o;
            return Objects.equals(this.variable, that.variable) && Objects.equals(this.literal, that.literal);
        }

        public int hashCode() {
            return Objects.hash(this.variable, this.literal);
        }
    }
}

