/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourceGroups.reloading;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;

public class ReloadingResourceGroupConfig {
    private boolean exactMatchSelectorEnabled;
    private Duration maxRefreshInterval = new Duration(1.0, TimeUnit.HOURS);

    @MinDuration(value="10s")
    public Duration getMaxRefreshInterval() {
        return this.maxRefreshInterval;
    }

    @Config(value="resource-groups.max-refresh-interval")
    @ConfigDescription(value="Time period for which the cluster will continue to accept queries after refresh failures cause configuration to become stale")
    public ReloadingResourceGroupConfig setMaxRefreshInterval(Duration maxRefreshInterval) {
        this.maxRefreshInterval = maxRefreshInterval;
        return this;
    }

    public boolean getExactMatchSelectorEnabled() {
        return this.exactMatchSelectorEnabled;
    }

    @Config(value="resource-groups.exact-match-selector-enabled")
    @ConfigDescription(value="Enable and disables selectors being returned as an exact match selector if they match a given selection criteria")
    public ReloadingResourceGroupConfig setExactMatchSelectorEnabled(boolean exactMatchSelectorEnabled) {
        this.exactMatchSelectorEnabled = exactMatchSelectorEnabled;
        return this;
    }
}

