/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import io.airlift.tpch.Customer;
import io.airlift.tpch.Distributions;
import io.airlift.tpch.GenerateUtils;
import io.airlift.tpch.RandomAlphaNumeric;
import io.airlift.tpch.RandomBoundedInt;
import io.airlift.tpch.RandomPhoneNumber;
import io.airlift.tpch.RandomString;
import io.airlift.tpch.RandomText;
import io.airlift.tpch.TextPool;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;

public class CustomerGenerator
implements Iterable<Customer> {
    public static final int SCALE_BASE = 150000;
    private static final int ACCOUNT_BALANCE_MIN = -99999;
    private static final int ACCOUNT_BALANCE_MAX = 999999;
    private static final int ADDRESS_AVERAGE_LENGTH = 25;
    private static final int COMMENT_AVERAGE_LENGTH = 73;
    private final double scaleFactor;
    private final int part;
    private final int partCount;
    private final Distributions distributions;
    private final TextPool textPool;

    public CustomerGenerator(double scaleFactor, int part, int partCount) {
        this(scaleFactor, part, partCount, Distributions.getDefaultDistributions(), TextPool.getDefaultTestPool());
    }

    public CustomerGenerator(double scaleFactor, int part, int partCount, Distributions distributions, TextPool textPool) {
        Preconditions.checkArgument((scaleFactor > 0.0 ? 1 : 0) != 0, (Object)"scaleFactor must be greater than 0");
        Preconditions.checkArgument((part >= 1 ? 1 : 0) != 0, (Object)"part must be at least 1");
        Preconditions.checkArgument((part <= partCount ? 1 : 0) != 0, (Object)"part must be less than or equal to part count");
        this.scaleFactor = scaleFactor;
        this.part = part;
        this.partCount = partCount;
        this.distributions = Objects.requireNonNull(distributions, "distributions is null");
        this.textPool = Objects.requireNonNull(textPool, "textPool is null");
    }

    @Override
    public Iterator<Customer> iterator() {
        return new CustomerGeneratorIterator(this.distributions, this.textPool, GenerateUtils.calculateStartIndex(150000, this.scaleFactor, this.part, this.partCount), GenerateUtils.calculateRowCount(150000, this.scaleFactor, this.part, this.partCount));
    }

    private static class CustomerGeneratorIterator
    extends AbstractIterator<Customer> {
        private final RandomAlphaNumeric addressRandom = new RandomAlphaNumeric(881155353L, 25);
        private final RandomBoundedInt nationKeyRandom;
        private final RandomPhoneNumber phoneRandom = new RandomPhoneNumber(1521138112L);
        private final RandomBoundedInt accountBalanceRandom = new RandomBoundedInt(298370230L, -99999, 999999);
        private final RandomString marketSegmentRandom;
        private final RandomText commentRandom;
        private final long startIndex;
        private final long rowCount;
        private long index;

        private CustomerGeneratorIterator(Distributions distributions, TextPool textPool, long startIndex, long rowCount) {
            this.startIndex = startIndex;
            this.rowCount = rowCount;
            this.nationKeyRandom = new RandomBoundedInt(1489529863L, 0, distributions.getNations().size() - 1);
            this.marketSegmentRandom = new RandomString(1140279430L, distributions.getMarketSegments());
            this.commentRandom = new RandomText(1335826707L, textPool, 73.0);
            this.addressRandom.advanceRows(startIndex);
            this.nationKeyRandom.advanceRows(startIndex);
            this.phoneRandom.advanceRows(startIndex);
            this.accountBalanceRandom.advanceRows(startIndex);
            this.marketSegmentRandom.advanceRows(startIndex);
            this.commentRandom.advanceRows(startIndex);
        }

        protected Customer computeNext() {
            if (this.index >= this.rowCount) {
                return (Customer)this.endOfData();
            }
            Customer customer = this.makeCustomer(this.startIndex + this.index + 1L);
            this.addressRandom.rowFinished();
            this.nationKeyRandom.rowFinished();
            this.phoneRandom.rowFinished();
            this.accountBalanceRandom.rowFinished();
            this.marketSegmentRandom.rowFinished();
            this.commentRandom.rowFinished();
            ++this.index;
            return customer;
        }

        private Customer makeCustomer(long customerKey) {
            long nationKey = this.nationKeyRandom.nextValue();
            return new Customer(customerKey, customerKey, String.format(Locale.ENGLISH, "Customer#%09d", customerKey), this.addressRandom.nextValue(), nationKey, this.phoneRandom.nextValue(nationKey), this.accountBalanceRandom.nextValue(), this.marketSegmentRandom.nextValue(), this.commentRandom.nextValue());
        }
    }
}

