/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import com.google.common.base.Preconditions;

public class RandomLong {
    private static final long MULTIPLIER = 6364136223846793005L;
    private static final long INCREMENT = 1L;
    private final int expectedUsagePerRow;
    private long seed;
    private int usage;
    private static final long MULTIPLIER_32 = 16807L;
    private static final long MODULUS_32 = Integer.MAX_VALUE;

    public RandomLong(long seed, int expectedUsagePerRow) {
        this.seed = seed;
        this.expectedUsagePerRow = expectedUsagePerRow;
    }

    protected long nextLong(long lowValue, long highValue) {
        this.nextRand();
        long valueInRange = Math.abs(this.seed) % (highValue - lowValue + 1L);
        return lowValue + valueInRange;
    }

    protected long nextRand() {
        Preconditions.checkState((this.usage < this.expectedUsagePerRow ? 1 : 0) != 0, (String)"Expected random to be used only %s times per row", (int)this.expectedUsagePerRow);
        this.seed = this.seed * 6364136223846793005L + 1L;
        ++this.usage;
        return this.seed;
    }

    public void rowFinished() {
        this.advanceSeed32(this.expectedUsagePerRow - this.usage);
        this.usage = 0;
    }

    public void advanceRows(long rowCount) {
        if (this.usage != 0) {
            this.rowFinished();
        }
        this.advanceSeed32((long)this.expectedUsagePerRow * rowCount);
    }

    public void advanceSeed(long count) {
        if (count == 0L) {
            return;
        }
        int numberOfBits = 0;
        while (count >> numberOfBits != 1L) {
            ++numberOfBits;
        }
        long aPow = 6364136223846793005L;
        long dSum = 1L;
        while (--numberOfBits >= 0) {
            dSum *= aPow + 1L;
            aPow *= aPow;
            if ((count >> numberOfBits) % 2L != 1L) continue;
            dSum += aPow;
            aPow *= 6364136223846793005L;
        }
        this.seed = this.seed * aPow + dSum * 1L;
    }

    private void advanceSeed32(long count) {
        long multiplier = 16807L;
        while (count > 0L) {
            if (count % 2L != 0L) {
                this.seed = multiplier * this.seed % Integer.MAX_VALUE;
            }
            count /= 2L;
            multiplier = multiplier * multiplier % Integer.MAX_VALUE;
        }
    }
}

