/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import kafka.cluster.BrokerEndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.AbstractFetcherManager$;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerAndFetcherId;
import kafka.server.BrokerIdAndFetcherId;
import kafka.server.FailedPartitions;
import kafka.server.FetcherLagMetrics;
import kafka.server.InitialFetchState;
import kafka.server.OffsetAndEpoch;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichDouble$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%f!\u0002\u000e\u001c\u0003\u0003\u0001\u0003\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011A\u001b\t\u0011\u0005\u0003!\u0011!Q\u0001\nYB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\")q\t\u0001C\u0001\u0011\"A\u0011\f\u0001b\u0001\n\u0003Y\"\f\u0003\u0004g\u0001\u0001\u0006Ia\u0017\u0005\bO\u0002\u0011\r\u0011\"\u0003i\u0011\u0019\t\b\u0001)A\u0005S\"9!\u000f\u0001a\u0001\n\u0013\u0019\bb\u0002;\u0001\u0001\u0004%I!\u001e\u0005\u0007w\u0002\u0001\u000b\u0015\u0002#\t\u000fq\u0004!\u0019!C\u0001{\"9\u00111\u0001\u0001!\u0002\u0013q\b\"CA\u0003\u0001\t\u0007I\u0011AA\u0004\u0011!\ty\u0002\u0001Q\u0001\n\u0005%\u0001bBA\u0011\u0001\u0011\u0005\u00111\u0005\u0005\t\u0003S\u0001A\u0011A\u000e\u0002,!A\u0011Q\n\u0001\u0005\u0002m\ty\u0005C\u0004\u0002T\u0001!\t!!\u0016\t\u000f\u0005\u001d\u0004A\"\u0001\u0002j!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0005bBAK\u0001\u0011\u0005\u0011q\u0013\u0005\b\u0003G\u0003A\u0011AAS\u0011\u001d\t9\u000b\u0001C\u0001\u0003K\u0013a#\u00112tiJ\f7\r\u001e$fi\u000eDWM]'b]\u0006<WM\u001d\u0006\u00039u\taa]3sm\u0016\u0014(\"\u0001\u0010\u0002\u000b-\fgm[1\u0004\u0001U\u0011\u0011%T\n\u0005\u0001\tBc\u0006\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VM\u001a\t\u0003S1j\u0011A\u000b\u0006\u0003Wu\tQ!\u001e;jYNL!!\f\u0016\u0003\u000f1{wmZ5oOB\u0011qFM\u0007\u0002a)\u0011\u0011'H\u0001\b[\u0016$(/[2t\u0013\t\u0019\u0004GA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\fAA\\1nKV\ta\u0007\u0005\u00028}9\u0011\u0001\b\u0010\t\u0003s\u0011j\u0011A\u000f\u0006\u0003w}\ta\u0001\u0010:p_Rt\u0014BA\u001f%\u0003\u0019\u0001&/\u001a3fM&\u0011q\b\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005u\"\u0013!\u00028b[\u0016\u0004\u0013\u0001C2mS\u0016tG/\u00133\u0002\u00179,XNR3uG\",'o\u001d\t\u0003G\u0015K!A\u0012\u0013\u0003\u0007%sG/\u0001\u0004=S:LGO\u0010\u000b\u0005\u0013Z;\u0006\fE\u0002K\u0001-k\u0011a\u0007\t\u0003\u00196c\u0001\u0001B\u0003O\u0001\t\u0007qJA\u0001U#\t\u00016\u000b\u0005\u0002$#&\u0011!\u000b\n\u0002\b\u001d>$\b.\u001b8h!\tQE+\u0003\u0002V7\t)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0007\"\u0002\u001b\u0006\u0001\u00041\u0004\"\u0002\"\u0006\u0001\u00041\u0004\"B\"\u0006\u0001\u0004!\u0015\u0001\u00054fi\u000eDWM\u001d+ie\u0016\fG-T1q+\u0005Y\u0006\u0003\u0002/bG.k\u0011!\u0018\u0006\u0003=~\u000bq!\\;uC\ndWM\u0003\u0002aI\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\tl&a\u0002%bg\"l\u0015\r\u001d\t\u0003\u0015\u0012L!!Z\u000e\u0003)\t\u0013xn[3s\u0013\u0012\fe\u000e\u001a$fi\u000eDWM]%e\u0003E1W\r^2iKJ$\u0006N]3bI6\u000b\u0007\u000fI\u0001\u0005Y>\u001c7.F\u0001j!\tQw.D\u0001l\u0015\taW.\u0001\u0003mC:<'\"\u00018\u0002\t)\fg/Y\u0005\u0003a.\u0014aa\u00142kK\u000e$\u0018!\u00027pG.\u0004\u0013\u0001\u00068v[\u001a+Go\u00195feN\u0004VM\u001d\"s_.,'/F\u0001E\u0003aqW/\u001c$fi\u000eDWM]:QKJ\u0014%o\\6fe~#S-\u001d\u000b\u0003mf\u0004\"aI<\n\u0005a$#\u0001B+oSRDqA_\u0006\u0002\u0002\u0003\u0007A)A\u0002yIE\nQC\\;n\r\u0016$8\r[3sgB+'O\u0011:pW\u0016\u0014\b%\u0001\tgC&dW\r\u001a)beRLG/[8ogV\ta\u0010\u0005\u0002K\u007f&\u0019\u0011\u0011A\u000e\u0003!\u0019\u000b\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\u0018!\u00054bS2,G\rU1si&$\u0018n\u001c8tA\u0005)b-Y5mK\u0012\u0004\u0016M\u001d;ji&|gn]\"pk:$XCAA\u0005!\u0015\tY!a\u0007E\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011\u0001B2pe\u0016T1!MA\n\u0015\u0011\t)\"a\u0006\u0002\re\fW.\\3s\u0015\t\tI\"A\u0002d_6LA!!\b\u0002\u000e\t)q)Y;hK\u00061b-Y5mK\u0012\u0004\u0016M\u001d;ji&|gn]\"pk:$\b%\u0001\tsKNL'0\u001a+ie\u0016\fG\rU8pYR\u0019a/!\n\t\r\u0005\u001d\u0012\u00031\u0001E\u0003\u001dqWm^*ju\u0016\f!bZ3u\r\u0016$8\r[3s)\u0011\ti#a\r\u0011\t\r\nycS\u0005\u0004\u0003c!#AB(qi&|g\u000eC\u0004\u00026I\u0001\r!a\u000e\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!\u0011\u0011HA%\u001b\t\tYD\u0003\u0003\u0002>\u0005}\u0012AB2p[6|gNC\u0002\u001f\u0003\u0003RA!a\u0011\u0002F\u00051\u0011\r]1dQ\u0016T!!a\u0012\u0002\u0007=\u0014x-\u0003\u0003\u0002L\u0005m\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\rO\u0016$h)\u001a;dQ\u0016\u0014\u0018\n\u001a\u000b\u0004\t\u0006E\u0003bBA\u001b'\u0001\u0007\u0011qG\u0001\u001c[\u0006\u00148\u000eU1si&$\u0018n\u001c8t\r>\u0014HK];oG\u0006$\u0018n\u001c8\u0015\u000fY\f9&a\u0017\u0002^!1\u0011\u0011\f\u000bA\u0002\u0011\u000b\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\u0005\b\u0003k!\u0002\u0019AA\u001c\u0011\u001d\ty\u0006\u0006a\u0001\u0003C\n\u0001\u0003\u001e:v]\u000e\fG/[8o\u001f\u001a47/\u001a;\u0011\u0007\r\n\u0019'C\u0002\u0002f\u0011\u0012A\u0001T8oO\u0006\u00192M]3bi\u00164U\r^2iKJ$\u0006N]3bIR)1*a\u001b\u0002p!1\u0011QN\u000bA\u0002\u0011\u000b\u0011BZ3uG\",'/\u00133\t\u000f\u0005ET\u00031\u0001\u0002t\u0005a1o\\;sG\u0016\u0014%o\\6feB!\u0011QOA>\u001b\t\t9HC\u0002\u0002zu\tqa\u00197vgR,'/\u0003\u0003\u0002~\u0005]$A\u0004\"s_.,'/\u00128e!>Lg\u000e^\u0001\u0018C\u0012$g)\u001a;dQ\u0016\u0014hi\u001c:QCJ$\u0018\u000e^5p]N$2A^AB\u0011\u001d\t)I\u0006a\u0001\u0003\u000f\u000b1\u0003]1si&$\u0018n\u001c8B]\u0012|eMZ:fiN\u0004\u0002\"!#\u0002\f\u0006]\u0012qR\u0007\u0002?&\u0019\u0011QR0\u0003\u00075\u000b\u0007\u000fE\u0002K\u0003#K1!a%\u001c\u0005EIe.\u001b;jC24U\r^2i'R\fG/Z\u0001\u001be\u0016lwN^3GKR\u001c\u0007.\u001a:G_J\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0004m\u0006e\u0005bBAN/\u0001\u0007\u0011QT\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bCBAE\u0003?\u000b9$C\u0002\u0002\"~\u00131aU3u\u0003i\u0019\b.\u001e;e_^t\u0017\n\u001a7f\r\u0016$8\r[3s)\"\u0014X-\u00193t)\u00051\u0018\u0001E2m_N,\u0017\t\u001c7GKR\u001c\u0007.\u001a:t\u0001")
public abstract class AbstractFetcherManager<T extends AbstractFetcherThread>
implements KafkaMetricsGroup {
    private final String name;
    private final HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap;
    private final Object lock;
    private int numFetchersPerBroker;
    private final FailedPartitions failedPartitions;
    private final Gauge<Object> failedPartitionsCount;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AbstractFetcherManager abstractFetcherManager = this;
        synchronized (abstractFetcherManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    public HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap() {
        return this.fetcherThreadMap;
    }

    private Object lock() {
        return this.lock;
    }

    private int numFetchersPerBroker() {
        return this.numFetchersPerBroker;
    }

    private void numFetchersPerBroker_$eq(int x$1) {
        this.numFetchersPerBroker = x$1;
    }

    public FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    public Gauge<Object> failedPartitionsCount() {
        return this.failedPartitionsCount;
    }

    public void resizeThreadPool(int newSize) {
        Object object = this.lock();
        synchronized (object) {
            int currentSize = this.numFetchersPerBroker();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Resizing fetcher thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
            this.numFetchersPerBroker_$eq(newSize);
            if (newSize != currentSize) {
                this.migratePartitions$1(newSize);
            }
            this.shutdownIdleFetcherThreads();
        }
    }

    public Option<T> getFetcher(TopicPartition topicPartition) {
        Option option;
        Object object = this.lock();
        synchronized (object) {
            option = this.fetcherThreadMap().values().find((Function1 & Serializable & scala.Serializable)fetcherThread -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$getFetcher$1(topicPartition, fetcherThread)));
        }
        return option;
    }

    public int getFetcherId(TopicPartition topicPartition) {
        int n;
        Object object = this.lock();
        synchronized (object) {
            n = Utils.abs((int)(31 * topicPartition.topic().hashCode() + topicPartition.partition())) % this.numFetchersPerBroker();
        }
        return n;
    }

    public void markPartitionsForTruncation(int brokerId, TopicPartition topicPartition, long truncationOffset) {
        Object object = this.lock();
        synchronized (object) {
            int fetcherId = this.getFetcherId(topicPartition);
            BrokerIdAndFetcherId brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerId, fetcherId);
            this.fetcherThreadMap().get((Object)brokerIdAndFetcherId).foreach((Function1 & Serializable & scala.Serializable)thread -> {
                thread.markPartitionsForTruncation(topicPartition, truncationOffset);
                return BoxedUnit.UNIT;
            });
        }
    }

    public abstract T createFetcherThread(int var1, BrokerEndPoint var2);

    public void addFetcherForPartitions(Map<TopicPartition, InitialFetchState> partitionAndOffsets) {
        Object object = this.lock();
        synchronized (object) {
            scala.collection.immutable.Map partitionsPerFetcher = partitionAndOffsets.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                InitialFetchState brokerAndInitialFetchOffset = (InitialFetchState)tuple2._2();
                BrokerAndFetcherId brokerAndFetcherId = new BrokerAndFetcherId(brokerAndInitialFetchOffset.leader(), this.getFetcherId(topicPartition));
                return brokerAndFetcherId;
            });
            partitionsPerFetcher.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$addFetcherForPartitions$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                AbstractFetcherManager.$anonfun$addFetcherForPartitions$3(this, partitionAndOffsets, x$2);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void removeFetcherForPartitions(Set<TopicPartition> partitions) {
        block3: {
            Object object = this.lock();
            synchronized (object) {
                this.fetcherThreadMap().values().foreach((Function1 & Serializable & scala.Serializable)fetcher -> {
                    fetcher.removePartitions((Set<TopicPartition>)partitions);
                    return BoxedUnit.UNIT;
                });
                this.failedPartitions().removeAll(partitions);
            }
            if (!partitions.nonEmpty()) break block3;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Removed fetcher for partitions ").append(partitions).toString());
        }
    }

    public void shutdownIdleFetcherThreads() {
        Object object = this.lock();
        synchronized (object) {
            HashSet keysToBeRemoved = new HashSet();
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$shutdownIdleFetcherThreads$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                BoxedUnit boxedUnit;
                Tuple2 tuple2 = x$3;
                if (tuple2 != null) {
                    BrokerIdAndFetcherId key = (BrokerIdAndFetcherId)tuple2._1();
                    AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
                    if (fetcher.partitionCount() <= 0) {
                        fetcher.shutdown();
                        boxedUnit = keysToBeRemoved.$plus$eq((Object)key);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return boxedUnit2;
            });
            HashMap cfr_ignored_0 = (HashMap)this.fetcherThreadMap().$minus$minus$eq((TraversableOnce)keysToBeRemoved);
        }
    }

    public void closeAllFetchers() {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$1(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$2(x$4)));
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$3(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                AbstractFetcherManager.$anonfun$closeAllFetchers$4(x$5);
                return BoxedUnit.UNIT;
            });
            this.fetcherThreadMap().clear();
        }
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$1(AbstractFetcherManager $this, int newSize$1, Tuple2 x0$1) {
        Map<TopicPartition, InitialFetchState> removedPartitions;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            BrokerIdAndFetcherId id = (BrokerIdAndFetcherId)tuple2._1();
            AbstractFetcherThread thread = (AbstractFetcherThread)tuple2._2();
            removedPartitions = thread.partitionsAndOffsets();
            $this.removeFetcherForPartitions((Set<TopicPartition>)removedPartitions.keySet());
            if (id.fetcherId() >= newSize$1) {
                thread.shutdown();
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        $this.addFetcherForPartitions(removedPartitions);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void migratePartitions$1(int newSize) {
        this.fetcherThreadMap().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$1(this, newSize, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getFetcher$1(TopicPartition topicPartition$1, AbstractFetcherThread fetcherThread) {
        return fetcherThread.fetchState(topicPartition$1).isDefined();
    }

    /*
     * WARNING - void declaration
     */
    private final AbstractFetcherThread addAndStartFetcherThread$1(BrokerAndFetcherId brokerAndFetcherId, BrokerIdAndFetcherId brokerIdAndFetcherId) {
        void var3_3;
        T fetcherThread = this.createFetcherThread(brokerAndFetcherId.fetcherId(), brokerAndFetcherId.broker());
        this.fetcherThreadMap().put((Object)brokerIdAndFetcherId, fetcherThread);
        ((Thread)fetcherThread).start();
        return var3_3;
    }

    public static final /* synthetic */ boolean $anonfun$addFetcherForPartitions$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ Tuple2 $anonfun$addFetcherForPartitions$4(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        InitialFetchState brokerAndInitOffset = (InitialFetchState)tuple2._2();
        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetAndEpoch(brokerAndInitOffset.initOffset(), brokerAndInitOffset.currentLeaderEpoch()));
        return tuple22;
    }

    public static final /* synthetic */ String $anonfun$addFetcherForPartitions$5(BrokerAndFetcherId brokerAndFetcherId$1, Map initialOffsetAndEpochs$1) {
        return new StringBuilder(40).append("Added fetcher to broker ").append(brokerAndFetcherId$1.broker()).append(" for partitions ").append(initialOffsetAndEpochs$1).toString();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$3(AbstractFetcherManager $this, Map partitionAndOffsets$1, Tuple2 x$2) {
        var5_3 = x$2;
        if (var5_3 == null) ** GOTO lbl27
        brokerAndFetcherId = (BrokerAndFetcherId)var5_3._1();
        initialFetchOffsets = (Map)var5_3._2();
        brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerAndFetcherId.broker().id(), brokerAndFetcherId.fetcherId());
        var10_7 = false;
        var11_8 = null;
        var12_9 = $this.fetcherThreadMap().get((Object)brokerIdAndFetcherId);
        if (!(var12_9 instanceof Some)) ** GOTO lbl-1000
        var10_7 = true;
        var11_8 = (Some)var12_9;
        currentFetcherThread = (AbstractFetcherThread)var11_8.value();
        v0 = currentFetcherThread.sourceBroker();
        var14_11 = brokerAndFetcherId.broker();
        if (!(v0 != null ? v0.equals(var14_11) == false : var14_11 != null)) {
            var4_12 = currentFetcherThread;
        } else if (var10_7) {
            f = (AbstractFetcherThread)var11_8.value();
            f.shutdown();
            var4_12 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
        } else if (None$.MODULE$.equals(var12_9)) {
            var4_12 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
        } else {
            throw new MatchError((Object)var12_9);
lbl27:
            // 1 sources

            throw new MatchError((Object)var5_3);
        }
        fetcherThread = var4_12;
        initialOffsetAndEpochs = (Map)initialFetchOffsets.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$addFetcherForPartitions$4(scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Tuple2;)(), Map$.MODULE$.canBuildFrom());
        fetcherThread.addPartitions((Map<TopicPartition, OffsetAndEpoch>)initialOffsetAndEpochs);
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$addFetcherForPartitions$5(kafka.server.BrokerAndFetcherId scala.collection.Map ), ()Ljava/lang/String;)((BrokerAndFetcherId)brokerAndFetcherId, (Map)initialOffsetAndEpochs));
        $this.failedPartitions().removeAll((Set<TopicPartition>)partitionAndOffsets$1.keySet());
        var3_16 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$shutdownIdleFetcherThreads$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$1(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$2(Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
        boolean bl = fetcher.initiateShutdown();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$3(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$closeAllFetchers$4(Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
        fetcher.shutdown();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public AbstractFetcherManager(String name, String clientId, int numFetchers) {
        this.name = name;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.fetcherThreadMap = new HashMap();
        this.lock = new Object();
        this.numFetchersPerBroker = numFetchers;
        this.failedPartitions = new FailedPartitions();
        this.logIdent_$eq(new StringBuilder(3).append("[").append(name).append("] ").toString());
        this.newGauge("MaxLag", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public long value() {
                return BoxesRunTime.unboxToLong((Object)this.$outer.fetcherThreadMap().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxAll, fetcherThreadMapEntry) -> BoxesRunTime.boxToLong((long)$anon$1.$anonfun$value$1(BoxesRunTime.unboxToLong((Object)curMaxAll), fetcherThreadMapEntry))));
            }

            public static final /* synthetic */ long $anonfun$value$2(long curMaxThread, Tuple2 fetcherLagStatsEntry) {
                return RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(curMaxThread), ((FetcherLagMetrics)fetcherLagStatsEntry._2()).lag());
            }

            public static final /* synthetic */ long $anonfun$value$1(long curMaxAll, Tuple2 fetcherThreadMapEntry) {
                return RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)((AbstractFetcherThread)fetcherThreadMapEntry._2()).fetcherLagStats().stats().foldLeft(BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxThread, fetcherLagStatsEntry) -> BoxesRunTime.boxToLong((long)$anon$1.$anonfun$value$2(BoxesRunTime.unboxToLong((Object)curMaxThread), fetcherLagStatsEntry))))), curMaxAll);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1$adapted(java.lang.Object scala.Tuple2 ), $anonfun$value$2$adapted(java.lang.Object scala.Tuple2 )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}))));
        this.newGauge("MinFetchRate", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public double value() {
                double headRate = BoxesRunTime.unboxToDouble((Object)this.$outer.fetcherThreadMap().headOption().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)$anon$2.$anonfun$value$3(x$1))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
                return BoxesRunTime.unboxToDouble((Object)this.$outer.fetcherThreadMap().foldLeft((Object)BoxesRunTime.boxToDouble((double)headRate), (Function2 & Serializable & scala.Serializable)(curMinAll, fetcherThreadMapEntry) -> BoxesRunTime.boxToDouble((double)$anon$2.$anonfun$value$5(BoxesRunTime.unboxToDouble((Object)curMinAll), fetcherThreadMapEntry))));
            }

            public static final /* synthetic */ double $anonfun$value$3(Tuple2 x$1) {
                return ((AbstractFetcherThread)x$1._2()).fetcherStats().requestRate().oneMinuteRate();
            }

            public static final /* synthetic */ double $anonfun$value$5(double curMinAll, Tuple2 fetcherThreadMapEntry) {
                return RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(((AbstractFetcherThread)fetcherThreadMapEntry._2()).fetcherStats().requestRate().oneMinuteRate()), curMinAll);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$3$adapted(scala.Tuple2 ), $anonfun$value$4(), $anonfun$value$5$adapted(java.lang.Object scala.Tuple2 )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}))));
        this.failedPartitionsCount = this.newGauge("FailedPartitionsCount", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public int value() {
                return this.$outer.failedPartitions().size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}))));
    }
}

