/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.epoch.EpochEntry;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001\u0002\r\u001a\u0001\u0001B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ts\u0001\u0011\t\u0011)A\u0005u!A\u0001\t\u0001B\u0001B\u0003%\u0011\tC\u0003H\u0001\u0011\u0005\u0001\nC\u0004O\u0001\t\u0007I\u0011B(\t\rq\u0003\u0001\u0015!\u0003Q\u0011\u001di\u0006\u00011A\u0005\nyCqA\u001b\u0001A\u0002\u0013%1\u000e\u0003\u0004r\u0001\u0001\u0006Ka\u0018\u0005\u0006e\u0002!\ta\u001d\u0005\u0006u\u0002!Ia\u001f\u0005\u0006}\u0002!\ta \u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'Aq!a\u0006\u0001\t\u0003\tI\u0002C\u0004\u0002&\u0001!\t!a\n\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u00111\u0007\u0001\u0005\u0002\u0005U\u0002bBA\u001c\u0001\u0011\u0005\u0011Q\u0007\u0005\u0007\u0003s\u0001A\u0011\u00010\t\u000f\u0005m\u0002\u0001\"\u0003\u0002\u0014!9\u0011Q\b\u0001\u0005\n\u0005U\u0002bBA \u0001\u0011%\u0011\u0011\t\u0002\u0015\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NR5mK\u000e\u000b7\r[3\u000b\u0005iY\u0012!B3q_\u000eD'B\u0001\u000f\u001e\u0003\u0019\u0019XM\u001d<fe*\ta$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001\ts\u0005\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0004B]f\u0014VM\u001a\t\u0003Q-j\u0011!\u000b\u0006\u0003Uu\tQ!\u001e;jYNL!\u0001L\u0015\u0003\u000f1{wmZ5oO\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007CA\u00188\u001b\u0005\u0001$BA\u00193\u0003\u0019\u0019w.\\7p]*\u0011ad\r\u0006\u0003iU\na!\u00199bG\",'\"\u0001\u001c\u0002\u0007=\u0014x-\u0003\u00029a\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u00047pO\u0016sGm\u00144gg\u0016$\bc\u0001\u0012<{%\u0011Ah\t\u0002\n\rVt7\r^5p]B\u0002\"A\t \n\u0005}\u001a#\u0001\u0002'p]\u001e\f!b\u00195fG.\u0004x.\u001b8u!\t\u0011U)D\u0001D\u0015\t!5$A\u0006dQ\u0016\u001c7\u000e]8j]R\u001c\u0018B\u0001$D\u0005UaU-\u00193fe\u0016\u0003xn\u00195DQ\u0016\u001c7\u000e]8j]R\fa\u0001P5oSRtD\u0003B%L\u00196\u0003\"A\u0013\u0001\u000e\u0003eAQ!\f\u0003A\u00029BQ!\u000f\u0003A\u0002iBQ\u0001\u0011\u0003A\u0002\u0005\u000bA\u0001\\8dWV\t\u0001\u000b\u0005\u0002R56\t!K\u0003\u0002T)\u0006)An\\2lg*\u0011QKV\u0001\u000bG>t7-\u001e:sK:$(BA,Y\u0003\u0011)H/\u001b7\u000b\u0003e\u000bAA[1wC&\u00111L\u0015\u0002\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW\u0006)An\\2lA\u00051Q\r]8dQN,\u0012a\u0018\t\u0004A\u0016<W\"A1\u000b\u0005\t\u001c\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003I\u000e\n!bY8mY\u0016\u001cG/[8o\u0013\t1\u0017M\u0001\u0006MSN$()\u001e4gKJ\u0004\"A\u00135\n\u0005%L\"AC#q_\u000eDWI\u001c;ss\u0006QQ\r]8dQN|F%Z9\u0015\u00051|\u0007C\u0001\u0012n\u0013\tq7E\u0001\u0003V]&$\bb\u00029\t\u0003\u0003\u0005\raX\u0001\u0004q\u0012\n\u0014aB3q_\u000eD7\u000fI\u0001\u0007CN\u001c\u0018n\u001a8\u0015\u00071$\b\u0010C\u0003\u001b\u0015\u0001\u0007Q\u000f\u0005\u0002#m&\u0011qo\t\u0002\u0004\u0013:$\b\"B=\u000b\u0001\u0004i\u0014aC:uCJ$xJ\u001a4tKR\f\u0011\u0003\u001e:v]\u000e\fG/Z!oI\u0006\u0003\b/\u001a8e)\taG\u0010C\u0003~\u0017\u0001\u0007q-A\u0007f]R\u0014\u0018\u0010V8BaB,g\u000eZ\u0001\t]>tW)\u001c9usV\u0011\u0011\u0011\u0001\t\u0004E\u0005\r\u0011bAA\u0003G\t9!i\\8mK\u0006t\u0017a\u00037bi\u0016\u001cH/\u00129pG\",\"!a\u0003\u0011\t\t\ni!^\u0005\u0004\u0003\u001f\u0019#AB(qi&|g.A\u0007fCJd\u0017.Z:u\u000b:$(/_\u000b\u0003\u0003+\u0001BAIA\u0007O\u0006aQM\u001c3PM\u001a\u001cX\r\u001e$peR!\u00111DA\u0011!\u0015\u0011\u0013QD;>\u0013\r\tyb\t\u0002\u0007)V\u0004H.\u001a\u001a\t\r\u0005\rr\u00021\u0001v\u00039\u0011X-];fgR,G-\u00129pG\"\fq\u0002\u001e:v]\u000e\fG/\u001a$s_6,e\u000e\u001a\u000b\u0004Y\u0006%\u0002BBA\u0016!\u0001\u0007Q(A\u0005f]\u0012|eMZ:fi\u0006\tBO];oG\u0006$XM\u0012:p[N#\u0018M\u001d;\u0015\u00071\f\t\u0004C\u0003z#\u0001\u0007Q(A\u0007dY\u0016\f'/\u00118e\r2,8\u000f\u001b\u000b\u0002Y\u0006)1\r\\3be\u0006aQ\r]8dQ\u0016sGO]5fg\u0006YA.\u0019;fgR,e\u000e\u001e:z\u0003\u00151G.^:i\u0003Q1\u0018\r\\5eCR,\u0017I\u001c3NCf\u0014WmV1s]R\u0019A.a\u0011\t\r\u0005\u0015s\u00031\u0001h\u0003\u0015)g\u000e\u001e:z\u0001")
public class LeaderEpochFileCache
implements Logging {
    private final Function0<Object> logEndOffset;
    private final LeaderEpochCheckpoint checkpoint;
    private final ReentrantReadWriteLock lock;
    private ListBuffer<EpochEntry> epochs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LeaderEpochFileCache leaderEpochFileCache = this;
        synchronized (leaderEpochFileCache) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private ListBuffer<EpochEntry> epochs() {
        return this.epochs;
    }

    private void epochs_$eq(ListBuffer<EpochEntry> x$1) {
        this.epochs = x$1;
    }

    public void assign(int epoch, long startOffset) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                EpochEntry lastEntry;
                boolean updateNeeded;
                boolean bl = this.epochs().isEmpty() ? true : (updateNeeded = (lastEntry = (EpochEntry)this.epochs().last()).epoch() != epoch || startOffset < lastEntry.startOffset());
                if (!updateNeeded) break block0;
                this.truncateAndAppend(new EpochEntry(epoch, startOffset));
                this.flush();
            }
        });
    }

    private void truncateAndAppend(EpochEntry entryToAppend) {
        block2: {
            ListBuffer removedEpochs;
            block1: {
                this.validateAndMaybeWarn(entryToAppend);
                Tuple2 tuple2 = this.epochs().partition((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateAndAppend$1(entryToAppend, entry)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ListBuffer retainedEpochs = (ListBuffer)tuple2._1();
                ListBuffer removedEpochs2 = (ListBuffer)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)retainedEpochs, (Object)removedEpochs2);
                Tuple2 tuple23 = tuple22;
                ListBuffer retainedEpochs2 = (ListBuffer)tuple23._1();
                removedEpochs = (ListBuffer)tuple23._2();
                this.epochs_$eq((ListBuffer<EpochEntry>)((ListBuffer)retainedEpochs2.$colon$plus((Object)entryToAppend, ListBuffer$.MODULE$.canBuildFrom())));
                if (!removedEpochs.isEmpty()) break block1;
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Appended new epoch entry ").append(entryToAppend).append(". Cache now contains ").append(this.epochs().size()).append(" entries.").toString());
                break block2;
            }
            if (removedEpochs.size() <= 1 && ((EpochEntry)removedEpochs.head()).startOffset() == entryToAppend.startOffset()) break block2;
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("New epoch entry ").append(entryToAppend).append(" caused truncation of conflicting entries ").append(removedEpochs).append(". ").append("Cache now contains ").append(this.epochs().size()).append(" entries.").toString());
        }
    }

    public boolean nonEmpty() {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inReadLock(this.lock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.epochs().nonEmpty()));
    }

    public Option<Object> latestEpoch() {
        return (Option)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.epochs().lastOption().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.epoch())));
    }

    public Option<EpochEntry> earliestEntry() {
        return (Option)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.epochs().headOption());
    }

    public Tuple2<Object, Object> endOffsetFor(int requestedEpoch) {
        return (Tuple2)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            void var3_9;
            Tuple2.mcIJ.sp sp2;
            if (requestedEpoch == -1) {
                sp2 = new Tuple2.mcIJ.sp(-1, -1L);
            } else if (this.latestEpoch().contains((Object)BoxesRunTime.boxToInteger((int)requestedEpoch))) {
                sp2 = new Tuple2.mcIJ.sp(requestedEpoch, $this.logEndOffset.apply$mcJ$sp());
            } else {
                Tuple2 tuple2 = this.epochs().partition((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$endOffsetFor$2(requestedEpoch, e)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ListBuffer subsequentEpochs = (ListBuffer)tuple2._1();
                ListBuffer previousEpochs = (ListBuffer)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)subsequentEpochs, (Object)previousEpochs);
                Tuple2 tuple23 = tuple22;
                ListBuffer subsequentEpochs2 = (ListBuffer)tuple23._1();
                ListBuffer previousEpochs2 = (ListBuffer)tuple23._2();
                sp2 = subsequentEpochs2.isEmpty() ? new Tuple2.mcIJ.sp(-1, -1L) : (previousEpochs2.isEmpty() ? new Tuple2.mcIJ.sp(requestedEpoch, ((EpochEntry)subsequentEpochs2.head()).startOffset()) : new Tuple2.mcIJ.sp(((EpochEntry)previousEpochs2.last()).epoch(), ((EpochEntry)subsequentEpochs2.head()).startOffset()));
            }
            Tuple2.mcIJ.sp epochAndOffset = sp2;
            this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> LeaderEpochFileCache.$anonfun$endOffsetFor$3(this, requestedEpoch, (Tuple2)epochAndOffset)));
            return var3_9;
        });
    }

    public void truncateFromEnd(long endOffset) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block1: {
                if (endOffset < 0L || !this.latestEntry().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromEnd$2(endOffset, x$4)))) break block1;
                Tuple2 tuple2 = this.epochs().partition((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromEnd$3(endOffset, x$5)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ListBuffer subsequentEntries = (ListBuffer)tuple2._1();
                ListBuffer previousEntries = (ListBuffer)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)subsequentEntries, (Object)previousEntries);
                Tuple2 tuple23 = tuple22;
                ListBuffer subsequentEntries2 = (ListBuffer)tuple23._1();
                ListBuffer previousEntries2 = (ListBuffer)tuple23._2();
                this.epochs_$eq((ListBuffer<EpochEntry>)previousEntries2);
                this.flush();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("Cleared entries ").append(subsequentEntries2).append(" from epoch cache after ").append("truncating to end offset ").append(endOffset).append(", leaving ").append(this.epochs().size()).append(" entries in the cache.").toString());
            }
        });
    }

    public void truncateFromStart(long startOffset) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block1: {
                if (!this.epochs().nonEmpty()) break block1;
                Tuple2 tuple2 = this.epochs().partition((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromStart$2(startOffset, x$7)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ListBuffer subsequentEntries = (ListBuffer)tuple2._1();
                ListBuffer previousEntries = (ListBuffer)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)subsequentEntries, (Object)previousEntries);
                Tuple2 tuple23 = tuple22;
                ListBuffer subsequentEntries2 = (ListBuffer)tuple23._1();
                ListBuffer previousEntries2 = (ListBuffer)tuple23._2();
                previousEntries2.lastOption().foreach((Function1 & Serializable & scala.Serializable)firstBeforeStartOffset -> {
                    LeaderEpochFileCache.$anonfun$truncateFromStart$3(this, startOffset, subsequentEntries2, previousEntries2, firstBeforeStartOffset);
                    return BoxedUnit.UNIT;
                });
            }
        });
    }

    public void clearAndFlush() {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.epochs().clear();
            this.flush();
        });
    }

    public void clear() {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.epochs().clear());
    }

    public ListBuffer<EpochEntry> epochEntries() {
        return this.epochs();
    }

    private Option<EpochEntry> latestEntry() {
        return this.epochs().lastOption();
    }

    private void flush() {
        this.checkpoint.write((Seq<EpochEntry>)this.epochs());
    }

    private void validateAndMaybeWarn(EpochEntry entry) {
        if (entry.epoch() < 0) {
            throw new IllegalArgumentException(new StringBuilder(46).append("Received invalid partition leader epoch entry ").append(entry).toString());
        }
        this.latestEntry().foreach((Function1 & Serializable & scala.Serializable)latest -> {
            LeaderEpochFileCache.$anonfun$validateAndMaybeWarn$1(this, entry, latest);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$truncateAndAppend$1(EpochEntry entryToAppend$1, EpochEntry entry) {
        return entry.epoch() < entryToAppend$1.epoch() && entry.startOffset() < entryToAppend$1.startOffset();
    }

    public static final /* synthetic */ boolean $anonfun$endOffsetFor$2(int requestedEpoch$1, EpochEntry e) {
        return e.epoch() > requestedEpoch$1;
    }

    public static final /* synthetic */ String $anonfun$endOffsetFor$3(LeaderEpochFileCache $this, int requestedEpoch$1, Tuple2 epochAndOffset$1) {
        return new StringBuilder(103).append("Processed end offset request for epoch ").append(requestedEpoch$1).append(" and returning epoch ").append(epochAndOffset$1._1$mcI$sp()).append(" ").append("with end offset ").append(epochAndOffset$1._2$mcJ$sp()).append(" from epoch cache of size ").append($this.epochs().size()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromEnd$2(long endOffset$1, EpochEntry x$4) {
        return x$4.startOffset() >= endOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromEnd$3(long endOffset$1, EpochEntry x$5) {
        return x$5.startOffset() >= endOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromStart$2(long startOffset$2, EpochEntry x$7) {
        return x$7.startOffset() > startOffset$2;
    }

    public static final /* synthetic */ void $anonfun$truncateFromStart$3(LeaderEpochFileCache $this, long startOffset$2, ListBuffer subsequentEntries$2, ListBuffer previousEntries$1, EpochEntry firstBeforeStartOffset) {
        EpochEntry updatedFirstEntry;
        EpochEntry epochEntry = updatedFirstEntry = new EpochEntry(firstBeforeStartOffset.epoch(), startOffset$2);
        $this.epochs_$eq((ListBuffer<EpochEntry>)((ListBuffer)subsequentEntries$2.$plus$colon((Object)epochEntry, ListBuffer$.MODULE$.canBuildFrom())));
        $this.flush();
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Cleared entries ").append(previousEntries$1).append(" and rewrote first entry ").append(updatedFirstEntry).append(" after ").append("truncating to start offset ").append(startOffset$2).append(", leaving ").append($this.epochs().size()).append(" in the cache.").toString());
    }

    public static final /* synthetic */ void $anonfun$validateAndMaybeWarn$1(LeaderEpochFileCache $this, EpochEntry entry$1, EpochEntry latest) {
        block1: {
            block0: {
                if (entry$1.epoch() >= latest.epoch()) break block0;
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(143).append("Received leader epoch assignment ").append(entry$1).append(" which has an epoch less than the epoch ").append("of the latest entry ").append(latest).append(". This implies messages have arrived out of order.").toString());
                break block1;
            }
            if (entry$1.startOffset() >= latest.startOffset()) break block1;
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(171).append("Received leader epoch assignment ").append(entry$1).append(" which has a starting offset which is less than ").append("the starting offset of the latest entry ").append(latest).append(". This implies messages have arrived out of order.").toString());
        }
    }

    public LeaderEpochFileCache(TopicPartition topicPartition, Function0<Object> logEndOffset, LeaderEpochCheckpoint checkpoint) {
        this.logEndOffset = logEndOffset;
        this.checkpoint = checkpoint;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(20).append("[LeaderEpochCache ").append(topicPartition).append("] ").toString());
        this.lock = new ReentrantReadWriteLock();
        this.epochs = (ListBuffer)CoreUtils$.MODULE$.inWriteLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply($this.checkpoint.read()));
    }
}

