/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;

public class HoodieRollbackStat
implements Serializable {
    private final String partitionPath;
    private final List<String> successDeleteFiles;
    private final List<String> failedDeleteFiles;
    private final Map<FileStatus, Long> commandBlocksCount;

    public HoodieRollbackStat(String partitionPath, List<String> successDeleteFiles, List<String> failedDeleteFiles, Map<FileStatus, Long> commandBlocksCount) {
        this.partitionPath = partitionPath;
        this.successDeleteFiles = successDeleteFiles;
        this.failedDeleteFiles = failedDeleteFiles;
        this.commandBlocksCount = commandBlocksCount;
    }

    public Map<FileStatus, Long> getCommandBlocksCount() {
        return this.commandBlocksCount;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public List<String> getSuccessDeleteFiles() {
        return this.successDeleteFiles;
    }

    public List<String> getFailedDeleteFiles() {
        return this.failedDeleteFiles;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> successDeleteFiles;
        private List<String> failedDeleteFiles;
        private Map<FileStatus, Long> commandBlocksCount;
        private String partitionPath;

        public Builder withDeletedFileResults(Map<FileStatus, Boolean> deletedFiles) {
            this.successDeleteFiles = deletedFiles.entrySet().stream().filter(s -> (Boolean)s.getValue()).map(s -> ((FileStatus)s.getKey()).getPath().toString()).collect(Collectors.toList());
            this.failedDeleteFiles = deletedFiles.entrySet().stream().filter(s -> (Boolean)s.getValue() == false).map(s -> ((FileStatus)s.getKey()).getPath().toString()).collect(Collectors.toList());
            return this;
        }

        public Builder withRollbackBlockAppendResults(Map<FileStatus, Long> commandBlocksCount) {
            this.commandBlocksCount = commandBlocksCount;
            return this;
        }

        public Builder withPartitionPath(String partitionPath) {
            this.partitionPath = partitionPath;
            return this;
        }

        public HoodieRollbackStat build() {
            return new HoodieRollbackStat(this.partitionPath, this.successDeleteFiles, this.failedDeleteFiles, this.commandBlocksCount);
        }
    }
}

