/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.util.FSUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HoodieCommitMetadata
implements Serializable {
    public static final String SCHEMA_KEY = "schema";
    private static final Logger LOG = LogManager.getLogger(HoodieCommitMetadata.class);
    protected Map<String, List<HoodieWriteStat>> partitionToWriteStats;
    protected Boolean compacted;
    private Map<String, String> extraMetadataMap = new HashMap<String, String>();

    public HoodieCommitMetadata() {
        this(false);
    }

    public HoodieCommitMetadata(boolean compacted) {
        this.partitionToWriteStats = new HashMap<String, List<HoodieWriteStat>>();
        this.compacted = compacted;
    }

    public void addWriteStat(String partitionPath, HoodieWriteStat stat) {
        if (!this.partitionToWriteStats.containsKey(partitionPath)) {
            this.partitionToWriteStats.put(partitionPath, new ArrayList());
        }
        this.partitionToWriteStats.get(partitionPath).add(stat);
    }

    public void addMetadata(String metaKey, String value) {
        this.extraMetadataMap.put(metaKey, value);
    }

    public List<HoodieWriteStat> getWriteStats(String partitionPath) {
        return this.partitionToWriteStats.get(partitionPath);
    }

    public Map<String, String> getExtraMetadata() {
        return this.extraMetadataMap;
    }

    public Map<String, List<HoodieWriteStat>> getPartitionToWriteStats() {
        return this.partitionToWriteStats;
    }

    public String getMetadata(String metaKey) {
        return this.extraMetadataMap.get(metaKey);
    }

    public Boolean getCompacted() {
        return this.compacted;
    }

    public void setCompacted(Boolean compacted) {
        this.compacted = compacted;
    }

    public HashMap<String, String> getFileIdAndRelativePaths() {
        HashMap<String, String> filePaths = new HashMap<String, String>();
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.getPartitionToWriteStats().entrySet()) {
            for (HoodieWriteStat stat : entry.getValue()) {
                filePaths.put(stat.getFileId(), stat.getPath());
            }
        }
        return filePaths;
    }

    public HashMap<String, String> getFileIdAndFullPaths(String basePath) {
        HashMap<String, String> fullPaths = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getFileIdAndRelativePaths().entrySet()) {
            String fullPath = entry.getValue() != null ? FSUtils.getPartitionPath(basePath, entry.getValue()).toString() : null;
            fullPaths.put(entry.getKey(), fullPath);
        }
        return fullPaths;
    }

    public String toJsonString() throws IOException {
        if (this.partitionToWriteStats.containsKey(null)) {
            LOG.info((Object)("partition path is null for " + this.partitionToWriteStats.get(null)));
            this.partitionToWriteStats.remove(null);
        }
        return HoodieCommitMetadata.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
    }

    public static <T> T fromJsonString(String jsonStr, Class<T> clazz) throws Exception {
        if (jsonStr == null || jsonStr.isEmpty()) {
            return clazz.newInstance();
        }
        return (T)HoodieCommitMetadata.getObjectMapper().readValue(jsonStr, clazz);
    }

    public long fetchTotalPartitionsWritten() {
        return this.partitionToWriteStats.size();
    }

    public long fetchTotalFilesInsert() {
        long totalFilesInsert = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                if (stat.getPrevCommit() == null || !stat.getPrevCommit().equalsIgnoreCase("null")) continue;
                ++totalFilesInsert;
            }
        }
        return totalFilesInsert;
    }

    public long fetchTotalFilesUpdated() {
        long totalFilesUpdated = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                if (stat.getPrevCommit() == null || stat.getPrevCommit().equalsIgnoreCase("null")) continue;
                ++totalFilesUpdated;
            }
        }
        return totalFilesUpdated;
    }

    public long fetchTotalUpdateRecordsWritten() {
        long totalUpdateRecordsWritten = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                totalUpdateRecordsWritten += stat.getNumUpdateWrites();
            }
        }
        return totalUpdateRecordsWritten;
    }

    public long fetchTotalInsertRecordsWritten() {
        long totalInsertRecordsWritten = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                if (stat.getPrevCommit() == null) continue;
                totalInsertRecordsWritten += stat.getNumInserts();
            }
        }
        return totalInsertRecordsWritten;
    }

    public long fetchTotalRecordsWritten() {
        long totalRecordsWritten = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                totalRecordsWritten += stat.getNumWrites();
            }
        }
        return totalRecordsWritten;
    }

    public long fetchTotalBytesWritten() {
        long totalBytesWritten = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                totalBytesWritten += stat.getTotalWriteBytes();
            }
        }
        return totalBytesWritten;
    }

    public long fetchTotalWriteErrors() {
        long totalWriteErrors = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                totalWriteErrors += stat.getTotalWriteErrors();
            }
        }
        return totalWriteErrors;
    }

    public long getTotalRecordsDeleted() {
        long totalDeletes = 0L;
        for (List<HoodieWriteStat> stats : this.partitionToWriteStats.values()) {
            for (HoodieWriteStat stat : stats) {
                totalDeletes += stat.getNumDeletes();
            }
        }
        return totalDeletes;
    }

    public Long getTotalLogRecordsCompacted() {
        Long totalLogRecords = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                totalLogRecords = totalLogRecords + writeStat.getTotalLogRecords();
            }
        }
        return totalLogRecords;
    }

    public Long getTotalLogFilesCompacted() {
        Long totalLogFiles = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                totalLogFiles = totalLogFiles + writeStat.getTotalLogFilesCompacted();
            }
        }
        return totalLogFiles;
    }

    public Long getTotalCompactedRecordsUpdated() {
        Long totalUpdateRecords = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                totalUpdateRecords = totalUpdateRecords + writeStat.getTotalUpdatedRecordsCompacted();
            }
        }
        return totalUpdateRecords;
    }

    public Long getTotalLogFilesSize() {
        Long totalLogFilesSize = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                totalLogFilesSize = totalLogFilesSize + writeStat.getTotalLogSizeCompacted();
            }
        }
        return totalLogFilesSize;
    }

    public Long getTotalScanTime() {
        Long totalScanTime = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                if (writeStat.getRuntimeStats() == null) continue;
                totalScanTime = totalScanTime + writeStat.getRuntimeStats().getTotalScanTime();
            }
        }
        return totalScanTime;
    }

    public Long getTotalCreateTime() {
        Long totalCreateTime = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                if (writeStat.getRuntimeStats() == null) continue;
                totalCreateTime = totalCreateTime + writeStat.getRuntimeStats().getTotalCreateTime();
            }
        }
        return totalCreateTime;
    }

    public Long getTotalUpsertTime() {
        Long totalUpsertTime = 0L;
        for (Map.Entry<String, List<HoodieWriteStat>> entry : this.partitionToWriteStats.entrySet()) {
            for (HoodieWriteStat writeStat : entry.getValue()) {
                if (writeStat.getRuntimeStats() == null) continue;
                totalUpsertTime = totalUpsertTime + writeStat.getRuntimeStats().getTotalUpsertTime();
            }
        }
        return totalUpsertTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieCommitMetadata that = (HoodieCommitMetadata)o;
        if (!this.partitionToWriteStats.equals(that.partitionToWriteStats)) {
            return false;
        }
        return this.compacted.equals(that.compacted);
    }

    public int hashCode() {
        int result = this.partitionToWriteStats.hashCode();
        result = 31 * result + this.compacted.hashCode();
        return result;
    }

    public static <T> T fromBytes(byte[] bytes, Class<T> clazz) throws IOException {
        try {
            return HoodieCommitMetadata.fromJsonString(new String(bytes, StandardCharsets.UTF_8), clazz);
        }
        catch (Exception e) {
            throw new IOException("unable to read commit metadata", e);
        }
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        return mapper;
    }

    public String toString() {
        return "HoodieCommitMetadata{partitionToWriteStats=" + this.partitionToWriteStats + ", compacted=" + this.compacted + ", extraMetadataMap=" + this.extraMetadataMap + '}';
    }
}

