/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.Path;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HoodieWriteStat
implements Serializable {
    public static final String NULL_COMMIT = "null";
    private String fileId;
    private String path;
    private String prevCommit;
    private long numWrites;
    private long numDeletes;
    private long numUpdateWrites;
    private long numInserts;
    private long totalWriteBytes;
    private long totalWriteErrors;
    @Nullable
    private String tempPath;
    @Nullable
    private String partitionPath;
    @Nullable
    private long totalLogRecords;
    @Nullable
    private long totalLogFilesCompacted;
    @Nullable
    private long totalLogSizeCompacted;
    @Nullable
    private long totalUpdatedRecordsCompacted;
    @Nullable
    private long totalLogBlocks;
    @Nullable
    private long totalCorruptLogBlock;
    private long totalRollbackBlocks;
    private long fileSizeInBytes;
    @Nullable
    @JsonIgnore
    private RuntimeStats runtimeStats;

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setPrevCommit(String prevCommit) {
        this.prevCommit = prevCommit;
    }

    public void setNumWrites(long numWrites) {
        this.numWrites = numWrites;
    }

    public void setNumDeletes(long numDeletes) {
        this.numDeletes = numDeletes;
    }

    public void setNumUpdateWrites(long numUpdateWrites) {
        this.numUpdateWrites = numUpdateWrites;
    }

    public void setNumInserts(long numInserts) {
        this.numInserts = numInserts;
    }

    public long getTotalWriteBytes() {
        return this.totalWriteBytes;
    }

    public void setTotalWriteBytes(long totalWriteBytes) {
        this.totalWriteBytes = totalWriteBytes;
    }

    public long getTotalWriteErrors() {
        return this.totalWriteErrors;
    }

    public void setTotalWriteErrors(long totalWriteErrors) {
        this.totalWriteErrors = totalWriteErrors;
    }

    public String getPrevCommit() {
        return this.prevCommit;
    }

    public long getNumWrites() {
        return this.numWrites;
    }

    public long getNumDeletes() {
        return this.numDeletes;
    }

    public long getNumUpdateWrites() {
        return this.numUpdateWrites;
    }

    public long getNumInserts() {
        return this.numInserts;
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getPath() {
        return this.path;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public void setPartitionPath(String partitionPath) {
        this.partitionPath = partitionPath;
    }

    public long getTotalLogRecords() {
        return this.totalLogRecords;
    }

    public void setTotalLogRecords(long totalLogRecords) {
        this.totalLogRecords = totalLogRecords;
    }

    public long getTotalLogFilesCompacted() {
        return this.totalLogFilesCompacted;
    }

    public void setTotalLogFilesCompacted(long totalLogFilesCompacted) {
        this.totalLogFilesCompacted = totalLogFilesCompacted;
    }

    public long getTotalUpdatedRecordsCompacted() {
        return this.totalUpdatedRecordsCompacted;
    }

    public void setTotalUpdatedRecordsCompacted(long totalUpdatedRecordsCompacted) {
        this.totalUpdatedRecordsCompacted = totalUpdatedRecordsCompacted;
    }

    public void setTempPath(String tempPath) {
        this.tempPath = tempPath;
    }

    public String getTempPath() {
        return this.tempPath;
    }

    public long getTotalLogSizeCompacted() {
        return this.totalLogSizeCompacted;
    }

    public void setTotalLogSizeCompacted(long totalLogSizeCompacted) {
        this.totalLogSizeCompacted = totalLogSizeCompacted;
    }

    public long getTotalLogBlocks() {
        return this.totalLogBlocks;
    }

    public void setTotalLogBlocks(long totalLogBlocks) {
        this.totalLogBlocks = totalLogBlocks;
    }

    public long getTotalCorruptLogBlock() {
        return this.totalCorruptLogBlock;
    }

    public void setTotalCorruptLogBlock(long totalCorruptLogBlock) {
        this.totalCorruptLogBlock = totalCorruptLogBlock;
    }

    public long getTotalRollbackBlocks() {
        return this.totalRollbackBlocks;
    }

    public void setTotalRollbackBlocks(Long totalRollbackBlocks) {
        this.totalRollbackBlocks = totalRollbackBlocks;
    }

    public long getFileSizeInBytes() {
        return this.fileSizeInBytes;
    }

    public void setFileSizeInBytes(long fileSizeInBytes) {
        this.fileSizeInBytes = fileSizeInBytes;
    }

    @Nullable
    public RuntimeStats getRuntimeStats() {
        return this.runtimeStats;
    }

    public void setRuntimeStats(@Nullable RuntimeStats runtimeStats) {
        this.runtimeStats = runtimeStats;
    }

    public void setPath(Path basePath, Path path) {
        this.path = path.toString().replace(basePath + "/", "");
    }

    public String toString() {
        return "HoodieWriteStat{fileId='" + this.fileId + '\'' + ", path='" + this.path + '\'' + ", prevCommit='" + this.prevCommit + '\'' + ", numWrites=" + this.numWrites + ", numDeletes=" + this.numDeletes + ", numUpdateWrites=" + this.numUpdateWrites + ", totalWriteBytes=" + this.totalWriteBytes + ", totalWriteErrors=" + this.totalWriteErrors + ", tempPath='" + this.tempPath + '\'' + ", partitionPath='" + this.partitionPath + '\'' + ", totalLogRecords=" + this.totalLogRecords + ", totalLogFilesCompacted=" + this.totalLogFilesCompacted + ", totalLogSizeCompacted=" + this.totalLogSizeCompacted + ", totalUpdatedRecordsCompacted=" + this.totalUpdatedRecordsCompacted + ", totalLogBlocks=" + this.totalLogBlocks + ", totalCorruptLogBlock=" + this.totalCorruptLogBlock + ", totalRollbackBlocks=" + this.totalRollbackBlocks + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieWriteStat that = (HoodieWriteStat)o;
        if (!this.path.equals(that.path)) {
            return false;
        }
        return this.prevCommit.equals(that.prevCommit);
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + this.prevCommit.hashCode();
        return result;
    }

    public static class RuntimeStats
    implements Serializable {
        @Nullable
        private long totalScanTime;
        @Nullable
        private long totalUpsertTime;
        @Nullable
        private long totalCreateTime;

        @Nullable
        public long getTotalScanTime() {
            return this.totalScanTime;
        }

        public void setTotalScanTime(@Nullable long totalScanTime) {
            this.totalScanTime = totalScanTime;
        }

        @Nullable
        public long getTotalUpsertTime() {
            return this.totalUpsertTime;
        }

        public void setTotalUpsertTime(@Nullable long totalUpsertTime) {
            this.totalUpsertTime = totalUpsertTime;
        }

        @Nullable
        public long getTotalCreateTime() {
            return this.totalCreateTime;
        }

        public void setTotalCreateTime(@Nullable long totalCreateTime) {
            this.totalCreateTime = totalCreateTime;
        }
    }
}

