/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieArchivedTimeline
extends HoodieDefaultTimeline {
    private static final String HOODIE_COMMIT_ARCHIVE_LOG_FILE = "commits";
    private HoodieTableMetaClient metaClient;
    private Map<String, byte[]> readCommits = new HashMap<String, byte[]>();
    private static final Logger LOG = LogManager.getLogger(HoodieArchivedTimeline.class);

    public HoodieArchivedTimeline(HoodieTableMetaClient metaClient) {
        Path archiveLogPath = HoodieArchivedTimeline.getArchiveLogPath(metaClient.getArchivePath());
        try (SequenceFile.Reader reader = new SequenceFile.Reader(metaClient.getHadoopConf(), new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)archiveLogPath)});){
            Text key = new Text();
            Text val = new Text();
            while (reader.next((Writable)key, (Writable)val)) {
                this.readCommits.put(key.toString(), Arrays.copyOf(val.getBytes(), val.getLength()));
            }
            this.setInstants(this.readCommits.keySet().stream().map(s -> new HoodieInstant(false, "commit", (String)s)).collect(Collectors.toList()));
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not load archived commit timeline from path " + archiveLogPath, e);
        }
        this.details = this::getInstantDetails;
        this.metaClient = metaClient;
    }

    public HoodieArchivedTimeline() {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public static Path getArchiveLogPath(String archiveFolder) {
        return new Path(archiveFolder, HOODIE_COMMIT_ARCHIVE_LOG_FILE);
    }

    @Override
    public Option<byte[]> getInstantDetails(HoodieInstant instant) {
        return Option.ofNullable(this.readCommits.get(instant.getTimestamp()));
    }

    public HoodieArchivedTimeline reload() {
        return new HoodieArchivedTimeline(this.metaClient);
    }
}

