/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.table.timeline.dto.FileStatusDTO;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaseFileDTO {
    @JsonProperty(value="fileStatus")
    private FileStatusDTO fileStatus;
    @JsonProperty(value="fullPath")
    private String fullPath;
    @JsonProperty(value="fileLen")
    private long fileLen;

    public static HoodieBaseFile toHoodieBaseFile(BaseFileDTO dto) {
        HoodieBaseFile baseFile;
        if (null == dto) {
            return null;
        }
        if (null != dto.fileStatus) {
            baseFile = new HoodieBaseFile(FileStatusDTO.toFileStatus(dto.fileStatus));
        } else {
            baseFile = new HoodieBaseFile(dto.fullPath);
            baseFile.setFileLen(dto.fileLen);
        }
        return baseFile;
    }

    public static BaseFileDTO fromHoodieBaseFile(HoodieBaseFile dataFile) {
        if (null == dataFile) {
            return null;
        }
        BaseFileDTO dto = new BaseFileDTO();
        dto.fileStatus = FileStatusDTO.fromFileStatus(dataFile.getFileStatus());
        dto.fullPath = dataFile.getPath();
        dto.fileLen = dataFile.getFileLen();
        return dto;
    }
}

