/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.IncrementalTimelineSyncFileSystemView;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.RocksDBDAO;
import org.apache.hudi.common.util.RocksDBSchemaHelper;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class RocksDbBasedFileSystemView
extends IncrementalTimelineSyncFileSystemView {
    private static final Logger LOG = LogManager.getLogger(RocksDbBasedFileSystemView.class);
    private final FileSystemViewStorageConfig config;
    private final RocksDBSchemaHelper schemaHelper;
    private RocksDBDAO rocksDB;
    private boolean closed = false;

    public RocksDbBasedFileSystemView(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline, FileSystemViewStorageConfig config) {
        super(config.isIncrementalTimelineSyncEnabled());
        this.config = config;
        this.schemaHelper = new RocksDBSchemaHelper(metaClient);
        this.rocksDB = new RocksDBDAO(metaClient.getBasePath(), config.getRocksdbBasePath());
        this.init(metaClient, visibleActiveTimeline);
    }

    public RocksDbBasedFileSystemView(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline, FileStatus[] fileStatuses, FileSystemViewStorageConfig config) {
        this(metaClient, visibleActiveTimeline, config);
        this.addFilesToView(fileStatuses);
    }

    @Override
    protected void init(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline) {
        this.schemaHelper.getAllColumnFamilies().stream().forEach(this.rocksDB::addColumnFamily);
        super.init(metaClient, visibleActiveTimeline);
        LOG.info((Object)("Created ROCKSDB based file-system view at " + this.config.getRocksdbBasePath()));
    }

    @Override
    protected boolean isPendingCompactionScheduledForFileId(HoodieFileGroupId fgId) {
        return this.getPendingCompactionOperationWithInstant(fgId).isPresent();
    }

    @Override
    protected void resetPendingCompactionOperations(Stream<Pair<String, CompactionOperation>> operations) {
        this.rocksDB.writeBatch(batch -> {
            operations.forEach(opPair -> this.rocksDB.putInBatch(batch, this.schemaHelper.getColFamilyForPendingCompaction(), this.schemaHelper.getKeyForPendingCompactionLookup(((CompactionOperation)opPair.getValue()).getFileGroupId()), opPair));
            LOG.info((Object)("Initializing pending compaction operations. Count=" + batch.count()));
        });
    }

    @Override
    protected void addPendingCompactionOperations(Stream<Pair<String, CompactionOperation>> operations) {
        this.rocksDB.writeBatch(batch -> operations.forEach(opInstantPair -> {
            Preconditions.checkArgument((!this.isPendingCompactionScheduledForFileId(((CompactionOperation)opInstantPair.getValue()).getFileGroupId()) ? 1 : 0) != 0, (Object)("Duplicate FileGroupId found in pending compaction operations. FgId :" + ((CompactionOperation)opInstantPair.getValue()).getFileGroupId()));
            this.rocksDB.putInBatch(batch, this.schemaHelper.getColFamilyForPendingCompaction(), this.schemaHelper.getKeyForPendingCompactionLookup(((CompactionOperation)opInstantPair.getValue()).getFileGroupId()), opInstantPair);
        }));
    }

    @Override
    void removePendingCompactionOperations(Stream<Pair<String, CompactionOperation>> operations) {
        this.rocksDB.writeBatch(batch -> operations.forEach(opInstantPair -> {
            Preconditions.checkArgument((this.getPendingCompactionOperationWithInstant(((CompactionOperation)opInstantPair.getValue()).getFileGroupId()) != null ? 1 : 0) != 0, (Object)("Trying to remove a FileGroupId which is not found in pending compaction operations. FgId :" + ((CompactionOperation)opInstantPair.getValue()).getFileGroupId()));
            this.rocksDB.deleteInBatch(batch, this.schemaHelper.getColFamilyForPendingCompaction(), this.schemaHelper.getKeyForPendingCompactionLookup(((CompactionOperation)opInstantPair.getValue()).getFileGroupId()));
        }));
    }

    @Override
    protected void resetViewState() {
        LOG.info((Object)"Deleting all rocksdb data associated with table filesystem view");
        this.rocksDB.close();
        this.rocksDB = new RocksDBDAO(this.metaClient.getBasePath(), this.config.getRocksdbBasePath());
    }

    @Override
    protected Option<Pair<String, CompactionOperation>> getPendingCompactionOperationWithInstant(HoodieFileGroupId fgId) {
        String lookupKey = this.schemaHelper.getKeyForPendingCompactionLookup(fgId);
        Pair instantOperationPair = (Pair)this.rocksDB.get(this.schemaHelper.getColFamilyForPendingCompaction(), lookupKey);
        return Option.ofNullable(instantOperationPair);
    }

    @Override
    protected boolean isPartitionAvailableInStore(String partitionPath) {
        String lookupKey = this.schemaHelper.getKeyForPartitionLookup(partitionPath);
        Object obj = this.rocksDB.get(this.schemaHelper.getColFamilyForStoredPartitions(), lookupKey);
        return obj != null;
    }

    @Override
    protected void storePartitionView(String partitionPath, List<HoodieFileGroup> fileGroups) {
        LOG.info((Object)("Resetting and adding new partition (" + partitionPath + ") to ROCKSDB based file-system view at " + this.config.getRocksdbBasePath() + ", Total file-groups=" + fileGroups.size()));
        String lookupKey = this.schemaHelper.getKeyForPartitionLookup(partitionPath);
        this.rocksDB.delete(this.schemaHelper.getColFamilyForStoredPartitions(), lookupKey);
        this.rocksDB.prefixDelete(this.schemaHelper.getColFamilyForView(), this.schemaHelper.getPrefixForSliceViewByPartition(partitionPath));
        this.rocksDB.prefixDelete(this.schemaHelper.getColFamilyForView(), this.schemaHelper.getPrefixForDataFileViewByPartition(partitionPath));
        fileGroups.stream().forEach(fg -> this.rocksDB.writeBatch(batch -> fg.getAllFileSlicesIncludingInflight().forEach(fs -> {
            this.rocksDB.putInBatch(batch, this.schemaHelper.getColFamilyForView(), this.schemaHelper.getKeyForSliceView((HoodieFileGroup)fg, (FileSlice)fs), fs);
            fs.getBaseFile().ifPresent(df -> this.rocksDB.putInBatch(batch, this.schemaHelper.getColFamilyForView(), this.schemaHelper.getKeyForDataFileView((HoodieFileGroup)fg, (FileSlice)fs), df));
        })));
        this.rocksDB.put(this.schemaHelper.getColFamilyForStoredPartitions(), lookupKey, Boolean.TRUE);
        LOG.info((Object)("Finished adding new partition (" + partitionPath + ") to ROCKSDB based file-system view at " + this.config.getRocksdbBasePath() + ", Total file-groups=" + fileGroups.size()));
    }

    @Override
    protected void applyDeltaFileSlicesToPartitionView(String partition, List<HoodieFileGroup> deltaFileGroups, IncrementalTimelineSyncFileSystemView.DeltaApplyMode mode) {
        this.rocksDB.writeBatch(batch -> deltaFileGroups.stream().forEach(fg -> fg.getAllRawFileSlices().map(fs -> {
            FileSlice oldSlice = this.getFileSlice(partition, fs.getFileId(), fs.getBaseInstantTime());
            if (null == oldSlice) {
                return fs;
            }
            LOG.info((Object)("Removing old Slice in DB. FS=" + oldSlice));
            this.rocksDB.deleteInBatch(batch, this.schemaHelper.getColFamilyForView(), this.schemaHelper.getKeyForSliceView((HoodieFileGroup)fg, oldSlice));
            this.rocksDB.deleteInBatch(batch, this.schemaHelper.getColFamilyForView(), this.schemaHelper.getKeyForDataFileView((HoodieFileGroup)fg, oldSlice));
            Map<String, HoodieLogFile> logFiles = oldSlice.getLogFiles().map(lf -> Pair.of(Path.getPathWithoutSchemeAndAuthority((Path)lf.getPath()).toString(), lf)).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
            Map<String, HoodieLogFile> deltaLogFiles = fs.getLogFiles().map(lf -> Pair.of(Path.getPathWithoutSchemeAndAuthority((Path)lf.getPath()).toString(), lf)).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
            switch (mode) {
                case ADD: {
                    FileSlice newFileSlice = new FileSlice(oldSlice.getFileGroupId(), oldSlice.getBaseInstantTime());
                    oldSlice.getBaseFile().ifPresent(df -> newFileSlice.setBaseFile((HoodieBaseFile)df));
                    fs.getBaseFile().ifPresent(df -> newFileSlice.setBaseFile((HoodieBaseFile)df));
                    HashMap<String, HoodieLogFile> newLogFiles = new HashMap<String, HoodieLogFile>(logFiles);
                    deltaLogFiles.entrySet().stream().filter(e -> !logFiles.containsKey(e.getKey())).forEach(p -> {
                        HoodieLogFile cfr_ignored_0 = (HoodieLogFile)newLogFiles.put((String)p.getKey(), (HoodieLogFile)p.getValue());
                    });
                    newLogFiles.values().stream().forEach(lf -> newFileSlice.addLogFile((HoodieLogFile)lf));
                    LOG.info((Object)("Adding back new File Slice after add FS=" + newFileSlice));
                    return newFileSlice;
                }
                case REMOVE: {
                    LOG.info((Object)("Removing old File Slice =" + fs));
                    FileSlice newFileSlice = new FileSlice(oldSlice.getFileGroupId(), oldSlice.getBaseInstantTime());
                    fs.getBaseFile().orElseGet(() -> {
                        oldSlice.getBaseFile().ifPresent(df -> newFileSlice.setBaseFile((HoodieBaseFile)df));
                        return null;
                    });
                    deltaLogFiles.keySet().stream().forEach(p -> {
                        HoodieLogFile cfr_ignored_0 = (HoodieLogFile)logFiles.remove(p);
                    });
                    logFiles.values().stream().forEach(lf -> newFileSlice.addLogFile((HoodieLogFile)lf));
                    if (newFileSlice.getBaseFile().isPresent() || newFileSlice.getLogFiles().count() > 0L) {
                        LOG.info((Object)("Adding back new file-slice after remove FS=" + newFileSlice));
                        return newFileSlice;
                    }
                    return null;
                }
            }
            throw new IllegalStateException("Unknown diff apply mode=" + (Object)((Object)mode));
        }).filter(Objects::nonNull).forEach(fs -> {
            this.rocksDB.putInBatch(batch, this.schemaHelper.getColFamilyForView(), this.schemaHelper.getKeyForSliceView((HoodieFileGroup)fg, (FileSlice)fs), fs);
            fs.getBaseFile().ifPresent(df -> this.rocksDB.putInBatch(batch, this.schemaHelper.getColFamilyForView(), this.schemaHelper.getKeyForDataFileView((HoodieFileGroup)fg, (FileSlice)fs), df));
        })));
    }

    @Override
    Stream<Pair<String, CompactionOperation>> fetchPendingCompactionOperations() {
        return this.rocksDB.prefixSearch(this.schemaHelper.getColFamilyForPendingCompaction(), "").map(Pair::getValue);
    }

    @Override
    Stream<HoodieBaseFile> fetchAllBaseFiles(String partitionPath) {
        return this.rocksDB.prefixSearch(this.schemaHelper.getColFamilyForView(), this.schemaHelper.getPrefixForDataFileViewByPartition(partitionPath)).map(Pair::getValue);
    }

    @Override
    Stream<HoodieFileGroup> fetchAllStoredFileGroups(String partitionPath) {
        return this.getFileGroups(this.rocksDB.prefixSearch(this.schemaHelper.getColFamilyForView(), this.schemaHelper.getPrefixForSliceViewByPartition(partitionPath)).map(Pair::getValue));
    }

    @Override
    Stream<HoodieFileGroup> fetchAllStoredFileGroups() {
        return this.getFileGroups(this.rocksDB.prefixSearch(this.schemaHelper.getColFamilyForView(), this.schemaHelper.getPrefixForSliceView()).map(Pair::getValue));
    }

    @Override
    protected Option<FileSlice> fetchLatestFileSlice(String partitionPath, String fileId) {
        return Option.ofNullable(this.rocksDB.prefixSearch(this.schemaHelper.getColFamilyForView(), this.schemaHelper.getPrefixForSliceViewByPartitionFile(partitionPath, fileId)).map(Pair::getValue).reduce(null, (x, y) -> x == null ? y : (y == null ? null : (HoodieTimeline.compareTimestamps(x.getBaseInstantTime(), y.getBaseInstantTime(), HoodieTimeline.GREATER) ? x : y))));
    }

    @Override
    protected Option<HoodieBaseFile> fetchLatestBaseFile(String partitionPath, String fileId) {
        return Option.ofNullable(this.rocksDB.prefixSearch(this.schemaHelper.getColFamilyForView(), this.schemaHelper.getPrefixForDataFileViewByPartitionFile(partitionPath, fileId)).map(Pair::getValue).reduce(null, (x, y) -> x == null ? y : (y == null ? null : (HoodieTimeline.compareTimestamps(x.getCommitTime(), y.getCommitTime(), HoodieTimeline.GREATER) ? x : y))));
    }

    @Override
    Option<HoodieFileGroup> fetchHoodieFileGroup(String partitionPath, String fileId) {
        return Option.fromJavaOptional(this.getFileGroups(this.rocksDB.prefixSearch(this.schemaHelper.getColFamilyForView(), this.schemaHelper.getPrefixForSliceViewByPartitionFile(partitionPath, fileId)).map(Pair::getValue)).findFirst());
    }

    private Stream<HoodieFileGroup> getFileGroups(Stream<FileSlice> sliceStream) {
        return sliceStream.map(s -> Pair.of(Pair.of(s.getPartitionPath(), s.getFileId()), s)).collect(Collectors.groupingBy(Pair::getKey)).entrySet().stream().map(slicePair -> {
            HoodieFileGroup fg = new HoodieFileGroup((String)((Pair)slicePair.getKey()).getKey(), (String)((Pair)slicePair.getKey()).getValue(), this.getVisibleCommitsAndCompactionTimeline());
            ((List)slicePair.getValue()).forEach(e -> fg.addFileSlice((FileSlice)e.getValue()));
            return fg;
        });
    }

    private FileSlice getFileSlice(String partitionPath, String fileId, String instantTime) {
        String key = this.schemaHelper.getKeyForSliceView(partitionPath, fileId, instantTime);
        return (FileSlice)this.rocksDB.get(this.schemaHelper.getColFamilyForView(), key);
    }

    @Override
    public void close() {
        LOG.info((Object)"Closing Rocksdb !!");
        this.closed = true;
        this.rocksDB.close();
        LOG.info((Object)"Closed Rocksdb !!");
    }

    @Override
    boolean isClosed() {
        return this.closed;
    }
}

