/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.exception.HoodieException;

public class ReflectionUtils {
    private static Map<String, Class<?>> clazzCache = new HashMap();

    private static Class<?> getClass(String clazzName) {
        if (!clazzCache.containsKey(clazzName)) {
            try {
                Class<?> clazz = Class.forName(clazzName);
                clazzCache.put(clazzName, clazz);
            }
            catch (ClassNotFoundException e) {
                throw new HoodieException("Unable to load class", e);
            }
        }
        return clazzCache.get(clazzName);
    }

    public static <T> T loadClass(String fqcn) {
        try {
            return (T)ReflectionUtils.getClass(fqcn).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new HoodieException("Could not load class " + fqcn, e);
        }
    }

    public static <T extends HoodieRecordPayload> T loadPayload(String recordPayloadClass, Object[] payloadArgs, Class<?> ... constructorArgTypes) {
        try {
            return (T)((HoodieRecordPayload)ReflectionUtils.getClass(recordPayloadClass).getConstructor(constructorArgTypes).newInstance(payloadArgs));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new HoodieException("Unable to instantiate payload class ", e);
        }
    }

    public static Object loadClass(String clazz, Class<?>[] constructorArgTypes, Object ... constructorArgs) {
        try {
            return ReflectionUtils.getClass(clazz).getConstructor(constructorArgTypes).newInstance(constructorArgs);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new HoodieException("Unable to instantiate class ", e);
        }
    }

    public static Object loadClass(String clazz, Object ... constructorArgs) {
        Class[] constructorArgTypes = (Class[])Arrays.stream(constructorArgs).map(Object::getClass).toArray(Class[]::new);
        return ReflectionUtils.loadClass(clazz, constructorArgTypes, constructorArgs);
    }

    public static Stream<String> getTopLevelClassesInClasspath(Class clazz) {
        try {
            ClassPath classPath = ClassPath.from((ClassLoader)clazz.getClassLoader());
            return classPath.getTopLevelClasses().stream().map(ClassPath.ClassInfo::getName);
        }
        catch (IOException e) {
            throw new RuntimeException("Got exception while dumping top level classes", e);
        }
    }
}

