/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.CRC32;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.SizeEstimator;
import org.apache.hudi.common.util.collection.DiskBasedMap;
import org.apache.hudi.common.util.collection.io.storage.SizeAwareDataOutputStream;
import org.apache.hudi.exception.HoodieCorruptedDataException;

public class SpillableMapUtils {
    public static byte[] readBytesFromDisk(RandomAccessFile file, long valuePosition, int valueLength) throws IOException {
        DiskBasedMap.FileEntry fileEntry = SpillableMapUtils.readInternal(file, valuePosition, valueLength);
        return fileEntry.getValue();
    }

    private static DiskBasedMap.FileEntry readInternal(RandomAccessFile file, long valuePosition, int valueLength) throws IOException {
        file.seek(valuePosition);
        long crc = file.readLong();
        long timestamp = file.readLong();
        int keySize = file.readInt();
        int valueSize = file.readInt();
        byte[] key = new byte[keySize];
        file.readFully(key, 0, keySize);
        byte[] value = new byte[valueSize];
        if (valueSize != valueLength) {
            throw new HoodieCorruptedDataException("unequal size of payload written to external file, data may be corrupted");
        }
        file.readFully(value, 0, valueSize);
        long crcOfReadValue = SpillableMapUtils.generateChecksum(value);
        if (crc != crcOfReadValue) {
            throw new HoodieCorruptedDataException("checksum of payload written to external disk does not match, data may be corrupted");
        }
        return new DiskBasedMap.FileEntry(crc, keySize, valueSize, key, value, timestamp);
    }

    public static long spillToDisk(SizeAwareDataOutputStream outputStream, DiskBasedMap.FileEntry fileEntry) throws IOException {
        return SpillableMapUtils.spill(outputStream, fileEntry);
    }

    private static long spill(SizeAwareDataOutputStream outputStream, DiskBasedMap.FileEntry fileEntry) throws IOException {
        outputStream.writeLong(fileEntry.getCrc());
        outputStream.writeLong(fileEntry.getTimestamp());
        outputStream.writeInt(fileEntry.getSizeOfKey());
        outputStream.writeInt(fileEntry.getSizeOfValue());
        outputStream.write(fileEntry.getKey());
        outputStream.write(fileEntry.getValue());
        return outputStream.getSize();
    }

    public static long generateChecksum(byte[] data) {
        CRC32 crc = new CRC32();
        crc.update(data);
        return crc.getValue();
    }

    public static <R> long computePayloadSize(R value, SizeEstimator<R> valueSizeEstimator) throws IOException {
        return valueSizeEstimator.sizeEstimate(value);
    }

    public static <R> R convertToHoodieRecordPayload(GenericRecord rec, String payloadClazz) {
        String recKey = rec.get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
        String partitionPath = rec.get(HoodieRecord.PARTITION_PATH_METADATA_FIELD).toString();
        HoodieRecord hoodieRecord = new HoodieRecord(new HoodieKey(recKey, partitionPath), ReflectionUtils.loadPayload(payloadClazz, new Object[]{Option.of(rec)}, Option.class));
        return (R)hoodieRecord;
    }

    public static <R> R generateEmptyPayload(String recKey, String partitionPath, String payloadClazz) {
        HoodieRecord hoodieRecord = new HoodieRecord(new HoodieKey(recKey, partitionPath), ReflectionUtils.loadPayload(payloadClazz, new Object[]{Option.empty()}, Option.class));
        return (R)hoodieRecord;
    }
}

