/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.versioning;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.common.versioning.VersionMigrator;

public class MetadataMigrator<T> {
    private final Map<Integer, VersionMigrator<T>> migrators;
    private final Integer latestVersion;
    private final Integer oldestVersion;

    public MetadataMigrator(HoodieTableMetaClient metaClient, List<VersionMigrator<T>> migratorList) {
        this.migrators = migratorList.stream().map(m -> Pair.of(m.getManagedVersion(), m)).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        this.latestVersion = (Integer)this.migrators.keySet().stream().reduce((x, y) -> x > y ? x : y).get();
        this.oldestVersion = (Integer)this.migrators.keySet().stream().reduce((x, y) -> x < y ? x : y).get();
    }

    public T upgradeToLatest(T metadata, int metadataVersion) {
        if (metadataVersion == this.latestVersion) {
            return metadata;
        }
        for (int newVersion = metadataVersion + 1; newVersion <= this.latestVersion; ++newVersion) {
            VersionMigrator<T> upgrader = this.migrators.get(newVersion);
            metadata = upgrader.upgradeFrom(metadata);
        }
        return metadata;
    }

    public T migrateToVersion(T metadata, int metadataVersion, int targetVersion) {
        Preconditions.checkArgument((targetVersion >= this.oldestVersion ? 1 : 0) != 0);
        Preconditions.checkArgument((targetVersion <= this.latestVersion ? 1 : 0) != 0);
        if (metadataVersion == targetVersion) {
            return metadata;
        }
        if (metadataVersion > targetVersion) {
            return this.dowgradeToVersion(metadata, metadataVersion, targetVersion);
        }
        return this.upgradeToVersion(metadata, metadataVersion, targetVersion);
    }

    private T upgradeToVersion(T metadata, int metadataVersion, int targetVersion) {
        for (int newVersion = metadataVersion + 1; newVersion <= targetVersion; ++newVersion) {
            VersionMigrator<T> upgrader = this.migrators.get(newVersion);
            metadata = upgrader.upgradeFrom(metadata);
        }
        return metadata;
    }

    private T dowgradeToVersion(T metadata, int metadataVersion, int targetVersion) {
        for (int newVersion = metadataVersion - 1; newVersion >= targetVersion; --newVersion) {
            VersionMigrator<T> downgrader = this.migrators.get(newVersion);
            metadata = downgrader.downgradeFrom(metadata);
        }
        return metadata;
    }
}

