/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile.text;

import com.facebook.presto.rcfile.ColumnData;
import com.facebook.presto.rcfile.EncodeOutput;
import com.facebook.presto.rcfile.text.TextColumnEncoding;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimePrinter;

public class TimestampEncoding
implements TextColumnEncoding {
    private static final DateTimeFormatter HIVE_TIMESTAMP_PARSER;
    private final DateTimeFormatter dateTimeFormatter;
    private final Type type;
    private final Slice nullSequence;
    private final StringBuilder buffer = new StringBuilder();

    public TimestampEncoding(Type type, Slice nullSequence, DateTimeZone hiveStorageTimeZone) {
        this.type = type;
        this.nullSequence = nullSequence;
        this.dateTimeFormatter = HIVE_TIMESTAMP_PARSER.withZone(hiveStorageTimeZone);
    }

    @Override
    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                output.writeBytes(this.nullSequence);
            } else {
                long millis = this.type.getLong(block, position);
                this.buffer.setLength(0);
                this.dateTimeFormatter.printTo(this.buffer, millis);
                for (int index = 0; index < this.buffer.length(); ++index) {
                    output.writeByte((int)this.buffer.charAt(index));
                }
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public void encodeValueInto(int depth, Block block, int position, SliceOutput output) {
        long millis = this.type.getLong(block, position);
        this.buffer.setLength(0);
        this.dateTimeFormatter.printTo(this.buffer, millis);
        for (int index = 0; index < this.buffer.length(); ++index) {
            output.writeByte((int)this.buffer.charAt(index));
        }
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int offset = columnData.getOffset(i);
            int length = columnData.getLength(i);
            if (length == 0 || this.nullSequence.equals(0, this.nullSequence.length(), slice, offset, length)) {
                builder.appendNull();
                continue;
            }
            this.type.writeLong(builder, this.parseTimestamp(slice, offset, length));
        }
        return builder.build();
    }

    @Override
    public void decodeValueInto(int depth, BlockBuilder builder, Slice slice, int offset, int length) {
        long millis = this.parseTimestamp(slice, offset, length);
        this.type.writeLong(builder, millis);
    }

    private long parseTimestamp(Slice slice, int offset, int length) {
        return this.dateTimeFormatter.parseMillis(new String(slice.getBytes(offset, length), 0));
    }

    static {
        DateTimeParser[] timestampWithoutTimeZoneParser = new DateTimeParser[]{DateTimeFormat.forPattern((String)"yyyy-M-d").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s.SSS").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s.SSSSSSS").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s.SSSSSSSSS").getParser()};
        DateTimePrinter timestampWithoutTimeZonePrinter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSSSSS").getPrinter();
        HIVE_TIMESTAMP_PARSER = new DateTimeFormatterBuilder().append(timestampWithoutTimeZonePrinter, timestampWithoutTimeZoneParser).toFormatter().withZoneUTC();
    }
}

