/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.client;

import com.facebook.drift.TApplicationException;
import com.facebook.drift.TException;
import com.facebook.drift.client.DriftMethodHandler;
import com.facebook.drift.client.UncheckedTApplicationException;
import com.facebook.drift.client.UncheckedTException;
import com.facebook.drift.client.UncheckedTProtocolException;
import com.facebook.drift.client.UncheckedTTransportException;
import com.facebook.drift.protocol.TProtocolException;
import com.facebook.drift.protocol.TTransportException;
import com.facebook.drift.transport.client.DriftApplicationException;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

class DriftInvocationHandler
implements InvocationHandler {
    private static final Object[] NO_ARGS = new Object[0];
    private final String serviceName;
    private final Map<Method, DriftMethodHandler> methods;
    private final Optional<String> addressSelectionContext;
    private final Map<String, String> headers;

    public DriftInvocationHandler(String serviceName, Map<Method, DriftMethodHandler> methods, Optional<String> addressSelectionContext, Map<String, String> headers) {
        this.serviceName = Objects.requireNonNull(serviceName, "serviceName is null");
        this.methods = ImmutableMap.copyOf(Objects.requireNonNull(methods, "methods is null"));
        this.addressSelectionContext = Objects.requireNonNull(addressSelectionContext, "addressSelectionContext is null");
        this.headers = ImmutableMap.copyOf(Objects.requireNonNull(headers, "headers is null"));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            switch (method.getName()) {
                case "toString": {
                    return this.serviceName;
                }
                case "equals": {
                    return Proxy.isProxyClass(args[0].getClass()) && Proxy.getInvocationHandler(args[0]) == this;
                }
                case "hashCode": {
                    return System.identityHashCode(this);
                }
            }
            throw new UnsupportedOperationException(method.getName());
        }
        if (args == null) {
            args = NO_ARGS;
        }
        if (args.length == 0 && "close".equals(method.getName())) {
            return null;
        }
        DriftMethodHandler methodHandler = this.methods.get(method);
        try {
            if (methodHandler == null) {
                throw new TApplicationException(TApplicationException.Type.UNKNOWN_METHOD, "Unknown method: " + method);
            }
            ListenableFuture<Object> future = methodHandler.invoke(this.addressSelectionContext, this.headers, Arrays.asList(args));
            if (methodHandler.isAsync()) {
                return DriftInvocationHandler.unwrapUserException(future);
            }
            try {
                return future.get();
            }
            catch (ExecutionException e) {
                throw DriftInvocationHandler.unwrapUserException(e.getCause());
            }
        }
        catch (Exception e) {
            TException wrappedException;
            boolean canThrowTException = false;
            for (Class<?> exceptionType : method.getExceptionTypes()) {
                if (exceptionType.isAssignableFrom(e.getClass())) {
                    throw e;
                }
                canThrowTException = canThrowTException || exceptionType == TException.class;
            }
            if (e instanceof TApplicationException) {
                throw new UncheckedTApplicationException((TApplicationException)e);
            }
            if (e instanceof TProtocolException) {
                throw new UncheckedTProtocolException((TProtocolException)e);
            }
            if (e instanceof TTransportException) {
                throw new UncheckedTTransportException((TTransportException)e);
            }
            if (e instanceof TException) {
                throw new UncheckedTException((TException)e);
            }
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                wrappedException = new TException("Thread interrupted", (Throwable)e);
            } else {
                wrappedException = new TException(e.getMessage(), (Throwable)e);
            }
            if (canThrowTException) {
                throw wrappedException;
            }
            throw new UncheckedTException(wrappedException);
        }
    }

    private static ListenableFuture<Object> unwrapUserException(ListenableFuture<Object> future) {
        final SettableFuture result = SettableFuture.create();
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object value) {
                result.set(value);
            }

            public void onFailure(Throwable t) {
                result.setException(DriftInvocationHandler.unwrapUserException(t));
            }
        }, (Executor)MoreExecutors.directExecutor());
        return result;
    }

    static Throwable unwrapUserException(Throwable t) {
        return t instanceof DriftApplicationException ? t.getCause() : t;
    }
}

