/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xerial.core.XerialException;
import org.xerial.json.JSONEvent;
import org.xerial.json.JSONPullParser;
import org.xerial.util.ArrayDeque;
import org.xerial.util.log.Logger;
import org.xerial.util.tree.TreeEvent;
import org.xerial.util.tree.TreeStreamReader;
import org.xerial.util.tree.impl.TreeEventQueue;

public class JSONStreamReader
implements TreeStreamReader {
    private static Logger _logger = Logger.getLogger(JSONStreamReader.class);
    private final JSONPullParser jsonPullParser;
    private final TreeEventQueue eventQueue = new TreeEventQueue();
    private JSONEvent lastEvent = null;
    private ArrayDeque<TreeEvent> pendingEventQueue = new ArrayDeque();

    public JSONStreamReader(Reader reader) throws IOException {
        this.jsonPullParser = new JSONPullParser(reader);
    }

    public JSONStreamReader(InputStream inputStream) throws IOException {
        this.jsonPullParser = new JSONPullParser(inputStream);
    }

    @Override
    public TreeEvent peekNext() throws XerialException {
        if (!this.eventQueue.isEmpty()) {
            return this.eventQueue.peekFirst();
        }
        if (this.lastEvent == JSONEvent.EndJSON) {
            return null;
        }
        this.readNext();
        return this.peekNext();
    }

    @Override
    public TreeEvent next() throws XerialException {
        if (!this.eventQueue.isEmpty()) {
            TreeEvent treeEvent = this.eventQueue.pop();
            return treeEvent;
        }
        if (this.lastEvent == JSONEvent.EndJSON) {
            return null;
        }
        this.readNext();
        return this.next();
    }

    private void flushPendingEvent() {
        while (!this.pendingEventQueue.isEmpty()) {
            this.eventQueue.push(this.pendingEventQueue.removeFirst());
        }
    }

    private void readNext() throws XerialException {
        if (this.lastEvent == JSONEvent.EndJSON) {
            return;
        }
        this.lastEvent = this.jsonPullParser.next();
        switch (this.lastEvent) {
            case StartObject: {
                this.flushPendingEvent();
                String string = this.jsonPullParser.getKeyName();
                this.pendingEventQueue.addLast(TreeEvent.newVisitEvent(string, null));
                break;
            }
            case EndObject: {
                this.flushPendingEvent();
                String string = this.jsonPullParser.getKeyName();
                this.eventQueue.push(TreeEvent.newLeaveEvent(string));
                break;
            }
            case String: 
            case Integer: 
            case Double: 
            case True: 
            case False: 
            case Null: {
                String string;
                String string2 = this.jsonPullParser.getKeyName();
                String string3 = string = this.lastEvent != JSONEvent.Null ? this.jsonPullParser.getText() : null;
                if (string2 != null && string2.equals("value") && !this.pendingEventQueue.isEmpty()) {
                    TreeEvent treeEvent = this.pendingEventQueue.peekLast();
                    if (treeEvent.event == TreeEvent.EventType.VISIT) {
                        this.pendingEventQueue.removeLast();
                        this.pendingEventQueue.addLast(TreeEvent.newVisitEvent(treeEvent.nodeName, string));
                        break;
                    }
                }
                this.flushPendingEvent();
                this.eventQueue.push(TreeEvent.newVisitEvent(string2, string));
                this.eventQueue.push(TreeEvent.newLeaveEvent(string2));
                break;
            }
        }
    }
}

