/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.json;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedList;
import java.util.ListIterator;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialError;
import org.xerial.json.JSONErrorCode;
import org.xerial.json.JSONUtil;

public class JSONWriter {
    private final PrintWriter writer;
    private final LinkedList<JSONState> stateStack = new LinkedList();
    private final LinkedList<Integer> elementCountStack = new LinkedList();

    public JSONWriter(Writer writer) {
        this.writer = new PrintWriter(writer);
        this.stateStack.add(JSONState.Root);
        this.elementCountStack.add(0);
    }

    private void pushState(JSONState jSONState) {
        this.stateStack.add(jSONState);
        this.elementCountStack.add(0);
    }

    private void popState() {
        this.stateStack.removeLast();
        this.elementCountStack.removeLast();
    }

    private JSONState getCurrentState() {
        if (this.stateStack.isEmpty()) {
            return JSONState.Unknown;
        }
        return this.stateStack.getLast();
    }

    private int getPreviousElementCount() {
        return this.elementCountStack.isEmpty() ? 0 : this.elementCountStack.getLast();
    }

    private void incrementElementCount() {
        int n = this.elementCountStack.removeLast();
        this.elementCountStack.add(++n);
    }

    public void startObject() {
        if (this.getCurrentState() == JSONState.InArray) {
            this.putComma();
        }
        this.writer.print("{");
        this.pushState(JSONState.InObject);
    }

    public void endObject() {
        if (this.getCurrentState() != JSONState.InObject) {
            throw new XerialError((ErrorCode)JSONErrorCode.NotInAJSONObject, "cannot end the object outside of the JSON object");
        }
        this.writer.print("}");
        this.popState();
        if (this.getCurrentState() == JSONState.InArray) {
            this.incrementElementCount();
        }
    }

    public void startArray() {
        this.writer.print("[");
        this.pushState(JSONState.InArray);
    }

    public void endArray() {
        if (this.getCurrentState() != JSONState.InArray) {
            throw new XerialError((ErrorCode)JSONErrorCode.NotInAJSONArray, "cannot end the arry outside of the JSON array");
        }
        this.writer.print("]");
        this.popState();
    }

    public void startString() {
        if (this.getCurrentState() == JSONState.InArray) {
            throw new XerialError((ErrorCode)JSONErrorCode.NotInAJSONArray, "cannot start a new string value outside of the JSON array in this method");
        }
        this.putComma();
        this.writer.append("\"");
        this.pushState(JSONState.InString);
    }

    public void startString(String string) {
        this.putKeyPart(string);
        this.writer.append("\"");
        this.pushState(JSONState.InString);
    }

    public void append(String string) {
        if (this.getCurrentState() != JSONState.InString) {
            throw new XerialError((ErrorCode)JSONErrorCode.NotInAJSONString, "cannot append any string before invoking startString() method");
        }
        this.writer.append(string);
    }

    public void endString() {
        if (this.getCurrentState() != JSONState.InString) {
            throw new XerialError((ErrorCode)JSONErrorCode.NotInAJSONString, "cannot end the string not beginning from startString() method.");
        }
        this.writer.append("\"");
        this.popState();
    }

    public void startArray(String string) {
        if (this.getCurrentState() != JSONState.InObject) {
            throw new XerialError((ErrorCode)JSONErrorCode.NotInAJSONObject, "cannot start a keyed array outside of the JSON object");
        }
        if (this.getPreviousElementCount() > 0) {
            this.writer.print(",");
        }
        this.writer.print(this.doubleQuote(string));
        this.writer.print(":[");
        this.incrementElementCount();
        this.pushState(JSONState.InArray);
    }

    public void add(String string) {
        this.addInternal(this.doubleQuote(string));
    }

    public void add(int n) {
        this.addInternal(n);
    }

    public void add(long l) {
        this.addInternal(l);
    }

    public void add(double d) {
        this.addInternal(d);
    }

    public void add(float f) {
        this.addInternal(Float.valueOf(f));
    }

    public void add(boolean bl) {
        if (bl) {
            this.addInternal("true");
        } else {
            this.addInternal("false");
        }
    }

    public void addNull() {
        this.addInternal("null");
    }

    public void addObject(Object object) {
        String string = JSONUtil.toJSON(object);
        this.addInternal(string);
    }

    private void addInternal(Object object) {
        this.putComma();
        if (object != null) {
            this.writer.append(object.toString());
        } else {
            this.writer.append("null");
        }
        this.incrementElementCount();
    }

    private void putComma() {
        if (this.getPreviousElementCount() > 0) {
            this.writer.print(",");
        }
    }

    public void put(String string, String string2) {
        this.putInternal(string, this.doubleQuote(string2));
    }

    public void put(String string, int n) {
        this.putInternal(string, n);
    }

    public void put(String string, float f) {
        this.putInternal(string, Float.valueOf(f));
    }

    public void put(String string, double d) {
        this.putInternal(string, d);
    }

    public void put(String string, long l) {
        this.putInternal(string, l);
    }

    public void put(String string, boolean bl) {
        if (bl) {
            this.putInternal(string, "true");
        } else {
            this.putInternal(string, "false");
        }
    }

    public void putObject(String string, Object object) {
        if (object == null) {
            return;
        }
        this.putInternal(string, JSONUtil.toJSON(object));
    }

    public void putNull(String string) {
        this.putInternal(string, "null");
    }

    public void putString(String string, Reader reader) throws IOException {
        int n;
        this.putKeyPart(string);
        this.writer.append("\"");
        while ((n = reader.read()) != -1) {
            this.writer.append((char)n);
        }
        this.writer.append("\"");
    }

    private void putInternal(String string, Object object) {
        this.putKeyPart(string);
        this.writer.append(object.toString());
        this.incrementElementCount();
    }

    private void putKeyPart(String string) {
        if (this.getCurrentState() != JSONState.InObject) {
            throw new XerialError((ErrorCode)JSONErrorCode.NotInAJSONObject, "cannot add key and value pair outside of the JSON object");
        }
        if (this.getPreviousElementCount() > 0) {
            this.writer.append(",");
        }
        this.writer.append(this.doubleQuote(string));
        this.writer.append(":");
        this.incrementElementCount();
    }

    public void startObject(String string) {
        this.putKeyPart(string);
        this.startObject();
    }

    public void flush() {
        this.writer.flush();
    }

    public void endJSON() {
        ListIterator<JSONState> listIterator = this.stateStack.listIterator(this.stateStack.size());
        while (listIterator.hasPrevious()) {
            JSONState jSONState = listIterator.previous();
            switch (jSONState) {
                case InObject: {
                    this.writer.append("}");
                    break;
                }
                case InArray: {
                    this.writer.append("]");
                    break;
                }
                case InString: {
                    this.writer.append("\"");
                }
            }
        }
        this.flush();
    }

    private String doubleQuote(String string) {
        return "\"" + string + "\"";
    }

    public Writer getWriter() {
        return this.writer;
    }

    static enum JSONState {
        InObject,
        InArray,
        InString,
        Root,
        Unknown;

    }
}

