/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialError;
import org.xerial.core.XerialErrorCode;
import org.xerial.core.XerialException;
import org.xerial.util.Pair;
import org.xerial.util.TypeConverter;
import org.xerial.util.TypeInfo;

public class ReflectionUtil {
    public static void setValue(Object object, Method method, Object object2) {
        try {
            try {
                method.invoke(object, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                method.setAccessible(true);
                try {
                    method.invoke(object, object2);
                }
                catch (IllegalAccessException illegalAccessException2) {
                    throw new IllegalAccessError(illegalAccessException2.getMessage());
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new XerialError((ErrorCode)XerialErrorCode.WRONG_DATA_TYPE, (Throwable)invocationTargetException);
        }
    }

    public static Object getFieldValue(Object object, Field field) {
        Object object2 = null;
        try {
            object2 = field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            field.setAccessible(true);
            try {
                object2 = field.get(object);
            }
            catch (IllegalAccessException illegalAccessException2) {
                throw new IllegalAccessError(illegalAccessException2.getMessage());
            }
        }
        return object2;
    }

    public static Object invokeGetter(Object object, Method method) {
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new XerialError((ErrorCode)XerialErrorCode.INVALID_STATE, "not a getter (0-arg public method): " + method);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (XerialError.class.isInstance(throwable)) {
                throw (XerialError)XerialError.class.cast(throwable);
            }
            throw new XerialError((ErrorCode)XerialErrorCode.WRONG_DATA_TYPE, invocationTargetException.getTargetException());
        }
    }

    public static Object invokeGetter(Object object, Method method, Object object2) {
        try {
            return method.invoke(object, object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new XerialError((ErrorCode)XerialErrorCode.INVALID_STATE, "not a getter (0-arg public method): " + method);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (XerialError.class.isInstance(throwable)) {
                throw (XerialError)XerialError.class.cast(throwable);
            }
            throw new XerialError((ErrorCode)XerialErrorCode.WRONG_DATA_TYPE, invocationTargetException.getTargetException());
        }
    }

    public static Type getGenericCollectionElementType(Field field) {
        if (!TypeInfo.isCollection(field.getType())) {
            throw new XerialError((ErrorCode)XerialErrorCode.NOT_A_COLLECTION, field.getType().getName());
        }
        Type type = field.getGenericType();
        if (ReflectionUtil.hasGenericTypes(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            return parameterizedType.getActualTypeArguments()[0];
        }
        return Object.class;
    }

    public static boolean hasGenericTypes(Type type) {
        return ParameterizedType.class.isInstance(type);
    }

    public static Type[] getGenericParameterTypes(Type type) {
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            return parameterizedType.getActualTypeArguments();
        }
        return null;
    }

    public static Class<?> getGenericArgumentType(Method method, int n) {
        Type[] typeArray = method.getGenericParameterTypes();
        if (typeArray.length < n) {
            throw new XerialError((ErrorCode)XerialErrorCode.INVALID_INPUT, method.toGenericString());
        }
        if (ParameterizedType.class.isInstance(typeArray[n])) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(typeArray[n]);
            return ReflectionUtil.toClassType(parameterizedType.getActualTypeArguments()[0]);
        }
        return Object.class;
    }

    public static Type getGenericCollectionElementRawType(Field field) {
        if (!TypeInfo.isCollection(field.getType())) {
            throw new XerialError((ErrorCode)XerialErrorCode.NOT_A_COLLECTION, field.getType().getName());
        }
        Type type = field.getGenericType();
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            return parameterizedType.getActualTypeArguments()[0];
        }
        return Object.class;
    }

    private static Class<?> toClassType(Type type) {
        if (Class.class.isInstance(type)) {
            return (Class)type;
        }
        return Object.class;
    }

    public static Class<?> getRawClass(Type type) {
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            return ReflectionUtil.toClassType(parameterizedType.getRawType());
        }
        return ReflectionUtil.toClassType(type);
    }

    public static Pair<Class<?>, Class<?>> getGenericMapElementClasses(Field field) {
        Pair<Type, Type> pair = ReflectionUtil.getGenericMapElementTypes(field);
        return new Pair((Class<?>)Class.class.cast(pair.getFirst()), (Class<?>)Class.class.cast(pair.getSecond()));
    }

    public static Pair<Type, Type> getGenericMapElementTypes(Field field) {
        if (!TypeInfo.isMap(field.getType())) {
            throw new XerialError((ErrorCode)XerialErrorCode.INVALID_INPUT, "not a map type: " + field);
        }
        Type type = field.getGenericType();
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            if (typeArray.length != 2) {
                throw new XerialError((ErrorCode)XerialErrorCode.INVALID_STATE, "not a Map<Key, Value> type: " + field);
            }
            return new Pair<Type, Type>(typeArray[0], typeArray[1]);
        }
        return new Pair<Class<Object>, Class<Object>>(Object.class, Object.class);
    }

    public static void initializeCollectionField(Object object, Field field) throws XerialException {
        Class<?> clazz = field.getType();
        if (!TypeInfo.isCollection(clazz)) {
            return;
        }
        Object object2 = ReflectionUtil.getFieldValue(object, field);
        if (object2 == null) {
            object2 = TypeInfo.createInstance(clazz);
            ReflectionUtil.setFieldValue_internal(object, field, object2);
        }
    }

    public static void setFieldValue(Object object, Field field, Object object2) throws XerialException {
        block9: {
            try {
                Class<?> clazz = field.getType();
                if (TypeInfo.isCollection(clazz)) {
                    Object object3 = ReflectionUtil.getFieldValue(object, field);
                    if (object3 == null) {
                        object3 = TypeInfo.createInstance(clazz);
                        ReflectionUtil.setFieldValue_internal(object, field, object3);
                    }
                    try {
                        Method method = field.getType().getMethod("add", Object.class);
                        Type type = ReflectionUtil.getGenericCollectionElementType(field);
                        Object obj = TypeConverter.convertType(ReflectionUtil.getRawClass(type), object2);
                        method.invoke(object3, obj);
                        break block9;
                    }
                    catch (SecurityException securityException) {
                        throw new XerialError((ErrorCode)XerialErrorCode.INACCESSIBLE_METHOD, "add() of " + clazz.getName());
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new XerialError((ErrorCode)XerialErrorCode.NOT_A_COLLECTION, clazz.getName());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new XerialError((ErrorCode)XerialErrorCode.INACCESSIBLE_METHOD, "add() of " + clazz.getName());
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new XerialError((ErrorCode)XerialErrorCode.INACCESSIBLE_METHOD, (Throwable)invocationTargetException);
                    }
                }
                Object obj = TypeConverter.convertType(clazz, object2);
                ReflectionUtil.setFieldValue_internal(object, field, obj);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XerialException((ErrorCode)XerialErrorCode.WRONG_DATA_TYPE, (Throwable)illegalArgumentException);
            }
        }
    }

    private static void setFieldValue_internal(Object object, Field field, Object object2) {
        try {
            field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            field.setAccessible(true);
            try {
                field.set(object, object2);
            }
            catch (IllegalAccessException illegalAccessException2) {
                throw new IllegalAccessError(illegalAccessException2.getMessage());
            }
        }
    }

    public static void setMapEntry(Object object, Field field, Object object2, Object object3) throws XerialException {
        ReflectionUtil.initializeCollectionField(object, field);
        Object object4 = ReflectionUtil.getFieldValue(object, field);
        if (object4 == null) {
            throw new XerialException((ErrorCode)XerialErrorCode.INVALID_STATE, "cannot set (key, value) to null Map field: " + object);
        }
        Pair<Class<?>, Class<?>> pair = ReflectionUtil.getGenericMapElementClasses(field);
        Class<?> clazz = pair.getFirst();
        Class<?> clazz2 = pair.getSecond();
        Map map = (Map)Map.class.cast(object4);
        map.put(TypeConverter.convertType(clazz, object2), TypeConverter.convertType(clazz2, object3));
    }
}

