/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util;

public class StopWatch {
    private long lastSystemTime;
    private long accumulatedElapsedTime;
    private State state = State.RUNNING;
    private static final double NANO_UNIT = 1.0E9;

    public StopWatch() {
        this.reset();
    }

    public double getElapsedTime() {
        if (this.state == State.RUNNING) {
            long l = System.nanoTime();
            long l2 = l - this.lastSystemTime;
            return (double)(this.accumulatedElapsedTime + l2) / 1.0E9;
        }
        return (double)this.accumulatedElapsedTime / 1.0E9;
    }

    public void reset() {
        this.lastSystemTime = System.nanoTime();
        this.accumulatedElapsedTime = 0L;
    }

    public void stop() {
        if (this.state == State.STOPPED) {
            return;
        }
        long l = System.nanoTime();
        this.accumulatedElapsedTime += l - this.lastSystemTime;
        this.lastSystemTime = l;
        this.state = State.STOPPED;
    }

    public void resume() {
        if (this.state == State.RUNNING) {
            return;
        }
        this.lastSystemTime = System.nanoTime();
        this.state = State.RUNNING;
    }

    public String reportElapsedTime() {
        return String.format("%.2f sec.", this.getElapsedTime());
    }

    static enum State {
        RUNNING,
        STOPPED;

    }
}

